/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkType
implements SdkTypeId {
    public static final ExtensionPointName<SdkType> EP_NAME = ExtensionPointName.create((String)"com.intellij.sdkType");
    private static final Comparator<Sdk> ALPHABETICAL_COMPARATOR = (sdk1, sdk2) -> StringUtil.compare((String)sdk1.getName(), (String)sdk2.getName(), (boolean)true);
    private final String myName;

    public SdkType(@NotNull String name) {
        if (name == null) {
            SdkType.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @Nullable
    public abstract String suggestHomePath();

    @NotNull
    public Collection<String> suggestHomePaths() {
        String home = this.suggestHomePath();
        List<String> list = home != null ? Collections.singletonList(home) : Collections.emptyList();
        if (list == null) {
            SdkType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            SdkType.$$$reportNull$$$0(2);
        }
        String string = homePath;
        if (string == null) {
            SdkType.$$$reportNull$$$0(3);
        }
        return string;
    }

    public abstract boolean isValidSdkHome(String var1);

    @Override
    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(4);
        }
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        return null;
    }

    public abstract String suggestSdkName(String var1, String var2);

    @NotNull
    public Comparator<Sdk> getComparator() {
        Comparator<Sdk> comparator = ALPHABETICAL_COMPARATOR;
        if (comparator == null) {
            SdkType.$$$reportNull$$$0(5);
        }
        return comparator;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(6);
        }
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(7);
        }
        this.setupSdkPaths(sdk);
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel var1, @NotNull SdkModificator var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, Element additional) {
        if (currentSdk == null) {
            SdkType.$$$reportNull$$$0(9);
        }
        return this.loadAdditionalData(additional);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SdkType.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.jdks" == null) {
            SdkType.$$$reportNull$$$0(11);
        }
        return "preferences.jdks";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = IconUtil.getAddIcon();
        if (icon == null) {
            SdkType.$$$reportNull$$$0(12);
        }
        return icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            @Override
            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = SdkType.this.isValidSdkHome(SdkType.this.adjustSelectedSdkHome(selectedPath)))) {
                    String message = files[0].isDirectory() ? ProjectBundle.message("sdk.configure.home.invalid.error", SdkType.this.getPresentableName()) : ProjectBundle.message("sdk.configure.home.file.invalid.error", SdkType.this.getPresentableName());
                    throw new Exception(message);
                }
            }
        };
        descriptor.setTitle(ProjectBundle.message("sdk.configure.home.title", this.getPresentableName()));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            SdkType.$$$reportNull$$$0(13);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public String getHomeFieldLabel() {
        String string = ProjectBundle.message("sdk.configure.type.home.path", this.getPresentableName());
        if (string == null) {
            SdkType.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return null;
    }

    @NotNull
    public static SdkType[] getAllTypes() {
        ArrayList allTypes = new ArrayList();
        Collections.addAll(allTypes, ApplicationManager.getApplication().getComponents(SdkType.class));
        Collections.addAll(allTypes, Extensions.getExtensions(EP_NAME));
        SdkType[] sdkTypeArray = allTypes.toArray(new SdkType[0]);
        if (sdkTypeArray == null) {
            SdkType.$$$reportNull$$$0(16);
        }
        return sdkTypeArray;
    }

    @NotNull
    public static <T extends SdkType> T findInstance(@NotNull Class<T> sdkTypeClass) {
        if (sdkTypeClass == null) {
            SdkType.$$$reportNull$$$0(17);
        }
        for (SdkType sdkType : (SdkType[])Extensions.getExtensions(EP_NAME)) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            SdkType sdkType2 = (SdkType)sdkTypeClass.cast(sdkType);
            if (sdkType2 == null) {
                SdkType.$$$reportNull$$$0(18);
            }
            return (T)sdkType2;
        }
        throw new IllegalArgumentException("Unknown SDk type: " + sdkTypeClass);
    }

    public SdkType getDependencyType() {
        return null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            SdkType.$$$reportNull$$$0(19);
        }
        return true;
    }

    public boolean supportsCustomCreateUI() {
        return false;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(20);
        }
        if (parentComponent == null) {
            SdkType.$$$reportNull$$$0(21);
        }
        if (sdkCreatedCallback == null) {
            SdkType.$$$reportNull$$$0(22);
        }
        this.showCustomCreateUI(sdkModel, parentComponent, sdkCreatedCallback);
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(23);
        }
        if (parentComponent == null) {
            SdkType.$$$reportNull$$$0(24);
        }
        if (sdkCreatedCallback == null) {
            SdkType.$$$reportNull$$$0(25);
        }
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        VirtualFile homeDir;
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(26);
        }
        return (homeDir = sdk.getHomeDirectory()) != null && homeDir.isValid();
    }

    public String sdkPath(@NotNull VirtualFile homePath) {
        if (homePath == null) {
            SdkType.$$$reportNull$$$0(27);
        }
        return homePath.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SdkType";
                break;
            }
            case 2: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeFieldLabel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

