/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.ide.ui.UISettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowAnchor {
    public static final ToolWindowAnchor TOP = new ToolWindowAnchor("top");
    public static final ToolWindowAnchor LEFT = new ToolWindowAnchor("left");
    public static final ToolWindowAnchor BOTTOM = new ToolWindowAnchor("bottom");
    public static final ToolWindowAnchor RIGHT = new ToolWindowAnchor("right");
    @NotNull
    private final String myText;

    private ToolWindowAnchor(@NonNls @NotNull String text) {
        if (text == null) {
            ToolWindowAnchor.$$$reportNull$$$0(0);
        }
        this.myText = text;
    }

    public String toString() {
        return this.myText;
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM;
    }

    @NotNull
    public static ToolWindowAnchor get(int swingOrientationConstant) {
        switch (swingOrientationConstant) {
            case 1: {
                ToolWindowAnchor toolWindowAnchor = TOP;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(1);
                }
                return toolWindowAnchor;
            }
            case 3: {
                ToolWindowAnchor toolWindowAnchor = BOTTOM;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(2);
                }
                return toolWindowAnchor;
            }
            case 2: {
                ToolWindowAnchor toolWindowAnchor = LEFT;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(3);
                }
                return toolWindowAnchor;
            }
            case 4: {
                ToolWindowAnchor toolWindowAnchor = RIGHT;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(4);
                }
                return toolWindowAnchor;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + swingOrientationConstant);
    }

    public boolean isSplitVertically() {
        return this == LEFT && !UISettings.getInstance().getLeftHorizontalSplit() || this == RIGHT && !UISettings.getInstance().getRightHorizontalSplit();
    }

    @NotNull
    public static ToolWindowAnchor fromText(@Nullable String anchor) {
        for (ToolWindowAnchor a : new ToolWindowAnchor[]{TOP, LEFT, BOTTOM, RIGHT}) {
            if (!a.myText.equals(anchor)) continue;
            ToolWindowAnchor toolWindowAnchor = a;
            if (toolWindowAnchor == null) {
                ToolWindowAnchor.$$$reportNull$$$0(5);
            }
            return toolWindowAnchor;
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/ToolWindowAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/ToolWindowAnchor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

