/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.CommonBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddDeleteListPanel<T>
extends PanelWithButtons
implements ComponentWithEmptyText {
    private final String myTitle;
    protected JButton myAddButton = new JButton(CommonBundle.message((String)"button.add", (Object[])new Object[0]));
    protected JButton myDeleteButton = new JButton(CommonBundle.message((String)"button.delete", (Object[])new Object[0]));
    protected DefaultListModel<T> myListModel = new DefaultListModel();
    protected JBList<T> myList = new JBList<T>(this.myListModel);

    public AddDeleteListPanel(String title, List<T> initialList) {
        this.myTitle = title;
        for (T o : initialList) {
            if (o == null) continue;
            this.myListModel.addElement(o);
        }
        this.myList.setCellRenderer(this.getListCellRenderer());
        this.initPanel();
    }

    @Override
    protected void initPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AddDeleteListPanel.this.addElement(AddDeleteListPanel.this.findItemToAdd());
            }
        });
        this.customizeDecorator(decorator);
        this.setLayout(new BorderLayout());
        this.add((Component)decorator.createPanel(), "Center");
        if (this.myTitle != null) {
            this.setBorder(IdeBorderFactory.createTitledBorder(this.myTitle, false));
        }
    }

    protected void customizeDecorator(ToolbarDecorator decorator) {
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myList.getEmptyText();
        if (statusText == null) {
            AddDeleteListPanel.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    protected void addElement(@Nullable T itemToAdd) {
        if (itemToAdd != null) {
            this.myListModel.addElement(itemToAdd);
            this.myList.setSelectedValue(itemToAdd, true);
        }
    }

    @Nullable
    protected abstract T findItemToAdd();

    public Object[] getListItems() {
        ArrayList<T> items = new ArrayList<T>();
        for (int i = 0; i < this.myListModel.size(); ++i) {
            items.add(this.myListModel.getElementAt(i));
        }
        return items.toArray();
    }

    @Override
    protected String getLabelText() {
        return this.myTitle;
    }

    @Override
    protected JButton[] createButtons() {
        return new JButton[]{this.myAddButton, this.myDeleteButton};
    }

    @Override
    protected JComponent createMainComponent() {
        if (!this.myListModel.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
        return ScrollPaneFactory.createScrollPane(this.myList);
    }

    protected ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AddDeleteListPanel", "getEmptyText"));
    }
}

