/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Function;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CompoundConsumer;
import org.jetbrains.concurrency.InternalPromiseUtil;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016J$\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ4\u0010\u001b\u001a\u00020\r\"\u0004\b\u0001\u0010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u001c0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0002J\b\u0010 \u001a\u00020\rH\u0016J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bH\u0014J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016J \u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0010\u0010&\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000\u0007H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u000e\u0010*\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000#H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\tH\u0016J>\u0010.\u001a\u00020\r\"\u0004\b\u0001\u0010\u00012\u0016\u0010/\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0000\u0012\u0002H\u0001\u0018\u00010\u00070\u00062\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0013\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00028\u0000\u00a2\u0006\u0002\u00102J,\u00103\u001a\b\u0012\u0004\u0012\u0002H40#\"\u0004\b\u0001\u001042\u0016\u0010(\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H405H\u0016J0\u00106\u001a\b\u0012\u0004\u0012\u0002H40#\"\u0004\b\u0001\u001042\u001a\u0010(\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40#05H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0000\u0012\u00020\t\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/InternalPromiseUtil$BasePromise;", "Lorg/jetbrains/concurrency/CancellablePromise;", "()V", "doneRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/function/Consumer;", "rejectedRef", "", "valueRef", "Lorg/jetbrains/concurrency/InternalPromiseUtil$PromiseValue;", "_setValue", "", "value", "addHandlers", "done", "rejected", "assertWriteAction", "message", "", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "callConsumerIfTargeted", "C_T", "targetState", "Lorg/jetbrains/concurrency/Promise$State;", "newConsumer", "cancel", "getValue", "onError", "Lorg/jetbrains/concurrency/Promise;", "errorHandler", "onProcessed", "action", "onSuccess", "handler", "processed", "child", "setError", "", "error", "setHandler", "ref", "setResult", "result", "(Ljava/lang/Object;)V", "then", "SUB_RESULT", "Lcom/intellij/util/Function;", "thenAsync", "intellij.platform.projectModel"})
public class AsyncPromise<T>
extends InternalPromiseUtil.BasePromise<T>
implements CancellablePromise<T> {
    private final AtomicReference<Consumer<? super T>> doneRef = new AtomicReference();
    private final AtomicReference<Consumer<? super Throwable>> rejectedRef = new AtomicReference();
    private final AtomicReference<InternalPromiseUtil.PromiseValue<T>> valueRef = new AtomicReference<Object>(null);

    @Override
    @NotNull
    public Promise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.setHandler(this.doneRef, handler, Promise.State.SUCCEEDED);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> onError(@NotNull Consumer<Throwable> errorHandler) {
        Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
        this.setHandler(this.rejectedRef, errorHandler, Promise.State.REJECTED);
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        InternalPromiseUtil.PromiseValue<T> value = this.valueRef.get();
        if (value != null) {
            if (value.error == null) {
                Promise<Object> promise = Promise.resolve(handler.fun(value.result));
                Intrinsics.checkExpressionValueIsNotNull(promise, (String)"Promise.resolve(handler.`fun`(value.result))");
                return promise;
            }
            AsyncPromise asyncPromise = this;
            if (asyncPromise == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<SUB_RESULT>");
            }
            return asyncPromise;
        }
        AsyncPromise<T> promise = new AsyncPromise<T>();
        this.addHandlers(new Consumer<T>(promise, handler){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Function $handler;

            public final void accept(T result2) {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    if (this.$handler instanceof Obsolescent && ((Obsolescent)this.$handler).isObsolete()) {
                        this.$promise.cancel();
                    } else {
                        this.$promise.setResult(this.$handler.fun(result2));
                    }
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$handler = function;
            }
        }, new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$promise.setError(it);
            }
            {
                this.$promise = asyncPromise;
            }
        });
        return promise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        InternalPromiseUtil.PromiseValue<T> value = this.valueRef.get();
        if (value != null) {
            if (value.error == null) {
                Object object = handler.fun(value.result);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"handler.`fun`(value.result)");
                return (Promise)object;
            }
            AsyncPromise asyncPromise = this;
            if (asyncPromise == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<SUB_RESULT>");
            }
            return asyncPromise;
        }
        AsyncPromise<T> promise = new AsyncPromise<T>();
        Consumer rejectedHandler2 = new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$promise.setError(it);
            }
            {
                this.$promise = asyncPromise;
            }
        };
        this.addHandlers(new Consumer<T>(promise, handler, rejectedHandler2){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Function $handler;
            final /* synthetic */ Consumer $rejectedHandler;

            public final void accept(T it) {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    ((Promise)this.$handler.fun(it)).onSuccess((Consumer)new Consumer<SUB_RESULT>(this, it){
                        final /* synthetic */ thenAsync.1 this$0;
                        final /* synthetic */ Object $it$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$it$inlined = object;
                        }

                        public final void accept(SUB_RESULT it) {
                            AsyncPromise $receiver$iv = this.this$0.$promise;
                            try {
                                this.this$0.$promise.setResult(it);
                            }
                            catch (Throwable e$iv) {
                                $receiver$iv.setError(e$iv);
                            }
                        }
                    }).onError(this.$rejectedHandler);
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$handler = function;
                this.$rejectedHandler = consumer;
            }
        }, rejectedHandler2);
        return promise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        if (child.getState() != Promise.State.PENDING || !(child instanceof AsyncPromise)) {
            return this;
        }
        InternalPromiseUtil.PromiseValue<T> value = this.valueRef.get();
        if (value == null) {
            this.addHandlers(new Consumer<T>(child){
                final /* synthetic */ Promise $child;

                public final void accept(T it) {
                    AsyncPromise $receiver$iv = (AsyncPromise)this.$child;
                    try {
                        ((AsyncPromise)this.$child).setResult(it);
                    }
                    catch (Throwable e$iv) {
                        $receiver$iv.setError(e$iv);
                    }
                }
                {
                    this.$child = promise;
                }
            }, new Consumer<Throwable>(child){
                final /* synthetic */ Promise $child;

                public final void accept(@NotNull Throwable it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ((AsyncPromise)this.$child).setError(it);
                }
                {
                    this.$child = promise;
                }
            });
        } else if (value.error == null) {
            ((AsyncPromise)child).setResult(value.result);
        } else {
            AsyncPromise asyncPromise = (AsyncPromise)child;
            Throwable throwable = value.error;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"value.error");
            asyncPromise.setError(throwable);
        }
        return this;
    }

    private final void addHandlers(Consumer<T> done2, Consumer<Throwable> rejected2) {
        this.setHandler(this.doneRef, done2, Promise.State.SUCCEEDED);
        this.setHandler(this.rejectedRef, rejected2, Promise.State.REJECTED);
    }

    public final void setResult(T result2) {
        this.assertWriteAction("Result must be not set inside write-action");
        if (!this.valueRef.compareAndSet(null, InternalPromiseUtil.PromiseValue.createFulfilled(result2))) {
            return;
        }
        Consumer done2 = this.doneRef.getAndSet(null);
        this.rejectedRef.set(null);
        if (done2 != null && !InternalPromiseUtil.isHandlerObsolete(done2)) {
            done2.accept(result2);
        }
    }

    private final void assertWriteAction(String message) {
        block1: {
            Application application;
            Application application2 = ApplicationManager.getApplication();
            if (application2 == null) break block1;
            Application it = application = application2;
            if (Registry.is((String)"promise.check.write.action", (boolean)false)) {
                AsyncPromiseKt.access$getLOG$p().assertTrue(!it.isWriteAccessAllowed(), (Object)message);
            }
        }
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    @Override
    public void cancel() {
        RuntimeException runtimeException = InternalPromiseUtil.OBSOLETE_ERROR;
        Intrinsics.checkExpressionValueIsNotNull((Object)runtimeException, (String)"InternalPromiseUtil.OBSOLETE_ERROR");
        this.setError(runtimeException);
    }

    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.assertWriteAction("Error must be not set inside write-action");
        if (!this.valueRef.compareAndSet(null, InternalPromiseUtil.PromiseValue.createRejected(error))) {
            Promises.errorIfNotMessage(AsyncPromiseKt.access$getLOG$p(), error);
            return false;
        }
        Consumer rejected2 = this.rejectedRef.getAndSet(null);
        this.doneRef.set(null);
        if (rejected2 == null) {
            Promises.errorIfNotMessage(AsyncPromiseKt.access$getLOG$p(), error);
        } else if (!InternalPromiseUtil.isHandlerObsolete(rejected2)) {
            rejected2.accept(error);
        }
        return true;
    }

    @Override
    @NotNull
    public Promise<T> onProcessed(@NotNull Consumer<? super T> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.onSuccess(new Consumer<T>(action){
            final /* synthetic */ Consumer $action;

            public final void accept(T it) {
                this.$action.accept(it);
            }
            {
                this.$action = consumer;
            }
        });
        this.onError(new Consumer<Throwable>(action){
            final /* synthetic */ Consumer $action;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$action.accept(null);
            }
            {
                this.$action = consumer;
            }
        });
        return this;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        this.assertWriteAction("blockingGet() must be not called inside write-action");
        InternalPromiseUtil.PromiseValue<T> value = this.valueRef.get();
        if (value == null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.onProcessed(new Consumer<T>(latch){
                final /* synthetic */ CountDownLatch $latch;

                public final void accept(@Nullable T it) {
                    this.$latch.countDown();
                }
                {
                    this.$latch = countDownLatch;
                }
            });
            if (timeout == -1) {
                latch.await();
            } else if (!latch.await(timeout, timeUnit)) {
                throw (Throwable)new TimeoutException();
            }
            InternalPromiseUtil.PromiseValue<T> promiseValue = this.valueRef.get();
            if (promiseValue == null) {
                Intrinsics.throwNpe();
            }
            value = promiseValue;
        }
        return value.getResultOrThrowError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void setHandler(AtomicReference<Consumer<? super T>> ref, Consumer<? super T> newConsumer, Promise.State targetState) {
        block15: {
            Consumer consumer;
            Consumer newEffectiveConsumer;
            Consumer<? super T> oldConsumer;
            if (InternalPromiseUtil.isHandlerObsolete(newConsumer)) {
                return;
            }
            InternalPromiseUtil.PromiseValue<T> promiseValue = this.valueRef.get();
            if (promiseValue != null) {
                InternalPromiseUtil.PromiseValue<T> promiseValue2;
                InternalPromiseUtil.PromiseValue<T> it = promiseValue2 = promiseValue;
                this.callConsumerIfTargeted(targetState, newConsumer, it);
                return;
            }
            do {
                Consumer<? super T> $i$a$1$let;
                if (($i$a$1$let = (oldConsumer = ref.get())) == null) {
                    consumer = newConsumer;
                    continue;
                }
                if ($i$a$1$let instanceof CompoundConsumer) {
                    Object it;
                    Object object;
                    Consumer<? super T> consumer2 = oldConsumer;
                    if (consumer2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.CompoundConsumer<T>");
                    }
                    CompoundConsumer compoundConsumer = (CompoundConsumer)consumer2;
                    boolean executed = true;
                    synchronized (compoundConsumer) {
                        Unit unit;
                        if (compoundConsumer.getConsumers() != null) {
                            it = object;
                            it.add(newConsumer);
                            executed = false;
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        it = unit;
                    }
                    if (executed) {
                        InternalPromiseUtil.PromiseValue<T> promiseValue3 = this.valueRef.get();
                        if (promiseValue3 != null) {
                            it = object = promiseValue3;
                            this.callConsumerIfTargeted(targetState, newConsumer, (InternalPromiseUtil.PromiseValue<T>)it);
                        }
                        return;
                    }
                    consumer = compoundConsumer;
                    continue;
                }
                consumer = new CompoundConsumer<T>(oldConsumer, newConsumer);
            } while (!ref.compareAndSet(oldConsumer, newEffectiveConsumer = consumer));
            if (this.getState() != targetState) break block15;
            Consumer consumer3 = ref.getAndSet(null);
            if (consumer3 != null) {
                Consumer consumer4;
                Consumer it = consumer4 = consumer3;
                InternalPromiseUtil.PromiseValue<T> promiseValue4 = this.valueRef.get();
                if (promiseValue4 == null) {
                    Intrinsics.throwNpe();
                }
                this.callConsumerIfTargeted(targetState, it, promiseValue4);
            }
        }
    }

    private final <C_T> void callConsumerIfTargeted(Promise.State targetState, Consumer<? super C_T> newConsumer, InternalPromiseUtil.PromiseValue<T> value) {
        Promise.State state = value.getState();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)state), (String)"value.state");
        Promise.State currentState = state;
        if (currentState == targetState) {
            newConsumer.accept(currentState == Promise.State.SUCCEEDED ? value.result : (Object)value.error);
        }
    }

    @Override
    public void _setValue(@NotNull InternalPromiseUtil.PromiseValue<T> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        if (value.error == null) {
            this.setResult(value.result);
        } else {
            Throwable throwable = value.error;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"value.error");
            this.setError(throwable);
        }
    }

    @Override
    @Nullable
    protected InternalPromiseUtil.PromiseValue<T> getValue() {
        return this.valueRef.get();
    }
}

