/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsstatuses;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsInfo;
import com.intellij.cvsSupport2.checkinProject.DirectoryContent;
import com.intellij.cvsSupport2.checkinProject.VirtualFileEntry;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.cvsstatuses.CvsStatusProvider;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsstatuses.CvsChangeProvider");
    private final CvsVcs2 myVcs;
    private final CvsEntriesManager myEntriesManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ChangeListManager myChangeListManager;

    public CvsChangeProvider(CvsVcs2 vcs, CvsEntriesManager entriesManager) {
        this.myVcs = vcs;
        this.myEntriesManager = entriesManager;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)vcs.getProject());
        this.myChangeListManager = ChangeListManager.getInstance((Project)vcs.getProject());
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        VirtualFile dir;
        if (dirtyScope == null) {
            CvsChangeProvider.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            CvsChangeProvider.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            CvsChangeProvider.$$$reportNull$$$0(2);
        }
        if (addGate == null) {
            CvsChangeProvider.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing changes for scope " + dirtyScope);
        }
        HashSet cvsRoots = ContainerUtil.newHashSet((Object[])this.myVcsManager.getRootsUnderVcs((AbstractVcs)this.myVcs));
        this.showBranchImOn(builder, dirtyScope, cvsRoots);
        for (FilePath path : dirtyScope.getRecursivelyDirtyDirectories()) {
            dir = path.getVirtualFile();
            if (dir != null) {
                this.processEntriesIn(dir, dirtyScope, builder, true, cvsRoots, progress);
                continue;
            }
            this.processFile(path, builder, progress);
        }
        for (FilePath path : dirtyScope.getDirtyFiles()) {
            if (path.isDirectory()) {
                dir = path.getVirtualFile();
                if (dir != null) {
                    this.processEntriesIn(dir, dirtyScope, builder, false, cvsRoots, progress);
                    continue;
                }
                this.processFile(path, builder, progress);
                continue;
            }
            this.processFile(path, builder, progress);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done processing changes");
        }
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    private void processEntriesIn(@NotNull VirtualFile dir, VcsDirtyScope scope, ChangelistBuilder builder, boolean recursively, Collection<VirtualFile> cvsRoots, ProgressIndicator progress) throws VcsException {
        FilePath path;
        if (dir == null) {
            CvsChangeProvider.$$$reportNull$$$0(4);
        }
        if (!scope.belongsTo(path = VcsContextFactory.SERVICE.getInstance().createFilePathOn(dir))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping out of scope path " + path);
            }
            return;
        }
        DirectoryContent dirContent = CvsChangeProvider.getDirectoryContent(dir, progress);
        for (VirtualFile file : dirContent.getUnknownFiles()) {
            builder.processUnversionedFile(file);
        }
        for (VirtualFile file : dirContent.getIgnoredFiles()) {
            builder.processIgnoredFile(file);
        }
        for (Entry entry : dirContent.getDeletedDirectories()) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((File)CvsVfsUtil.getFileFor(dir, entry.getFileName()), (boolean)true));
        }
        for (Entry entry : dirContent.getDeletedFiles()) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((File)CvsVfsUtil.getFileFor(dir, entry.getFileName()), (boolean)false));
        }
        progress.checkCanceled();
        this.checkSwitchedDir(dir, builder, scope, cvsRoots);
        if (CvsUtil.fileIsUnderCvs(dir) && dir.getChildren().length == 1 && dirContent.getDeletedFiles().isEmpty() && CvsChangeProvider.hasRemovedFiles(dirContent.getFiles())) {
            builder.processChange(new Change(CurrentContentRevision.create((FilePath)path), CurrentContentRevision.create((FilePath)path), FileStatus.DELETED), CvsVcs2.getKey());
        }
        for (VirtualFileEntry fileEntry : dirContent.getFiles()) {
            this.processFile(dir, fileEntry.getVirtualFile(), fileEntry.getEntry(), builder, progress);
        }
        if (recursively) {
            for (Iterator<Object> iterator : CvsVfsUtil.getChildrenOf(dir)) {
                progress.checkCanceled();
                if (!iterator.isDirectory()) continue;
                if (!this.myVcsManager.isIgnored(iterator)) {
                    this.processEntriesIn((VirtualFile)iterator, scope, builder, true, cvsRoots, progress);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping ignored path " + iterator.getPath());
            }
        }
    }

    private static boolean hasRemovedFiles(Collection<VirtualFileEntry> files) {
        for (VirtualFileEntry e : files) {
            if (!e.getEntry().isRemoved()) continue;
            return true;
        }
        return false;
    }

    private void processFile(FilePath filePath, ChangelistBuilder builder, ProgressIndicator progress) throws VcsException {
        VirtualFile dir = filePath.getVirtualFileParent();
        if (dir == null) {
            return;
        }
        Entry entry = this.myEntriesManager.getEntryFor(dir, filePath.getName());
        FileStatus status = CvsStatusProvider.getStatus(filePath.getVirtualFile(), entry);
        VcsRevisionNumber number = entry != null ? CvsChangeProvider.createRevisionNumber(entry.getRevision(), status) : VcsRevisionNumber.NULL;
        this.processStatus(filePath, dir.findChild(filePath.getName()), status, number, builder);
        progress.checkCanceled();
        this.checkSwitchedFile(filePath, builder, dir, entry);
    }

    private void processFile(VirtualFile dir, @Nullable VirtualFile file, Entry entry, ChangelistBuilder builder, ProgressIndicator progress) throws VcsException {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)dir, (String)entry.getFileName());
        FileStatus status = CvsStatusProvider.getStatus(file, entry);
        CvsRevisionNumber number = CvsChangeProvider.createRevisionNumber(entry.getRevision(), status);
        this.processStatus(filePath, file, status, (VcsRevisionNumber)number, builder);
        progress.checkCanceled();
        this.checkSwitchedFile(filePath, builder, dir, entry);
    }

    private static CvsRevisionNumber createRevisionNumber(String revision, FileStatus status) {
        int idx;
        String correctedRevision = FileStatus.DELETED.equals(status) ? ((idx = revision.indexOf(45)) != -1 ? revision.substring(idx + 1) : revision) : revision;
        return new CvsRevisionNumber(correctedRevision);
    }

    private void showBranchImOn(ChangelistBuilder builder, VcsDirtyScope scope, HashSet<VirtualFile> cvsRoots) {
        List dirs = ObjectsConvertor.fp2vf((Collection)scope.getRecursivelyDirtyDirectories());
        for (VirtualFile root : cvsRoots) {
            if (!dirs.contains(root)) continue;
            this.checkTopLevelForBeingSwitched(root, builder);
        }
    }

    private void checkTopLevelForBeingSwitched(VirtualFile dir, ChangelistBuilder builder) {
        CvsInfo info = this.myEntriesManager.getCvsInfoFor(dir);
        if (info.getRepository() == null) {
            return;
        }
        String dirTag = info.getStickyTag();
        if (dirTag != null) {
            String caption = CvsChangeProvider.getSwitchedTagCaption(dirTag, null, false);
            if (caption != null) {
                builder.processRootSwitch(dir, caption);
            }
        } else {
            builder.processRootSwitch(dir, "HEAD");
        }
    }

    @Nullable
    private static String getSwitchedTagCaption(String tag, @Nullable String parentTag, boolean checkParentTag) {
        if (tag == null) {
            return "HEAD";
        }
        String tagOnly = tag.substring(1);
        if (CvsUtil.isNonDateTag(tag)) {
            String parentTagOnly;
            if (checkParentTag && parentTag != null && CvsUtil.isNonDateTag(parentTag) && tagOnly.equals(parentTagOnly = parentTag.substring(1))) {
                return null;
            }
            return CvsBundle.message((String)"switched.tag.format", (Object[])new Object[]{tagOnly});
        }
        if (tag.startsWith("D")) {
            try {
                Date date = Entry.STICKY_DATE_FORMAT.parse(tagOnly);
                return CvsBundle.message((String)"switched.date.format", (Object[])new Object[]{date});
            }
            catch (ParseException e) {
                return CvsBundle.message((String)"switched.date.format", (Object[])new Object[]{tagOnly});
            }
        }
        return null;
    }

    private void checkSwitchedDir(VirtualFile dir, ChangelistBuilder builder, VcsDirtyScope scope, Collection<VirtualFile> cvsRoots) {
        String parentBranch;
        CvsInfo parentInfo;
        String parentDirTag;
        VirtualFile parentDir = dir.getParent();
        if (parentDir == null || cvsRoots.contains(dir) || !this.myVcsManager.isFileInContent(parentDir)) {
            return;
        }
        CvsInfo info = this.myEntriesManager.getCvsInfoFor(dir);
        if (info.getRepository() == null) {
            if (info.getIgnoreFilter().shouldBeIgnored(dir)) {
                builder.processIgnoredFile(dir);
            } else {
                builder.processUnversionedFile(dir);
            }
            return;
        }
        String dirTag = info.getStickyTag();
        if (!Comparing.equal((String)dirTag, (String)(parentDirTag = (parentInfo = this.myEntriesManager.getCvsInfoFor(parentDir)).getStickyTag()))) {
            String caption = CvsChangeProvider.getSwitchedTagCaption(dirTag, parentDirTag, true);
            if (caption != null) {
                builder.processSwitchedFile(dir, caption, true);
            }
        } else if (!scope.belongsTo(VcsContextFactory.SERVICE.getInstance().createFilePathOn(parentDir)) && (parentBranch = this.myChangeListManager.getSwitchedBranch(parentDir)) != null) {
            builder.processSwitchedFile(dir, parentBranch, true);
        }
    }

    private void checkSwitchedFile(FilePath filePath, ChangelistBuilder builder, VirtualFile dir, Entry entry) {
        VirtualFile file;
        if (!this.myVcsManager.isFileInContent(dir)) {
            return;
        }
        String dirTag = this.myEntriesManager.getCvsInfoFor(dir).getStickyTag();
        String dirStickyInfo = CvsChangeProvider.getStickyInfo(dirTag);
        if (entry != null && !Comparing.equal((String)entry.getStickyInformation(), (String)dirStickyInfo) && (file = filePath.getVirtualFile()) != null) {
            if (entry.getStickyTag() != null) {
                builder.processSwitchedFile(file, CvsBundle.message((String)"switched.tag.format", (Object[])new Object[]{entry.getStickyTag()}), false);
            } else if (entry.getStickyDate() != null) {
                builder.processSwitchedFile(file, CvsBundle.message((String)"switched.date.format", (Object[])new Object[]{entry.getStickyDate()}), false);
            } else if (entry.getStickyRevision() != null) {
                builder.processSwitchedFile(file, CvsBundle.message((String)"switched.revision.format", (Object[])new Object[]{entry.getStickyRevision()}), false);
            } else {
                builder.processSwitchedFile(file, "HEAD", false);
            }
        }
    }

    @Nullable
    private static String getStickyInfo(String dirTag) {
        return dirTag != null && dirTag.length() > 1 ? dirTag.substring(1) : null;
    }

    private void processStatus(FilePath filePath, VirtualFile file, FileStatus status, VcsRevisionNumber number, ChangelistBuilder builder) throws VcsException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processStatus: filePath=" + filePath + " status=" + status);
        }
        if (status == FileStatus.NOT_CHANGED) {
            if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                builder.processChange(new Change((ContentRevision)this.createCvsRevision(filePath, number), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED), CvsVcs2.getKey());
            }
            return;
        }
        if (status == FileStatus.MODIFIED || status == FileStatus.MERGE || status == FileStatus.MERGED_WITH_CONFLICTS) {
            String content;
            byte[] binaryContent;
            CvsUpToDateRevision beforeRevision = this.createCvsRevision(filePath, number);
            ContentRevision afterRevision = CurrentContentRevision.create((FilePath)filePath);
            if (beforeRevision instanceof BinaryContentRevision ? (binaryContent = ((BinaryContentRevision)beforeRevision).getBinaryContent()) != null && Arrays.equals(binaryContent, ((BinaryContentRevision)afterRevision).getBinaryContent()) : (content = beforeRevision.getContent()) != null && content.equals(afterRevision.getContent())) {
                return;
            }
            builder.processChange(new Change((ContentRevision)beforeRevision, afterRevision, status), CvsVcs2.getKey());
        } else if (status == FileStatus.ADDED) {
            builder.processChange(new Change(null, CurrentContentRevision.create((FilePath)filePath), status), CvsVcs2.getKey());
        } else if (status == FileStatus.DELETED) {
            builder.processChange(new Change((ContentRevision)this.createCvsRevision(filePath, number), null, status), CvsVcs2.getKey());
        } else if (status == FileStatus.DELETED_FROM_FS) {
            builder.processLocallyDeletedFile(filePath);
        } else if (status == FileStatus.UNKNOWN) {
            builder.processUnversionedFile(filePath.getVirtualFile());
        } else if (status == FileStatus.IGNORED) {
            builder.processIgnoredFile(filePath.getVirtualFile());
        }
    }

    @Nullable
    public byte[] getLastUpToDateContentFor(@NotNull VirtualFile f) {
        String name;
        VirtualFile parent;
        Entry entry;
        if (f == null) {
            CvsChangeProvider.$$$reportNull$$$0(5);
        }
        if ((entry = this.myEntriesManager.getEntryFor(parent = f.getParent(), name = f.getName())) != null && entry.isResultOfMerge()) {
            byte[] content = CvsUtil.getStoredContentForFile(f, entry.getRevision());
            if (content != null) {
                return content;
            }
            return CvsUtil.getCachedStoredContent(parent, name, entry.getRevision());
        }
        final long upToDateTimestamp = this.getUpToDateTimeForFile(f);
        FileRevisionTimestampComparator c = new FileRevisionTimestampComparator(){

            public boolean isSuitable(long revisionTimestamp) {
                return CvsStatusProvider.timeStampsAreEqual(upToDateTimestamp, revisionTimestamp);
            }
        };
        byte[] localHistoryContent = LocalHistory.getInstance().getByteContent(f, c);
        if (localHistoryContent == null && entry != null && CvsUtil.haveCachedContent(f, entry.getRevision())) {
            return CvsUtil.getCachedStoredContent(parent, name, entry.getRevision());
        }
        return localHistoryContent;
    }

    public long getUpToDateTimeForFile(@NotNull VirtualFile vFile) {
        Entry entry;
        if (vFile == null) {
            CvsChangeProvider.$$$reportNull$$$0(6);
        }
        if ((entry = this.myEntriesManager.getEntryFor(vFile.getParent(), vFile.getName())) == null) {
            return -1L;
        }
        Date lastModified = entry.getLastModified();
        if (lastModified == null) {
            return -1L;
        }
        return lastModified.getTime();
    }

    private CvsUpToDateRevision createCvsRevision(FilePath filePath, VcsRevisionNumber revisionNumber) {
        if (filePath.getFileType().isBinary()) {
            return new CvsUpToDateBinaryRevision(filePath, revisionNumber);
        }
        return new CvsUpToDateRevision(filePath, revisionNumber);
    }

    private static boolean isInContent(VirtualFile file) {
        return file == null || !FileTypeManager.getInstance().isFileIgnored(file);
    }

    private static DirectoryContent getDirectoryContent(VirtualFile directory, ProgressIndicator progress) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving directory content for " + directory);
        }
        CvsInfo cvsInfo = CvsEntriesManager.getInstance().getCvsInfoFor(directory);
        DirectoryContent result = new DirectoryContent(cvsInfo);
        HashMap<String, VirtualFile> nameToFileMap = new HashMap<String, VirtualFile>();
        for (VirtualFile child : CvsVfsUtil.getChildrenOf(directory)) {
            nameToFileMap.put(child.getName(), child);
        }
        for (Entry entry : cvsInfo.getEntries()) {
            VirtualFile virtualFile;
            progress.checkCanceled();
            String fileName = entry.getFileName();
            if (entry.isDirectory()) {
                if (nameToFileMap.containsKey(fileName)) {
                    virtualFile = (VirtualFile)nameToFileMap.get(fileName);
                    if (CvsChangeProvider.isInContent(virtualFile)) {
                        result.addDirectory(new VirtualFileEntry(virtualFile, entry));
                    }
                } else if (!entry.isRemoved() && !FileTypeManager.getInstance().isFileIgnored(fileName)) {
                    result.addDeletedDirectory(entry);
                }
            } else if (nameToFileMap.containsKey(fileName) || entry.isRemoved()) {
                virtualFile = (VirtualFile)nameToFileMap.get(fileName);
                if (CvsChangeProvider.isInContent(virtualFile)) {
                    result.addFile(new VirtualFileEntry(virtualFile, entry));
                }
            } else if (!entry.isAddedFile()) {
                result.addDeletedFile(entry);
            }
            nameToFileMap.remove(fileName);
        }
        for (String name : nameToFileMap.keySet()) {
            progress.checkCanceled();
            VirtualFile unknown = (VirtualFile)nameToFileMap.get(name);
            if (unknown.isDirectory()) {
                if (!CvsChangeProvider.isInContent(unknown)) continue;
                result.addUnknownDirectory(unknown);
                continue;
            }
            if (!CvsChangeProvider.isInContent(unknown)) continue;
            boolean isIgnored = result.getCvsInfo().getIgnoreFilter().shouldBeIgnored(unknown);
            if (isIgnored) {
                result.addIgnoredFile(unknown);
                continue;
            }
            result.addUnknownFile(unknown);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processEntriesIn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastUpToDateContentFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpToDateTimeForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CvsUpToDateBinaryRevision
    extends CvsUpToDateRevision
    implements BinaryContentRevision {
        public CvsUpToDateBinaryRevision(FilePath path, VcsRevisionNumber revisionNumber) {
            super(path, revisionNumber);
        }

        @Nullable
        public byte[] getBinaryContent() throws VcsException {
            return this.getContentAsBytes();
        }

        @Override
        @NonNls
        public String toString() {
            return "CvsUpToDateBinaryRevision:" + this.myPath;
        }
    }

    private class CvsUpToDateRevision
    implements ByteBackedContentRevision {
        protected final FilePath myPath;
        private final VcsRevisionNumber myRevisionNumber;
        private byte[] myContent;

        protected CvsUpToDateRevision(FilePath path, VcsRevisionNumber revisionNumber) {
            this.myRevisionNumber = revisionNumber;
            this.myPath = path;
        }

        @Nullable
        public String getContent() throws VcsException {
            byte[] fileBytes = this.getContentAsBytes();
            return fileBytes == null ? null : CharsetToolkit.bytesToString((byte[])fileBytes, (Charset)this.myPath.getCharset());
        }

        @Nullable
        public byte[] getContentAsBytes() throws VcsException {
            if (this.myContent == null) {
                try {
                    this.myContent = this.getUpToDateBinaryContent();
                }
                catch (CannotFindCvsRootException e) {
                    throw new VcsException((Throwable)e);
                }
            }
            return this.myContent;
        }

        @Nullable
        private byte[] getUpToDateBinaryContent() throws CannotFindCvsRootException {
            VirtualFile virtualFile = this.myPath.getVirtualFile();
            byte[] result = null;
            if (virtualFile != null) {
                result = CvsChangeProvider.this.getLastUpToDateContentFor(virtualFile);
            }
            if (result == null) {
                GetFileContentOperation operation;
                String revision = null;
                if (virtualFile != null) {
                    Entry entry = CvsChangeProvider.this.myEntriesManager.getEntryFor(virtualFile.getParent(), virtualFile.getName());
                    if (entry != null) {
                        revision = entry.getRevision();
                        operation = GetFileContentOperation.createForFile(virtualFile, new SimpleRevision(revision));
                    } else {
                        operation = GetFileContentOperation.createForFile(this.myPath);
                    }
                } else {
                    operation = GetFileContentOperation.createForFile(this.myPath);
                }
                if (operation.getRoot().isOffline()) {
                    return null;
                }
                CvsVcs2.executeQuietOperation(CvsBundle.message((String)"operation.name.get.file.content", (Object[])new Object[0]), operation, CvsChangeProvider.this.myVcs.getProject());
                result = operation.tryGetFileBytes();
                if (result != null && revision != null) {
                    CvsUtil.storeContentForRevision(virtualFile, revision, result);
                }
            }
            return result;
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                CvsUpToDateRevision.$$$reportNull$$$0(0);
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevisionNumber;
            if (vcsRevisionNumber == null) {
                CvsUpToDateRevision.$$$reportNull$$$0(1);
            }
            return vcsRevisionNumber;
        }

        @NonNls
        public String toString() {
            return "CvsUpToDateRevision:" + this.myPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider$CvsUpToDateRevision";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

