/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

public abstract class YamlKeyCompletionInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    @NotNull
    protected abstract YAMLKeyValue createNewEntry(@NotNull YAMLDocument var1, T var2);

    public void handleInsert(InsertionContext context, T item) {
        PsiElement currentElement = context.getFile().findElementAt(context.getStartOffset());
        assert (currentElement != null) : "no element at " + context.getStartOffset();
        YAMLDocument holdingDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)currentElement, YAMLDocument.class);
        assert (holdingDocument != null);
        YAMLValue oldValue = this.deleteLookupTextAndRetrieveOldValue(context, currentElement);
        YAMLKeyValue created = this.createNewEntry(holdingDocument, item);
        context.getEditor().getCaretModel().moveToOffset(created.getTextRange().getEndOffset());
        if (oldValue != null) {
            WriteCommandAction.runWriteCommandAction((Project)context.getProject(), () -> created.setValue(oldValue));
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        if (!YamlKeyCompletionInsertHandler.isCharAtCaret(context.getEditor(), ' ')) {
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
        } else {
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }
    }

    @Nullable
    protected YAMLValue deleteLookupTextAndRetrieveOldValue(InsertionContext context, @NotNull PsiElement elementAtCaret) {
        YAMLValue oldValue;
        if (elementAtCaret == null) {
            YamlKeyCompletionInsertHandler.$$$reportNull$$$0(0);
        }
        if (elementAtCaret.getNode().getElementType() != YAMLTokenTypes.SCALAR_KEY) {
            YamlKeyCompletionInsertHandler.deleteLookupPlain(context);
            return null;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, YAMLKeyValue.class);
        assert (keyValue != null);
        context.commitDocument();
        if (keyValue.getValue() != null) {
            YAMLKeyValue dummyKV = YAMLElementGenerator.getInstance(context.getProject()).createYamlKeyValue("foo", "b");
            dummyKV.setValue(keyValue.getValue());
            oldValue = dummyKV.getValue();
        } else {
            oldValue = null;
        }
        context.setTailOffset(keyValue.getTextRange().getEndOffset());
        WriteCommandAction.runWriteCommandAction((Project)context.getProject(), () -> keyValue.getParentMapping().deleteKeyValue(keyValue));
        return oldValue;
    }

    private static void deleteLookupPlain(InsertionContext context) {
        int offset;
        Document document = context.getDocument();
        CharSequence sequence = document.getCharsSequence();
        for (offset = context.getStartOffset() - 1; offset >= 0; --offset) {
            char c = sequence.charAt(offset);
            if (c == ' ' || c == '\t') continue;
            if (c == '\n') {
                --offset;
                break;
            }
            offset = context.getStartOffset() - 1;
            break;
        }
        document.deleteString(offset + 1, context.getTailOffset());
        context.commitDocument();
    }

    public static boolean isCharAtCaret(Editor editor, char ch) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAtCaret", "org/jetbrains/yaml/completion/YamlKeyCompletionInsertHandler", "deleteLookupTextAndRetrieveOldValue"));
    }
}

