/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.resolve;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.impl.YAMLAliasImpl;
import org.jetbrains.yaml.resolve.YAMLLocalResolveUtil;

public class YAMLAliasReference
extends PsiReferenceBase<YAMLAliasImpl> {
    public YAMLAliasReference(YAMLAliasImpl alias) {
        super((PsiElement)alias);
    }

    @Nullable
    public YAMLAnchor resolve() {
        return YAMLLocalResolveUtil.getResolveAliasMap(((YAMLAliasImpl)this.myElement).getContainingFile()).get(this.myElement);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.getIdentifier().replaceWithText(newElementName);
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)this.getIdentifier().getStartOffsetInParent(), (int)this.getIdentifier().getTextLength());
        if (textRange == null) {
            YAMLAliasReference.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @Contract(pure=true)
    @NotNull
    private LeafPsiElement getIdentifier() {
        LeafPsiElement leafPsiElement = Objects.requireNonNull(((YAMLAliasImpl)this.myElement).getIdentifierPsi(), "Reference should not be created for aliases without name");
        if (leafPsiElement == null) {
            YAMLAliasReference.$$$reportNull$$$0(1);
        }
        return leafPsiElement;
    }

    @NotNull
    public Object[] getVariants() {
        Collection<YAMLAnchor> defs = YAMLLocalResolveUtil.getFirstAnchorDefs(((YAMLAliasImpl)this.myElement).getContainingFile().getOriginalFile());
        Object[] objectArray = defs.toArray();
        if (objectArray == null) {
            YAMLAliasReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/yaml/resolve/YAMLAliasReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

