/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public class YamlJsonPsiWalker
implements JsonLikePsiWalker {
    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof YAMLDocument || parent instanceof YAMLMapping) {
            return ThreeState.YES;
        }
        if (parent instanceof YAMLKeyValue && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            ASTNode prev = element.getNode().getTreePrev();
            return prev.getElementType() == YAMLTokenTypes.INDENT ? ThreeState.YES : ThreeState.NO;
        }
        if (parent instanceof YAMLSequenceItem && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static boolean isFirstChild(PsiElement element, PsiElement parent) {
        PsiElement[] children = parent.getChildren();
        return children.length != 0 && children[0] == element;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(0);
        }
        return element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() != null;
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(1);
        }
        return element instanceof YAMLFile || element instanceof YAMLDocument;
    }

    public PsiElement goUpToCheckable(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(2);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof YAMLValue) && !(current instanceof YAMLKeyValue)) continue;
            return current;
        }
        return null;
    }

    public boolean isNameQuoted() {
        return false;
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(3);
        }
        return element instanceof YAMLValue ? YamlPropertyAdapter.createValueAdapterByType((YAMLValue)element) : null;
    }

    public boolean onlyDoubleQuotesForStringLiterals() {
        return false;
    }

    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        YAMLKeyValue property;
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(5);
        }
        if ((property = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)false)) == null) {
            return null;
        }
        YAMLValue value = property.getValue();
        if (value == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)element, (boolean)true)) {
            return null;
        }
        return new YamlPropertyAdapter(property);
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        if (originalPosition == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(6);
        }
        YAMLMapping object = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, YAMLMapping.class);
        YAMLMapping otherObject = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)computedPosition, YAMLMapping.class);
        if (object == null || otherObject != null && PsiTreeUtil.isAncestor((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)object), (PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)otherObject), (boolean)true)) {
            object = otherObject;
        }
        if (object == null) {
            return Collections.emptySet();
        }
        return object.getKeyValues().stream().filter(p -> p != null && p.getName() != null).map(p -> p.getName()).collect(Collectors.toSet());
    }

    @Nullable
    public List<JsonSchemaVariantsTreeBuilder.Step> findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(7);
        }
        ArrayList<JsonSchemaVariantsTreeBuilder.Step> steps = new ArrayList<JsonSchemaVariantsTreeBuilder.Step>();
        PsiElement current = element;
        while (!YamlJsonPsiWalker.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof YAMLSequence) {
                YAMLSequence array = (YAMLSequence)current;
                List<YAMLSequenceItem> expressions = array.getItems();
                int idx = -1;
                for (int i = 0; i < expressions.size(); ++i) {
                    YAMLSequenceItem value = expressions.get(i);
                    if (!position.equals(value)) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) continue;
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createArrayElementStep((int)idx));
                continue;
            }
            if (current instanceof YAMLSequenceItem) continue;
            if (current instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)current).getName());
                if (!((current = current.getParent()) instanceof YAMLMapping)) {
                    return null;
                }
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createPropertyStep((String)propertyName));
                continue;
            }
            if (current instanceof YAMLMapping && position instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)position).getName());
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createPropertyStep((String)propertyName));
                continue;
            }
            if (YamlJsonPsiWalker.breakCondition(current)) break;
            if (current instanceof YAMLMapping) {
                List<YAMLPsiElement> elements = ((YAMLMapping)current).getYAMLElements();
                if (elements.size() == 0) {
                    return null;
                }
                if (position instanceof YAMLPsiElement && elements.contains(position)) continue;
            }
            return null;
        }
        Collections.reverse(steps);
        return steps;
    }

    private static boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof YAMLDocument || current instanceof YAMLBlockMappingImpl && current.getParent() instanceof YAMLDocument;
    }

    public boolean quotesForStringLiterals() {
        return false;
    }

    public String getDefaultObjectValue(boolean includeWhitespaces) {
        return includeWhitespaces ? "\n  " : "";
    }

    @Nullable
    public String defaultObjectValueDescription() {
        return "start object";
    }

    public String getDefaultArrayValue(boolean includeWhitespaces) {
        return includeWhitespaces ? "\n  - " : "- ";
    }

    @Nullable
    public String defaultArrayValueDescription() {
        return "start array";
    }

    public boolean invokeEnterBeforeObjectAndArray() {
        return true;
    }

    public String getNodeTextForValidation(PsiElement element) {
        String text = element.getText();
        if (!StringUtil.startsWith((CharSequence)text, (CharSequence)"!!")) {
            return text;
        }
        int spaceIndex = text.indexOf(32);
        return spaceIndex > 0 ? text.substring(spaceIndex + 1) : text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyWithValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopJsonElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "goUpToCheckable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createValueAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPropertiesBehindAndNoComma";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentPropertyAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

