/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.digest;

import com.trilead.ssh2.crypto.digest.Digest;
import com.trilead.ssh2.crypto.digest.JreMessageDigestWrapper;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

public class HashForSSH2Types {
    @Deprecated
    Digest md;
    private final Digest messageDigest;

    public HashForSSH2Types(Digest md) {
        this.md = md;
        this.messageDigest = md;
    }

    public HashForSSH2Types(String type) {
        this(new JreMessageDigestWrapper(HashForSSH2Types.createMessageDigest(type)));
    }

    private static MessageDigest createMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Could not get Message digest instance", ex);
        }
    }

    public void updateByte(byte b) {
        byte[] tmp = new byte[]{b};
        this.messageDigest.update(tmp);
    }

    public void updateBytes(byte[] b) {
        this.messageDigest.update(b);
    }

    public void updateUINT32(int v) {
        this.messageDigest.update((byte)(v >> 24));
        this.messageDigest.update((byte)(v >> 16));
        this.messageDigest.update((byte)(v >> 8));
        this.messageDigest.update((byte)v);
    }

    public void updateByteString(byte[] b) {
        this.updateUINT32(b.length);
        this.updateBytes(b);
    }

    public void updateBigInt(BigInteger b) {
        this.updateByteString(b.toByteArray());
    }

    public void reset() {
        this.messageDigest.reset();
    }

    public int getDigestLength() {
        return this.messageDigest.getDigestLength();
    }

    public byte[] getDigest() {
        byte[] tmp = new byte[this.messageDigest.getDigestLength()];
        this.getDigest(tmp);
        return tmp;
    }

    public void getDigest(byte[] out) {
        this.getDigest(out, 0);
    }

    public void getDigest(byte[] out, int off) {
        this.messageDigest.digest(out, off);
    }
}

