/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.tasks.Task;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public abstract class SearchSupport<T extends Task> {
    protected EditorTextField myTextField;
    protected JBPopup myCurrentPopup;
    protected JList myList = new JBList();
    protected boolean myCancelled;
    private final ActionListener myCancelAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SearchSupport.this.myCurrentPopup != null) {
                SearchSupport.this.myCancelled = true;
                SearchSupport.this.hideCurrentPopup();
            }
        }
    };
    private T myResult;
    private final SortedListModel<T> myListModel;
    private boolean myAutoPopup;

    public SearchSupport(EditorTextField textField) {
        this.myTextField = textField;
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                SearchSupport.this.onTextChanged();
            }
        });
        SwingUtilities.invokeLater(() -> this.myTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SearchSupport.this.processListSelection(e);
            }
        }));
        this.myList.setVisibleRowCount(10);
        this.myListModel = new SortedListModel(null);
        this.myList.setModel(this.myListModel);
    }

    public void setAutoPopup(boolean autoPopup) {
        this.myAutoPopup = autoPopup;
    }

    public void setListRenderer(ListCellRenderer renderer) {
        this.myList.setCellRenderer(renderer);
    }

    protected String getText() {
        return this.myTextField.getText();
    }

    protected void onTextChanged() {
        if (this.myResult != null && !this.myResult.toString().equals(this.myTextField.getText())) {
            this.myResult = null;
        }
        if (this.myCancelled) {
            return;
        }
        if (this.isPopupShowing() || this.myAutoPopup) {
            this.showPopup(false);
        } else {
            this.hideCurrentPopup();
        }
    }

    protected abstract List<T> getItems(String var1);

    private void processListSelection(KeyEvent e) {
        Action action;
        Object object;
        if (this.togglePopup(e)) {
            return;
        }
        if (!this.isPopupShowing()) {
            return;
        }
        InputMap map = this.myTextField.getInputMap(2);
        if (map != null && (object = map.get(KeyStroke.getKeyStrokeForEvent(e))) instanceof Action && (action = (Action)object).isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, "action"));
            e.consume();
            return;
        }
        Object action2 = SearchSupport.getAction(e, this.myList);
        if ("selectNextRow".equals(action2)) {
            if (this.ensureSelectionExists()) {
                ScrollingUtil.moveDown((JList)this.myList, (int)e.getModifiersEx());
            }
        } else if ("selectPreviousRow".equals(action2)) {
            ScrollingUtil.moveUp((JList)this.myList, (int)e.getModifiersEx());
        } else if ("scrollDown".equals(action2)) {
            ScrollingUtil.movePageDown((JList)this.myList);
        } else if ("scrollUp".equals(action2)) {
            ScrollingUtil.movePageUp((JList)this.myList);
        } else if ((e.getKeyCode() == 10 || e.getKeyCode() == 9) && e.getModifiers() == 0) {
            this.hideCurrentPopup();
            e.consume();
            this.myCancelled = true;
            this.processChosenFromCompletion();
        }
    }

    @Nullable
    public T getResult() {
        return this.myResult;
    }

    private boolean togglePopup(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        Object action = ((InputMap)UIManager.get("ComboBox.ancestorInputMap")).get(stroke);
        if ("selectNext".equals(action)) {
            if (!this.isPopupShowing() && this.myAutoPopup) {
                this.showPopup(true);
                return true;
            }
            return false;
        }
        if ("togglePopup".equals(action)) {
            if (this.isPopupShowing()) {
                this.hideCurrentPopup();
            } else {
                this.showPopup(true);
            }
            return true;
        }
        Keymap active = KeymapManager.getInstance().getActiveKeymap();
        String[] ids = active.getActionIds(stroke);
        if (ids.length > 0 && "CodeCompletion".equals(ids[0])) {
            this.showPopup(true);
        }
        return false;
    }

    private void showPopup(boolean explicit) {
        this.myCancelled = false;
        List<T> list = this.getItems(this.myTextField.getText());
        this.myListModel.clear();
        this.myListModel.addAll(list);
        if (list.isEmpty()) {
            if (explicit) {
                this.showNoSuggestions();
            } else {
                this.hideCurrentPopup();
            }
            return;
        }
        this.ensureSelectionExists();
        this.myList.setPrototypeCellValue(null);
        if (this.isPopupShowing()) {
            this.adjustPopupSize();
            return;
        }
        this.hideCurrentPopup();
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(this.myList);
        builder.addListener(new JBPopupListener(){

            public void beforeShown(LightweightWindowEvent event) {
                SearchSupport.this.myTextField.registerKeyboardAction(SearchSupport.this.myCancelAction, KeyStroke.getKeyStroke(27, 0), 2);
            }

            public void onClosed(LightweightWindowEvent event) {
                SearchSupport.this.myTextField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            }
        });
        this.myCurrentPopup = builder.setRequestFocus(false).setAutoSelectIfEmpty(false).setResizable(false).setCancelCallback(() -> {
            int caret = this.myTextField.getCaretModel().getOffset();
            this.getEditor().getSelectionModel().setSelection(caret, caret);
            this.myTextField.setFocusTraversalKeysEnabled(true);
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTextField, true)));
            return Boolean.TRUE;
        }).setItemChoosenCallback(() -> this.processChosenFromCompletion()).setCancelKeyEnabled(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myTextField}).createPopup();
        this.adjustPopupSize();
        this.showPopup();
    }

    private void adjustPopupSize() {
        Dimension size = this.myList.getPreferredSize();
        int cellHeight = this.myList.getCellRenderer().getListCellRendererComponent(this.myList, this.myList.getModel().getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height;
        int height = Math.min(size.height, Math.min(this.myList.getModel().getSize(), 12) * cellHeight);
        this.myCurrentPopup.setSize(new Dimension(size.width + 28, height + 12));
    }

    private void showPopup() {
        Point point = this.getPopupLocation();
        if (this.myCurrentPopup.isVisible()) {
            this.myCurrentPopup.setLocation(point);
        } else {
            this.myCurrentPopup.showInScreenCoordinates((Component)this.myTextField, point);
        }
    }

    protected Point getPopupLocation() {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(this.getEditor().getCaretModel().getOffset());
        Point point = this.getEditor().visualPositionToXY(visualPosition);
        SwingUtilities.convertPointToScreen(point, this.getEditor().getComponent());
        point.y += 2;
        return point;
    }

    private void showNoSuggestions() {
        this.hideCurrentPopup();
        JComponent message = HintUtil.createErrorLabel((String)IdeBundle.message((String)"file.chooser.completion.no.suggestions", (Object[])new Object[0]));
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(message, message);
        builder.setRequestFocus(false).setResizable(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myTextField});
        this.myCurrentPopup = builder.createPopup();
        this.showPopup();
    }

    private void processChosenFromCompletion() {
        this.myResult = (Task)this.myList.getSelectedValue();
        if (this.myResult != null) {
            this.onItemChosen(this.myResult);
        }
        this.hideCurrentPopup();
    }

    protected void onItemChosen(T result) {
        this.myTextField.setText(result.getPresentableName());
    }

    private void hideCurrentPopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.cancel();
            this.myCurrentPopup = null;
        }
    }

    private boolean ensureSelectionExists() {
        if ((this.myList.getSelectedIndex() < 0 || this.myList.getSelectedIndex() >= this.myList.getModel().getSize()) && this.myList.getModel().getSize() >= 0) {
            this.myList.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    private boolean isPopupShowing() {
        return this.myCurrentPopup != null && this.myList != null && this.myList.isShowing();
    }

    private static Object getAction(KeyEvent e, JComponent comp) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return comp.getInputMap().get(stroke);
    }

    protected Editor getEditor() {
        Editor editor = this.myTextField.getEditor();
        assert (editor != null);
        return editor;
    }
}

