/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.add;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.add.AddParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class AddCommand
extends AbstractCommand {
    private final Map repositoryPathToDirectoryObject = new HashMap();
    private KeywordSubstitution keywordSubst;

    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        Requests requests;
        BugLog.getInstance().assertTrue(this.getFileObjects().size() > 0, "No file specified.");
        this.repositoryPathToDirectoryObject.clear();
        try {
            requests = new Requests(CommandRequest.ADD, clientEnvironment);
            requests.addArgumentRequest(this.getKeywordSubst(), "-k");
            for (AbstractFileObject abstractFileObject : this.getFileObjects()) {
                this.addRequests(abstractFileObject, requests, requestProcessor, clientEnvironment);
            }
            requests.addLocalPathDirectoryRequest();
            this.addArgumentRequests(requests);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        AddParser parser = new AddParser(eventManager, clientEnvironment.getCvsFileSystem());
        parser.registerListeners(listenerRegistry);
        try {
            boolean result = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
            this.createCvsDirectories(clientEnvironment);
            boolean bl = result;
            return bl;
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        finally {
            this.repositoryPathToDirectoryObject.clear();
            parser.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("add ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setKeywordSubst(null);
    }

    private KeywordSubstitution getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitution keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    private void createCvsDirectories(IClientEnvironment clientEnvironment) throws IOException {
        for (AbstractFileObject abstractFileObject : this.getFileObjects()) {
            if (!abstractFileObject.isDirectory()) continue;
            clientEnvironment.getAdminWriter().directoryAdded((DirectoryObject)abstractFileObject, clientEnvironment.getCvsFileSystem());
        }
    }

    private String getCvsArguments() {
        StringBuilder toReturn = new StringBuilder();
        if (this.getKeywordSubst() != null) {
            toReturn.append("-k");
            toReturn.append(this.getKeywordSubst().toString());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }

    private void addRequests(AbstractFileObject abstractFileObject, Requests requests, IRequestProcessor requestProcessor, IClientEnvironment clientEnvironment) throws IOException {
        if (abstractFileObject.isDirectory()) {
            this.addRequestsForDirectory((DirectoryObject)abstractFileObject, requests, requestProcessor, clientEnvironment);
        } else {
            this.addRequestsForFile((FileObject)abstractFileObject, requests, clientEnvironment);
        }
    }

    private void addRequestsForDirectory(DirectoryObject directoryObject, Requests requests, IRequestProcessor requestProcessor, IClientEnvironment clientEnvironment) {
        DirectoryObject parentDirectoryUnderCvsControl = this.addDirectoryRequestsUpToLocalDirectory(directoryObject, requests, requestProcessor, clientEnvironment);
        if (parentDirectoryUnderCvsControl == null) {
            return;
        }
        String tag = clientEnvironment.getAdminReader().getStickyTagForDirectory(parentDirectoryUnderCvsControl, clientEnvironment.getCvsFileSystem());
        requests.addStickyRequest(tag);
    }

    private DirectoryObject addDirectoryRequestsUpToLocalDirectory(DirectoryObject directoryObject, Requests requests, IRequestProcessor requestProcessor, IClientEnvironment clientEnvironment) {
        DirectoryObject parentDirectoryObject = directoryObject.getParent();
        if (parentDirectoryObject == null) {
            return null;
        }
        if (clientEnvironment.getAdminReader().hasCvsDirectory(parentDirectoryObject, clientEnvironment.getCvsFileSystem())) {
            DirectoryObject parentDirectoryUnderCvsControl = parentDirectoryObject;
            requests.addDirectoryRequest(DirectoryObject.getRoot());
            this.addDirectoryRequest(parentDirectoryUnderCvsControl, requests);
        } else {
            DirectoryObject parentDirectoryUnderCvsControl = this.addDirectoryRequestsUpToLocalDirectory(parentDirectoryObject, requests, requestProcessor, clientEnvironment);
            if (parentDirectoryUnderCvsControl == null) {
                parentDirectoryUnderCvsControl = parentDirectoryObject;
            }
        }
        this.addDirectoryRequest(directoryObject, requests);
        return parentDirectoryObject;
    }

    private static void addStickyRequest(DirectoryObject directoryObject, Requests requests, ICvsFileSystem cvsFileSystem, IClientEnvironment clientEnvironment) {
        String tag = clientEnvironment.getAdminReader().getStickyTagForDirectory(directoryObject, cvsFileSystem);
        requests.addStickyRequest(tag);
    }

    private void addDirectoryRequest(DirectoryObject directoryObject, Requests requests) {
        String repositoryPath = requests.addDirectoryRequest(directoryObject);
        this.repositoryPathToDirectoryObject.put(repositoryPath, directoryObject);
    }

    private void addRequestsForFile(FileObject fileObject, Requests requests, IClientEnvironment clientEnvironment) throws IOException {
        DirectoryObject parentDirectory = fileObject.getParent();
        this.addDirectoryRequest(parentDirectory, requests);
        AddCommand.addStickyRequest(parentDirectory, requests, clientEnvironment.getCvsFileSystem(), clientEnvironment);
        Entry entry = clientEnvironment.getAdminReader().getEntry(fileObject, clientEnvironment.getCvsFileSystem());
        if (entry != null) {
            requests.addEntryRequest(entry);
        } else {
            requests.addIsModifiedRequest(fileObject);
        }
    }
}

