/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.netbeans.lib.cvsclient.util.BugLog;

public abstract class AbstractOutputStreamWriter
extends Writer {
    private final OutputStream outputStream;

    protected abstract void writeChar(char var1, OutputStream var2) throws IOException;

    protected AbstractOutputStreamWriter(OutputStream outputStream) {
        BugLog.getInstance().assertNotNull(outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public final void write(int chr) throws IOException {
        this.ensureOpen();
        this.writeChar((char)chr, this.outputStream);
    }

    @Override
    public final void write(char[] buffer, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        while (length > 0) {
            char chr = buffer[offset];
            this.writeChar(chr, this.outputStream);
            ++offset;
            --length;
        }
    }

    @Override
    public final void flush() throws IOException {
        this.ensureOpen();
        this.outputStream.flush();
    }

    @Override
    public final void close() throws IOException {
        this.ensureOpen();
        this.flush();
        this.outputStream.close();
    }

    private void ensureOpen() throws IOException {
        if (this.outputStream == null) {
            throw new IOException("Stream closed");
        }
    }
}

