/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.RestModel;

@RestModel
public class GithubErrorMessage {
    private String message;
    private List<Error> errors;

    @Nullable
    public String getMessage() {
        if (this.errors == null) {
            return this.message;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.message);
        for (Error e : this.errors) {
            s.append(String.format("<br/>[%s; %s]%s: %s", e.resource, e.field, e.code, e.message));
        }
        return s.toString();
    }

    public boolean containsReasonMessage(@NotNull String reason) {
        if (reason == null) {
            GithubErrorMessage.$$$reportNull$$$0(0);
        }
        if (this.message == null) {
            return false;
        }
        return this.message.contains(reason);
    }

    public boolean containsErrorCode(@NotNull String code2) {
        if (code2 == null) {
            GithubErrorMessage.$$$reportNull$$$0(1);
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(code2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsErrorMessage(@NotNull String message) {
        if (message == null) {
            GithubErrorMessage.$$$reportNull$$$0(2);
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(message)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/api/data/GithubErrorMessage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsReasonMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "containsErrorCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @RestModel
    public static class Error {
        private String resource;
        private String field;
        private String code;
        private String message;
    }
}

