/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nRN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "", "()V", "informationCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/api/data/GithubUserDetailed;", "informationTask", "Lcom/intellij/util/ThrowableConvertor;", "Lorg/jetbrains/plugins/github/api/GithubConnection;", "Ljava/io/IOException;", "getInformationTask", "()Lcom/intellij/util/ThrowableConvertor;", "usernameTask", "", "getUsernameTask", "getAccountInformation", "connection", "getAccountUsername", "intellij.vcs.github"})
public final class GithubAccountInformationProvider {
    private final ConcurrentMap<GithubAccount, GithubUserDetailed> informationCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build().asMap();

    @NotNull
    public final GithubUserDetailed getAccountInformation(@NotNull GithubConnection connection) throws IOException {
        GithubUserDetailed githubUserDetailed;
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        GithubAccount account = connection.getAccount();
        if (account == null) {
            GithubAuthenticatedUser githubAuthenticatedUser = GithubApiUtil.getCurrentUser(connection);
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAuthenticatedUser, (String)"GithubApiUtil.getCurrentUser(connection)");
            githubUserDetailed = githubAuthenticatedUser;
        } else {
            ConcurrentMap<GithubAccount, GithubUserDetailed> concurrentMap = this.informationCache;
            Intrinsics.checkExpressionValueIsNotNull(concurrentMap, (String)"informationCache");
            ConcurrentMap<GithubAccount, GithubUserDetailed> $receiver$iv = concurrentMap;
            Object object = $receiver$iv.get(account);
            if (object == null) {
                GithubAuthenticatedUser githubAuthenticatedUser = GithubApiUtil.getCurrentUser(connection);
                GithubAuthenticatedUser default$iv = githubAuthenticatedUser;
                object = $receiver$iv.putIfAbsent(account, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkExpressionValueIsNotNull(object, (String)"informationCache.getOrPu\u2026CurrentUser(connection) }");
            githubUserDetailed = (GithubUserDetailed)object;
        }
        return githubUserDetailed;
    }

    @NotNull
    public final ThrowableConvertor<GithubConnection, GithubUserDetailed, IOException> getInformationTask() {
        return (ThrowableConvertor)new ThrowableConvertor<GithubConnection, GithubUserDetailed, IOException>(this){
            final /* synthetic */ GithubAccountInformationProvider this$0;

            @NotNull
            public final GithubUserDetailed convert(GithubConnection it) {
                GithubConnection githubConnection = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)githubConnection, (String)"it");
                return this.this$0.getAccountInformation(githubConnection);
            }
            {
                this.this$0 = githubAccountInformationProvider;
            }
        };
    }

    @NotNull
    public final String getAccountUsername(@NotNull GithubConnection connection) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        String string = this.getAccountInformation(connection).getLogin();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getAccountInformation(connection).login");
        return string;
    }

    @NotNull
    public final ThrowableConvertor<GithubConnection, String, IOException> getUsernameTask() {
        return (ThrowableConvertor)new ThrowableConvertor<GithubConnection, String, IOException>(this){
            final /* synthetic */ GithubAccountInformationProvider this$0;

            @NotNull
            public final String convert(GithubConnection it) {
                GithubConnection githubConnection = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)githubConnection, (String)"it");
                return this.this$0.getAccountUsername(githubConnection);
            }
            {
                this.this$0 = githubAccountInformationProvider;
            }
        };
    }

    public GithubAccountInformationProvider() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

            @Override
            public void tokenChanged(@NotNull GithubAccount account) {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                informationCache.remove(account);
            }
        });
    }
}

