/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.extensions.GithubHttpAuthDataProvider;
import org.jetbrains.plugins.github.extensions.InteractiveGithubHttpAuthDataProvider;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;

public class GithubRepositoryHostingService
extends GitRepositoryHostingService {
    @NotNull
    private final GithubAuthenticationManager myAuthenticationManager;
    @NotNull
    private final GithubApiTaskExecutor myApiTaskExecutor;
    @NotNull
    private final GithubGitHelper myGitHelper;
    @NotNull
    private final GithubHttpAuthDataProvider myAuthDataProvider;

    public GithubRepositoryHostingService(@NotNull GithubAuthenticationManager manager, @NotNull GithubApiTaskExecutor executor, @NotNull GithubGitHelper gitHelper, @NotNull GithubHttpAuthDataProvider authDataProvider) {
        if (manager == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(1);
        }
        if (gitHelper == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(2);
        }
        if (authDataProvider == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(3);
        }
        this.myAuthenticationManager = manager;
        this.myApiTaskExecutor = executor;
        this.myGitHelper = gitHelper;
        this.myAuthDataProvider = authDataProvider;
    }

    @NotNull
    public String getServiceDisplayName() {
        if ("GitHub" == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(4);
        }
        return "GitHub";
    }

    @NotNull
    public RepositoryListLoader getRepositoryListLoader(final @NotNull Project project) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(5);
        }
        RepositoryListLoader repositoryListLoader = new RepositoryListLoader(){

            public boolean isEnabled() {
                for (GithubAccount account : GithubRepositoryHostingService.this.myAuthenticationManager.getAccounts()) {
                    if (!GithubRepositoryHostingService.this.myAuthenticationManager.hasTokenForAccount(account)) continue;
                    return true;
                }
                return false;
            }

            public boolean enable(@Nullable Component parentComponent) {
                if (!GithubAccountsMigrationHelper.getInstance().migrate(project, parentComponent)) {
                    return false;
                }
                return GithubRepositoryHostingService.this.myAuthenticationManager.ensureHasAccountsWithTokens(project, parentComponent);
            }

            @NotNull
            public Pair<List<String>, List<RepositoryListLoadingException>> getAvailableRepositoriesFromMultipleSources(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList urls = new ArrayList();
                ArrayList<RepositoryListLoadingException> exceptions = new ArrayList<RepositoryListLoadingException>();
                for (GithubAccount account : GithubRepositoryHostingService.this.myAuthenticationManager.getAccounts()) {
                    try {
                        urls.addAll(((List)GithubRepositoryHostingService.this.myApiTaskExecutor.execute(progressIndicator, account, connection -> GithubApiUtil.getAvailableRepos(connection), true)).stream().sorted(Comparator.comparing(GithubRepo::getUserName).thenComparing(GithubRepo::getName)).map(repo -> GithubRepositoryHostingService.this.myGitHelper.getRemoteUrl(account.getServer(), repo.getUserName(), repo.getName())).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        exceptions.add(new RepositoryListLoadingException("Cannot load repositories from Github", (Throwable)e));
                    }
                }
                Pair pair = Pair.create(urls, exceptions);
                if (pair == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pair;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progressIndicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAvailableRepositoriesFromMultipleSources";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getAvailableRepositoriesFromMultipleSources";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (repositoryListLoader == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(6);
        }
        return repositoryListLoader;
    }

    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(7);
        }
        if (url == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(8);
        }
        return this.getProvider(project, url, null);
    }

    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url, @NotNull String login2) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(9);
        }
        if (url == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(10);
        }
        if (login2 == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(11);
        }
        return this.getProvider(project, url, login2);
    }

    @Nullable
    private InteractiveGitHttpAuthDataProvider getProvider(@NotNull Project project, @NotNull String url, @Nullable String login2) {
        Set<GithubAccount> potentialAccounts;
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(12);
        }
        if (url == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(13);
        }
        if ((potentialAccounts = this.myAuthDataProvider.getSuitableAccounts(project, url, login2)).isEmpty()) {
            return null;
        }
        return new InteractiveGithubHttpAuthDataProvider(project, potentialAccounts, this.myAuthenticationManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authDataProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "login";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryListLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryListLoader";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInteractiveAuthDataProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

