/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class FloatFieldWriter
extends FieldWriter {
    private String field;

    public FloatFieldWriter(String field) {
        this.field = field;
    }

    @Override
    public boolean write(SortDoc sortDoc, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (sortValue.isPresent()) {
                float val = ((Float)sortValue.getCurrentValue()).floatValue();
                ew.put(this.field, val);
                return true;
            }
            return false;
        }
        NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
        if (vals.advance(sortDoc.docId) == sortDoc.docId) {
            int val = (int)vals.longValue();
            ew.put(this.field, Float.intBitsToFloat(val));
            return true;
        }
        return false;
    }
}

