/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInjection {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern ENABLED_PERCENT = Pattern.compile("(true|false)(?:\\:(\\d+))?$", 2);
    private static final String LUCENE_TEST_CASE_FQN = "org.apache.lucene.util.LuceneTestCase";
    private static final Class LUCENE_TEST_CASE;
    public static String nonGracefullClose;
    public static String failReplicaRequests;
    public static String failUpdateRequests;
    public static String nonExistentCoreExceptionAfterUnload;
    public static String updateLogReplayRandomPause;
    public static String updateRandomPause;
    public static String prepRecoveryOpPauseForever;
    public static String randomDelayInCoreCreation;
    public static int randomDelayMaxInCoreCreationInSec;
    public static String splitFailureBeforeReplicaCreation;
    public static String splitFailureAfterReplicaCreation;
    public static String waitForReplicasInSync;
    public static String failIndexFingerprintRequests;
    public static String wrongIndexFingerprint;
    private static Set<Timer> timers;
    private static AtomicInteger countPrepRecoveryOpPauseForever;
    public static Integer delayBeforeSlaveCommitRefresh;
    public static boolean uifOutOfMemoryError;

    static Random random() {
        if (null == LUCENE_TEST_CASE) {
            return null;
        }
        try {
            Method randomMethod = LUCENE_TEST_CASE.getMethod("random", new Class[0]);
            return (Random)randomMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to use reflection to invoke LuceneTestCase.random()", e);
        }
    }

    public static void reset() {
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        nonExistentCoreExceptionAfterUnload = null;
        updateLogReplayRandomPause = null;
        updateRandomPause = null;
        randomDelayInCoreCreation = null;
        splitFailureBeforeReplicaCreation = null;
        splitFailureAfterReplicaCreation = null;
        prepRecoveryOpPauseForever = null;
        countPrepRecoveryOpPauseForever = new AtomicInteger(0);
        waitForReplicasInSync = "true:60";
        failIndexFingerprintRequests = null;
        wrongIndexFingerprint = null;
        delayBeforeSlaveCommitRefresh = null;
        uifOutOfMemoryError = false;
        for (Timer timer : timers) {
            timer.cancel();
        }
    }

    public static boolean injectWrongIndexFingerprint() {
        if (wrongIndexFingerprint != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(wrongIndexFingerprint);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                return true;
            }
        }
        return false;
    }

    public static boolean injectFailIndexFingerprintRequests() {
        if (failIndexFingerprintRequests != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failIndexFingerprintRequests);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test index fingerprint fail");
            }
        }
        return true;
    }

    public static boolean injectRandomDelayInCoreCreation() {
        if (randomDelayInCoreCreation != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(randomDelayInCoreCreation);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                int delay = rand.nextInt(randomDelayMaxInCoreCreationInSec);
                log.info("Inject random core creation delay of {}s", (Object)delay);
                try {
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectNonGracefullClose(CoreContainer cc) {
        if (cc.isShutDown() && nonGracefullClose != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonGracefullClose);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                if (rand.nextBoolean()) {
                    throw new TestShutdownFailError("Test exception for non graceful close");
                }
                final Thread cthread = Thread.currentThread();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Random taskRand = TestInjection.random();
                            Thread.sleep(taskRand.nextInt(1000));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        cthread.interrupt();
                        timers.remove(this);
                        this.cancel();
                    }
                };
                Timer timer = new Timer();
                timers.add(timer);
                timer.schedule(task, rand.nextInt(500));
            }
        }
        return true;
    }

    public static boolean injectFailReplicaRequests() {
        if (failReplicaRequests != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failReplicaRequests);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectFailUpdateRequests() {
        if (failUpdateRequests != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failUpdateRequests);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectNonExistentCoreExceptionAfterUnload(String cname) {
        if (nonExistentCoreExceptionAfterUnload != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonExistentCoreExceptionAfterUnload);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new NonExistentCoreException("Core not found to unload: " + cname);
            }
        }
        return true;
    }

    public static boolean injectUpdateLogReplayRandomPause() {
        if (updateLogReplayRandomPause != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(updateLogReplayRandomPause);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                long rndTime = rand.nextInt(1000);
                log.info("inject random log replay delay of {}ms", (Object)rndTime);
                try {
                    Thread.sleep(rndTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectUpdateRandomPause() {
        if (updateRandomPause != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(updateRandomPause);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                long rndTime = rand.nextInt(10) > 2 ? (long)rand.nextInt(300) : (long)rand.nextInt(1000);
                log.info("inject random update delay of {}ms", (Object)rndTime);
                try {
                    Thread.sleep(rndTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectPrepRecoveryOpPauseForever() {
        if (prepRecoveryOpPauseForever != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(prepRecoveryOpPauseForever);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100 && countPrepRecoveryOpPauseForever.get() < 1) {
                countPrepRecoveryOpPauseForever.incrementAndGet();
                log.info("inject pause forever for prep recovery op");
                try {
                    Thread.sleep(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                countPrepRecoveryOpPauseForever.set(0);
            }
        }
        return true;
    }

    private static boolean injectSplitFailure(String probability, String label) {
        if (probability != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(probability);
            boolean enabled = (Boolean)pair.first();
            int chanceIn100 = (Integer)pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                log.info("Injecting failure: " + label);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error: " + label);
            }
        }
        return true;
    }

    public static boolean injectSplitFailureBeforeReplicaCreation() {
        return TestInjection.injectSplitFailure(splitFailureBeforeReplicaCreation, "before creating replica for sub-shard");
    }

    public static boolean injectSplitFailureAfterReplicaCreation() {
        return TestInjection.injectSplitFailure(splitFailureAfterReplicaCreation, "after creating replica for sub-shard");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressForbidden(reason="Need currentTimeMillis, because COMMIT_TIME_MSEC_KEY use currentTimeMillis as value")
    public static boolean waitForInSyncWithLeader(SolrCore core, ZkController zkController, String collection, String shardId) {
        if (waitForReplicasInSync == null) {
            return true;
        }
        log.info("Start waiting for replica in sync with leader");
        long currentTime = System.currentTimeMillis();
        Pair<Boolean, Integer> pair = TestInjection.parseValue(waitForReplicasInSync);
        boolean enabled = (Boolean)pair.first();
        if (!enabled) {
            return true;
        }
        long t = System.currentTimeMillis() - 200L;
        int i = 0;
        while (i < (Integer)pair.second()) {
            try {
                if (core.isClosed()) {
                    return true;
                }
                Replica leaderReplica = zkController.getZkStateReader().getLeaderRetry(collection, shardId);
                try (HttpSolrClient leaderClient = new HttpSolrClient.Builder(leaderReplica.getCoreUrl()).build();){
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("qt", new String[]{"/replication"});
                    params.set("command", new String[]{"details"});
                    NamedList response = leaderClient.request((SolrRequest)new QueryRequest((SolrParams)params));
                    long leaderVersion = (Long)((NamedList)response.get("details")).get("indexVersion");
                    String localVersion = core.withSearcher(searcher -> (String)searcher.getIndexReader().getIndexCommit().getUserData().get("commitTimeMSec"));
                    if (localVersion == null && leaderVersion == 0L && !core.getUpdateHandler().getUpdateLog().hasUncommittedChanges()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (localVersion != null && Long.parseLong(localVersion) == leaderVersion && (leaderVersion >= t || i >= 6)) {
                        log.info("Waiting time for tlog replica to be in sync with leader: {}", (Object)(System.currentTimeMillis() - currentTime));
                        boolean bl = true;
                        return bl;
                    }
                    log.debug("Tlog replica not in sync with leader yet. Attempt: {}. Local Version={}, leader Version={}", new Object[]{i, localVersion, leaderVersion});
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (core.isClosed()) {
                    return true;
                }
                log.error("Thread interrupted while waiting for core {} to be in sync with leader", (Object)core.getName());
                return false;
            }
            catch (Exception e) {
                if (core.isClosed()) {
                    return true;
                }
                log.error("Exception when wait for replicas in sync with master. Will retry until timeout.", (Throwable)e);
            }
            ++i;
        }
        return false;
    }

    private static Pair<Boolean, Integer> parseValue(String raw) {
        Matcher m = ENABLED_PERCENT.matcher(raw);
        if (!m.matches()) {
            throw new RuntimeException("No match, probably bad syntax: " + raw);
        }
        String val = m.group(1);
        String percent = "100";
        if (m.groupCount() == 2) {
            percent = m.group(2);
        }
        return new Pair((Object)Boolean.parseBoolean(val), (Object)Integer.parseInt(percent));
    }

    public static boolean injectDelayBeforeSlaveCommitRefresh() {
        if (delayBeforeSlaveCommitRefresh != null) {
            try {
                log.info("Pausing IndexFetcher for {}ms", (Object)delayBeforeSlaveCommitRefresh);
                Thread.sleep(delayBeforeSlaveCommitRefresh.intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    public static boolean injectUIFOutOfMemoryError() {
        if (uifOutOfMemoryError) {
            throw new OutOfMemoryError("Test Injection");
        }
        return true;
    }

    static {
        Class<?> nonFinalTemp = null;
        try {
            ClassLoader classLoader = MethodHandles.lookup().lookupClass().getClassLoader();
            nonFinalTemp = classLoader.loadClass(LUCENE_TEST_CASE_FQN);
        }
        catch (ClassNotFoundException e) {
            log.debug("TestInjection methods will all be No-Ops since LuceneTestCase not found");
        }
        LUCENE_TEST_CASE = nonFinalTemp;
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        nonExistentCoreExceptionAfterUnload = null;
        updateLogReplayRandomPause = null;
        updateRandomPause = null;
        prepRecoveryOpPauseForever = null;
        randomDelayInCoreCreation = null;
        randomDelayMaxInCoreCreationInSec = 10;
        splitFailureBeforeReplicaCreation = null;
        splitFailureAfterReplicaCreation = null;
        waitForReplicasInSync = "true:60";
        failIndexFingerprintRequests = null;
        wrongIndexFingerprint = null;
        timers = Collections.synchronizedSet(new HashSet());
        countPrepRecoveryOpPauseForever = new AtomicInteger(0);
        delayBeforeSlaveCommitRefresh = null;
        uifOutOfMemoryError = false;
    }

    public static class TestShutdownFailError
    extends OutOfMemoryError {
        public TestShutdownFailError(String msg) {
            super(msg);
        }
    }
}

