/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.extract.Extract;
import tr.extract.criteria.ValueIDsProviderEnergy;
import tr.extract.criteria.ValueIDsProviderPriority;
import tr.extract.criteria.ValueIDsProviderTime;
import tr.model.Item.ItemList;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.criteria.Value;
import tr.model.project.Project;

public class ExtractUtils {
    public static final Logger LOG = Logger.getLogger("tr.extract");
    public static final DateFormat DFN = Constants.DATE_FORMAT_FIXED;
    public static final DateFormat DFT = Constants.DATE_TIME_FORMAT_FIXED;

    public static synchronized Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<data>\r\n");
        return out;
    }

    public static synchronized void finalise(Writer out) throws Exception {
        out.write("</data>\r\n");
        out.flush();
        out.close();
    }

    public static synchronized String getState(Action a) {
        return ExtractUtils.getState(a, DFN, DFT);
    }

    public static synchronized String getState(Action a, DateFormat dfn, DateFormat dft) {
        StringBuffer sb = new StringBuffer();
        if (a.isStateASAP()) {
            sb.append("\u2605");
            sb.append(a.getDueDate() == null ? "" : " " + NbBundle.getMessage(ExtractUtils.class, (String)"Due") + ": " + dfn.format(a.getDueDate()));
        } else if (a.isStateDelegated()) {
            ActionStateDelegated s = (ActionStateDelegated)a.getState();
            sb.append("\u261e");
            sb.append(s.getTo() == null ? "" : " " + ExtractUtils.escape(s.getTo()));
            sb.append(s.getDate() == null ? "" : " " + NbBundle.getMessage(ExtractUtils.class, (String)"Followup_Abbrev") + ": " + dfn.format(s.getDate()));
            sb.append(a.getDueDate() == null ? "" : " " + NbBundle.getMessage(ExtractUtils.class, (String)"Due") + ": " + dfn.format(a.getDueDate()));
        } else if (a.isStateScheduled()) {
            ActionStateScheduled s = (ActionStateScheduled)a.getState();
            sb.append(s.getRecurrence() == null ? "\u2637" : "\u27f3");
            Date d = s.getDate();
            if (d != null) {
                sb.append(" ");
                sb.append(ExtractUtils.hasTime(d) ? dft.format(s.getDate()) : dfn.format(s.getDate()));
            }
            if (s.getDurationHours() > 0 || s.getDurationMinutes() > 0) {
                sb.append(" ");
                if (s.getDurationHours() > 0) {
                    sb.append(s.getDurationHours() + "h");
                }
                if (s.getDurationMinutes() > 0) {
                    sb.append(s.getDurationMinutes() + "m");
                }
            }
        } else if (a.isStateInactive()) {
            sb.append("\u2606");
            sb.append(a.getStartDate() == null ? "" : " " + NbBundle.getMessage(ExtractUtils.class, (String)"Start") + ": " + dfn.format(a.getStartDate()));
            sb.append(a.getDueDate() == null ? "" : " " + NbBundle.getMessage(ExtractUtils.class, (String)"Due") + ": " + dfn.format(a.getDueDate()));
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    public static synchronized String getSymbol(Action action) {
        switch (action.getState().getType()) {
            case DOASAP: {
                return "\u2605";
            }
            case SCHEDULED: {
                ActionStateScheduled state = (ActionStateScheduled)action.getState();
                return state.getRecurrence() == null ? "\u2637" : "\u27f3";
            }
            case DELEGATED: {
                return "\u261e";
            }
            case INACTIVE: {
                return "\u2606";
            }
        }
        return "";
    }

    public static synchronized String getDuration(ActionStateScheduled s) {
        StringBuffer sb = new StringBuffer();
        if (s.getDurationHours() > 0 || s.getDurationMinutes() > 0) {
            sb.append(" ");
            if (s.getDurationHours() > 0) {
                sb.append(s.getDurationHours() + "h");
            }
            if (s.getDurationMinutes() > 0) {
                sb.append(s.getDurationMinutes() + "m");
            }
        }
        return sb.toString();
    }

    public static synchronized String getActionDate(Action action) {
        Date date = action.getActionDate();
        if (date == null) {
            return "";
        }
        return action.isStateScheduled() ? DFT.format(date) : DFN.format(date);
    }

    public static synchronized String getActionDateIndex(Action action) {
        return Long.toString(action.getActionDate() == null ? Long.MAX_VALUE : action.getActionDate().getTime());
    }

    public static synchronized String getCriteria(Action action) {
        String result = ExtractUtils.getTime(action.getTime()) + " " + ExtractUtils.getEnergy(action.getEnergy()) + " " + ExtractUtils.getPriority(action.getPriority());
        return result.trim();
    }

    public static synchronized String getTime(Value time) {
        return time == null ? "" : "\u25f7" + ExtractUtils.escape(time.getName());
    }

    public static synchronized String getEnergy(Value energy) {
        return energy == null ? "" : "\u26a1" + ExtractUtils.escape(energy.getName());
    }

    public static synchronized String getPriority(Value priority) {
        return priority == null ? "" : "\u2690" + ExtractUtils.escape(priority.getName());
    }

    public static synchronized String getTimeIndex(Value value) {
        if (value == null) {
            return Integer.toString(Integer.MAX_VALUE);
        }
        return Integer.toString(ValueIDsProviderTime.instance.getIDs().indexOf(value.getID()));
    }

    public static synchronized String getEnergyIndex(Value value) {
        if (value == null) {
            return Integer.toString(Integer.MAX_VALUE);
        }
        return Integer.toString(ValueIDsProviderEnergy.instance.getIDs().indexOf(value.getID()));
    }

    public static synchronized String getPriorityIndex(Value value) {
        if (value == null) {
            return Integer.toString(Integer.MAX_VALUE);
        }
        return Integer.toString(ValueIDsProviderPriority.instance.getIDs().indexOf(value.getID()));
    }

    public static synchronized String getContext(Action action) {
        String context = action.getContext().getName().trim();
        if (!context.startsWith("@")) {
            context = "@" + context;
        }
        return ExtractUtils.escape(context);
    }

    public static synchronized String getTopic(Action action) {
        return "\u2302" + ExtractUtils.escape(action.getTopic().getName());
    }

    public static synchronized boolean hasTime(Date date) {
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(10) > 0 || calendar.get(12) > 0 || calendar.get(13) > 0;
    }

    public static String getProjectPath(Project project, String path) {
        Project parent;
        path = path.length() > 0 ? project.getDescription() + "/" + path : project.getDescription();
        ItemList object = project.getParent();
        if (object instanceof Project && !(parent = (Project)object).isRoot()) {
            return ExtractUtils.getProjectPath(parent, path);
        }
        return path;
    }

    public static synchronized String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }
}

