/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.parosproxy.paros.security.SslCertificateService;

public class SslCertificateUtils {
    public static final String BEGIN_CERTIFICATE_TOKEN = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE_TOKEN = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY_TOKEN = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY_TOKEN = "-----END PRIVATE KEY-----";
    private static final long DEFAULT_VALID_DAYS = 365L;

    public static final KeyStore createRootCA() throws NoSuchAlgorithmException {
        Date startDate = Calendar.getInstance().getTime();
        Date expireDate = new Date(startDate.getTime() + 31536000000L);
        KeyPairGenerator g = KeyPairGenerator.getInstance("RSA");
        g.initialize(2048, SecureRandom.getInstance("SHA1PRNG"));
        KeyPair keypair = g.genKeyPair();
        PrivateKey privKey = keypair.getPrivate();
        PublicKey pubKey = keypair.getPublic();
        Security.addProvider((Provider)new BouncyCastleProvider());
        Random rnd = new Random();
        X500NameBuilder namebld = new X500NameBuilder(BCStyle.INSTANCE);
        namebld.addRDN(BCStyle.CN, "OWASP Zed Attack Proxy Root CA");
        namebld.addRDN(BCStyle.L, Integer.toHexString(System.getProperty("user.name").hashCode()) + Integer.toHexString(System.getProperty("user.home").hashCode()));
        namebld.addRDN(BCStyle.O, "OWASP Root CA");
        namebld.addRDN(BCStyle.OU, "OWASP ZAP Root CA");
        namebld.addRDN(BCStyle.C, "xx");
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(namebld.build(), BigInteger.valueOf(rnd.nextInt()), startDate, expireDate, namebld.build(), pubKey);
        KeyStore ks = null;
        try {
            certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(pubKey.getEncoded()));
            certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            certGen.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(182));
            KeyPurposeId[] eku = new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth, KeyPurposeId.anyExtendedKeyUsage};
            certGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(eku));
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privKey);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(sigGen));
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            ks.setKeyEntry("owasp_zap_root_ca", privKey, SslCertificateService.PASSPHRASE, new Certificate[]{cert});
        }
        catch (Exception e) {
            throw new IllegalStateException("Errors during assembling root CA.", e);
        }
        return ks;
    }

    public static final String keyStore2String(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        keystore.store(baos, SslCertificateService.PASSPHRASE);
        byte[] bytes = baos.toByteArray();
        baos.close();
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    public static final KeyStore string2Keystore(String str) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        byte[] bytes = Base64.decodeBase64((String)str);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(bais, SslCertificateService.PASSPHRASE);
        bais.close();
        return ks;
    }

    public static KeyStore pem2Keystore(File pemFile) throws IOException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException {
        String certAndKey = FileUtils.readFileToString((File)pemFile, (Charset)StandardCharsets.US_ASCII);
        byte[] certBytes = SslCertificateUtils.extractCertificate(certAndKey);
        byte[] keyBytes = SslCertificateUtils.extractPrivateKey(certAndKey);
        return SslCertificateUtils.pem2KeyStore(certBytes, keyBytes);
    }

    public static byte[] extractCertificate(String pem) {
        return SslCertificateUtils.parseDERFromPEM(pem, BEGIN_CERTIFICATE_TOKEN, END_CERTIFICATE_TOKEN);
    }

    public static byte[] extractPrivateKey(String pem) {
        return SslCertificateUtils.parseDERFromPEM(pem, BEGIN_PRIVATE_KEY_TOKEN, END_PRIVATE_KEY_TOKEN);
    }

    private static boolean containsSection(String contents, String beginToken, String endToken) {
        int idxToken = contents.indexOf(beginToken);
        return idxToken != -1 && contents.indexOf(endToken) >= idxToken;
    }

    public static KeyStore pem2KeyStore(byte[] certBytes, byte[] keyBytes) throws IOException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException {
        X509Certificate cert = SslCertificateUtils.generateCertificateFromDER(certBytes);
        RSAPrivateKey key = SslCertificateUtils.generatePrivateKeyFromDER(keyBytes);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", cert);
        keystore.setKeyEntry("owasp_zap_root_ca", key, SslCertificateService.PASSPHRASE, new Certificate[]{cert});
        return keystore;
    }

    private static byte[] parseDERFromPEM(String pem, String beginDelimiter, String endDelimiter) {
        if (!SslCertificateUtils.containsSection(pem, beginDelimiter, endDelimiter)) {
            return new byte[0];
        }
        String[] tokens = pem.split(beginDelimiter);
        tokens = tokens[1].split(endDelimiter);
        return DatatypeConverter.parseBase64Binary((String)tokens[0]);
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    private static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }
}

