<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_http2 - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_http2</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_http2.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_http2.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Support de la couche transport HTTP/2</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>http2_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_http2.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.17 du serveur
    HTTP Apache</td></tr></table>
<h3>Sommaire</h3>

	<p>Ce module ajoute le support de HTTP/2 (<a href="https://tools.ietf.org/html/rfc7540">RFC 7540</a>) au serveur HTTP
	Apache.</p>
        
        <p>Il s'appuie sur la bibliothque <a href="http://nghttp2.org/">libnghttp2</a> pour implmenter le
	moteur de base http/2.</p>
        
        <p>Pour mettre en oeuvre les fonctionnalits dcrites dans ce
	document, vous devez activer HTTP/2 en utilisant la directive
	<code class="directive"><a href="../mod/core.html#protocols">Protocols</a></code>. HTTP/2 <a href="https://http2.github.io/faq/#does-http2-require-encryption">n'imposant
	pas</a> de chiffrement, deux protocoles sont disponibles :
	<code>h2</code> (HTTP/2 avec TLS) at <code>h2c</code> (HTTP/2 avec TCP).</p>

	<p>Voici deux types de configuration courant :</p>

	<div class="note"><h3>HTTP/2 dans un contexte de serveur virtuel (TLS seulement)</h3>
        <pre class="prettyprint lang-config">Protocols h2 http/1.1</pre>

	<p>Permet une ngociation HTTP/2 (h2) via TLS ALPN au sein d'un
	<code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>
	scuris. La vrification du prambule HTTP/2 (mode direct, voir
	<code class="directive"><a href="#h2direct">H2Direct</a></code>) est dsactive par
	dfaut pour <code>h2</code>.</p>
        </div>
 
        <div class="note"><h3>HTTP/2 dans un contexte de serveur (TLS et texte pur)</h3>
	<pre class="prettyprint lang-config">Protocols h2 h2c http/1.1</pre>

	<p>Permet une ngociation HTTP/2 (h2) via TLS ALPN au sein d'un
	<code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>
	scuris. Permet aussi une ngociation HTTP/2 en texte pur (h2c) en
	effectuant une mise  jour depuis une connexion initiale HTTP/1.1 ou via
	une vrification du prambule HTTP/2 (mode direct, voir
	<code class="directive"><a href="#h2direct">H2Direct</a></code>).</p>
        </div>
 
        <p>Si vous avez besoin d'informations supplmentaires  propos du
	protocole, veuillez vous reporter  la <a href="https://http2.github.io/faq">HTTP/2 FAQ</a>.</p>
	

    </div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#how-it-works">Comment a marche ?</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#h2copyfiles">H2CopyFiles</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2direct">H2Direct</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2earlyhints">H2EarlyHints</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2maxsessionstreams">H2MaxSessionStreams</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2maxworkeridleseconds">H2MaxWorkerIdleSeconds</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2maxworkers">H2MaxWorkers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2minworkers">H2MinWorkers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2moderntlsonly">H2ModernTLSOnly</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2push">H2Push</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2pushdiarysize">H2PushDiarySize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2pushpriority">H2PushPriority</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2pushresource">H2PushResource</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2serializeheaders">H2SerializeHeaders</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2streammaxmemsize">H2StreamMaxMemSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2tlscooldownsecs">H2TLSCoolDownSecs</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2tlswarmupsize">H2TLSWarmUpSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2upgrade">H2Upgrade</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#h2windowsize">H2WindowSize</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_http2">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_http2">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="how-it-works" id="how-it-works">Comment a marche ?</a></h2>
    
    <h3><a name="dimensioning" id="dimensioning">Quantification des ressources
    supplmentaires ncessaires  HTTP/2</a></h3>
        <p>
            Activer HTTP/2 sur votre serveur Apache a un impact sur la
	    consommation de ressources, et si votre site est trs actif, il est
	    conseill d'en prendre srieusement en compte les implications.
        </p>
        <p>
            HTTP/2 attribue  chaque requte qu'il reoit son propre <em>thread
	    de travail</em> pour son traitement, la collecte des rsultats et
	    l'envoie de ces derniers au client. Pour y parvenir, il lui faut
	    lancer des threads supplmentaires, et ceci constituera le premier
	    effet notable de l'activation de HTTP/2.
        </p>
        <p>
	    Dans l'implmentation actuelle, ces threads de travail font partie
	    d'un jeu de threads distinct de celui des threads de travail du MPM
	    avec lequel vous tes famili. Il s'agit simplement du mode de
	    fonctionnement actuel, et il n'en sera pas obligatoirement toujours
	    ainsi (il est cependant probable que la situation restera inchange
	    avec la version 2.4.x). De par ce mode de fonctionnement, les
	    threads de travail HTTP/2, ou plus simplement H2 ne seront pas
	    affichs par <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>. De mme, ils ne seront pas
	    pris en compte par les directives du style <code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code>. Par contre, ils
	    utilisent par dfaut la valeur de <code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code> si vous n'avez pas
	    spcifi d'autres valeurs via <code class="directive"><a href="#h2minworkers">H2MinWorkers</a></code> et <code class="directive"><a href="#h2maxworkers">H2MaxWorkers</a></code>.
        </p>
        <p>
            Autre changement  surveiller : la consommation de mmoire. En
	    effet, comme HTTP/2 conserve plus d'informations sur le serveur pour
	    grer toutes les requtes en cours, leurs priorits et
	    interdpendances, il aura toujours besoin de plus de mmoire que
	    pour un traitement en HTTP/1.1. Trois directives permettent de
	    limiter l'empreinte mmoire d'une connexion HTTP/2 : <code class="directive"><a href="#h2maxsessionstreams">H2MaxSessionStreams</a></code>, <code class="directive"><a href="#h2windowsize">H2WindowSize</a></code> et <code class="directive"><a href="#h2streammaxmemsize">H2StreamMaxMemSize</a></code>.
        </p>
        <p>
            La directive <code class="directive"><a href="#h2maxsessionstreams">H2MaxSessionStreams</a></code> permet de limiter
	    le nombre de requtes simultanes qu'un client peut envoyer sur une
	    connexion HTTP/2. La valeur que vous allez dfinir dpend de votre
	    site. La valeur par dfaut qui est de 100 est largement suffisante,
	    et  moins que vous ne soyez un peu juste en mmoire, je vous
	    conseille de ne pas la modifier. La plupart des requtes qu'envoie
	    un client sont des requtes de type GET sans corps qui n'utilisent
	    que trs peu de mmoire en attendant le dmarrage du traitement.
	    
        </p>
        <p>
            La directive <code class="directive"><a href="#h2windowsize">H2WindowSize</a></code>
	    permet de dfinir la taille maximale que peut avoir le corps d'une
	    requte que le client envoie avant d'attendre que le serveur
	    en demande d'avantage. En d'autres termes, il s'agit de la quantit
	    de donnes que le serveur peut stocker dans son tampon, valable pour
	    une requte.
        </p>
        <p>
	    En outre, la directive <code class="directive"><a href="#h2streammaxmemsize">H2StreamMaxMemSize</a></code> permet de dfinir
	    la quantit de donnes de la rponse qui doit tre mise en tampon.
	    Chaque requte tant prise en charge par un thread H2Worker et
	    produisant des donnes que le serveur tente de transmettre au client
	    via une connexion HTTP/2, si le client n'est pas en mesure de lire
	    ces donnes assez rapidement, la connexion les mettra en tampon et
	    interrompra l'excution du thread H2Worker correspondant.
        </p>
        
    
    
    <h3><a name="misdirected" id="misdirected">Serveurs virtuels et requtes mal
    rediriges</a></h3>
        <p>
            De nombreux site utilisent le mme certificat TLS pour plusieurs
	    serveurs virtuels. Ce certificat rfrence un nom de serveur
	    gnrique comme '*.example.org' ou plusieurs noms de serveur
	    diffrents. Les navigateurs qui utilisent HTTP/2 dtectent ce
	    comportement et rutilisent une connexion dj ouverte pour ces
	    serveurs.
        </p>
        <p>
            Ceci amliore considrablement les performances, mais il y a un prix
	     payer : il faut accorder un soin tout particulier  la
	    configuration de tels serveurs virtuels. Le problme rside dans le
	    fait que plusieurs requtes pour plusieurs serveurs virtuels vont se
	    partager la mme connexion TLS, et ceci empche toute rengociation
	    car le standard HTTP/2 l'interdit.
        </p>
        <p>
            Ainsi, lorsque plusieurs de vos serveurs virtuels utilisent le mme
	    certificat et si vous souhaitez utiliser HTTP/2 pour y accder, vous
	    devez vous assurer que tous vos serveurs virtuels possdent
	    exactement la mme configuration SSL. En particulier, ils doivent
	    utiliser les mmes protocole, algorithme de chiffrement et
	    configuration pour la vrification du client.
        </p>
        <p>
	    Dans le cas contraire, Apache httpd le dtectera et renverra au
	    client un code de rponse spcial, 421 Misdirected Request.
        </p>
    

    <h3><a name="envvars" id="envvars">Variables d'environnement</a></h3>
        
        <p>Ce module peut tre configur pour fournir des informations en
	rapport avec HTTP/2 sous la forme de variables d'environnement
	supplmentaires dans l'espace de nommage SSI et CGI, ainsi que dans les
	configurations personnalises de le journalisation (voir
	<code>%{VAR_NAME}e</code>).
        </p>
        
        <table class="bordered">
            
            <tr>
                <th><a name="table3">Nom variable :</a></th>
                <th>Type :</th>
                <th>Description :</th>
            </tr>
            <tr><td><code>HTTPe</code></td><td>drapeau</td><td>HTTP/2 est utilis.</td></tr>
            <tr><td><code>H2PUSH</code></td><td>drapeau</td><td>La
	    fonctionnalit HTTP/2 Server Push est active pour cette requte et
	    supporte par le client.</td></tr>
	    <tr><td><code>H2_PUSH</code></td><td>drapeau</td><td>autre nom pour <code>H2PUSH</code></td></tr>
            <tr><td><code>H2_PUSHED</code></td><td>chane</td><td>vide ou
	    <code>PUSHED</code> pour une requte pushe par le serveur.</td></tr>
            <tr><td><code>H2_PUSHED_ON</code></td><td>nombre</td><td>numro du
	    flux HTTP/2 qui a dclench le push de cette requte.</td></tr>
            <tr><td><code>H2_STREAM_ID</code></td><td>nombre</td><td>numro du
	    flux HTTP/2 de cette requte.</td></tr>
            <tr><td><code>H2_STREAM_TAG</code></td><td>chane</td><td>identifiant
	    de flux unique du processus HTTP/2 compos de l'identifiant de la
	    connexion et de l'identifiant du flux spars par <code>-</code>.</td></tr>
        </table>
    

    </div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2copyfiles" id="h2copyfiles">Directive</a> <a name="H2CopyFiles" id="H2CopyFiles">H2CopyFiles</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle la gestion des fichiers dans les rponses</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2CopyFiles on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2CopyFiles off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.24 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet de dfinir la manire de grer les
		contenus de fichiers dans les rponses. Lorsqu'elle est  <code>off</code>
		(sa valeur par dfaut), les descripteurs de fichiers sont
		transmis par le processus de traitement de la requte vers la
		connexion principale en utilisant le systme habituel de mise en
		rserve d'Apache pour grer le dure de vie du fichier.
            </p>
            <p>
                Lorsqu'elle est  <code>on</code>, le contenu du fichier est
		recopier pendant le traitement de la requte et ces donnes
		mises en tampon sont transmises vers la connexion principale, ce
		qui s'avre avantageux lorsqu'un module tiers injecte dans la
		rponse des fichiers possdant des dures de vie diffrentes. 
            </p>
            <p>
                Un exemple de ces modules tiers : <code>mod_wsgi</code> qui peut
		injecter des descripteurs de fichiers dans la rponse. Ces
		fichiers sont ferms lorsque Python estime que le traitement est
		termin, alors que <code class="module"><a href="../mod/mod_http2.html">mod_http2</a></code> est probablement
		encore loin d'en avoir fini avec eux.
            </p>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2direct" id="h2direct">Directive</a> <a name="H2Direct" id="H2Direct">H2Direct</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Activation du protocole H2 Direct</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2Direct on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2Direct on pour h2c, off pour le protocole h2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet d'activer/dsactiver
		l'utilisation du mode HTTP/2 Direct. Elle doit tre
		situe dans une section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> afin d'activer la
		communication directe HTTP/2 pour le serveur virtuel
		considr. 
            </p>
            <p>
                La notion de communication directe signifie que si les
		premiers octets reus par le serveur correspondent  un
		en-tte HTTP/2, le protocole HTTP/2 est utilis sans
		ngociation supplmentaire. Ce mode est dfini pour
		les transmissions en clair (h2c) dans la RFC 7540. Son
		utilisation avec les connexions TLS n'est pas
		officiellement supporte.
            </p>
            <p>
                Lorsque le protocole h2 ou h2c n'est pas activ via la
		directive <code class="directive"><a href="../mod/core.html#protocols">Protocols</a></code>, la recherche d'un en-tte HTTP/2 n'est
		jamais effectue au sein d'une connexion. La directive
		<code class="directive">H2Direct</code> ne produit alors aucun effet. Ceci est
		important pour les connexions qui utilisent un protocole
		pour lequel une lecture initiale peut entraner un
		blocage dfinitif comme NNTP.
            </p>
            <p>
                Pour un client qui sait qu'un serveur supporte h2c, la
		communication directe HTTP/2 dispense le client d'une
		mise  jour HTTP/1.1, ce qui entrane une amlioration
		des performances et vite les restrictions sur les corps
		de requte suite  une mise  jour.
            </p>
            <p>
                Cette directive rend aussi h2c plus attractif pour les
		communications de serveur  serveur lorsque la connexion
		est sure ou peut tre scurise d'une manire ou d'une
		autre.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2Direct on</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2earlyhints" id="h2earlyhints">Directive</a> <a name="H2EarlyHints" id="H2EarlyHints">H2EarlyHints</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle l'envoi de codes d'tat 103</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2EarlyHints on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2EarlyHints off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.24 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet de dfinir si les rponses intermdiaires
		contenant un code d'tat HTTP 103 doivent tre envoyes au
		client ou non. Par dfaut ce n'est actuellement pas le cas car
		certains clients ont encore des problmes avec les rponses
		intermdiaires inattendues.
            </p>
            <p>
                Lorsque cette directive est dfinie  <code>on</code>, les
		ressources PUSHes dfinie par la directive
		<code>H2PushResource</code> dclenchent une rponse
		intermdiaire 103 avant la rponse finale. Cette rponse 103
		comporte des en-ttes <code>Link</code> qui provoquent le
		<code>prchargement</code> des ressources considres. 
            </p>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2maxsessionstreams" id="h2maxsessionstreams">Directive</a> <a name="H2MaxSessionStreams" id="H2MaxSessionStreams">H2MaxSessionStreams</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximal de flux actifs par session HTTP/2.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2MaxSessionStreams <em>n</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2MaxSessionStreams 100</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir le nombre maximal de flux
		actifs par session (connexion) HTTP/2 accept par le serveur.
		Selon la RFC 7540, un flux est considr comme actif s'il n'est
		ni <code>en attente</code> ni <code>ferm</code>.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2MaxSessionStreams 20</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2maxworkeridleseconds" id="h2maxworkeridleseconds">Directive</a> <a name="H2MaxWorkerIdleSeconds" id="H2MaxWorkerIdleSeconds">H2MaxWorkerIdleSeconds</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximal de secondes pendant lequel une unit de
	traitement h2 pourra rester inactive sans tre arrte.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2MaxWorkerIdleSeconds <em>n</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2MaxWorkerIdleSeconds 600</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir le nombre maximal de secondes
		pendant lequel une unit de traitement h2 pourra rester inactive
		avant de s'arrter elle-mme. Cet arrt ne peut cependant se
		produire que si le nombre d'units de traitement h2 dpasse
		<code class="directive"><a href="#h2minworkers">H2MinWorkers</a></code>.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2MaxWorkerIdleSeconds 20</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2maxworkers" id="h2maxworkers">Directive</a> <a name="H2MaxWorkers" id="H2MaxWorkers">H2MaxWorkers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximal de threads  utiliser pour chaque processus
	enfant.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2MaxWorkers <em>n</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir le nombre maximal de threads 
		lancer pour le traitement HTTP/2 de chaque processus enfant. Si
		cette directive n'est pas dfinie, <code class="module"><a href="../mod/mod_http2.html">mod_http2</a></code>
		choisira une valeur approprie en fonction du module <code>mpm</code>
		utilis.
		
		This directive sets the maximum number of worker threads to spawn
                per child process for HTTP/2 processing. If this directive is not used,
                <code>mod_http2</code> will chose a value suitable for the <code>mpm</code>
                module loaded.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2MaxWorkers 20</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2minworkers" id="h2minworkers">Directive</a> <a name="H2MinWorkers" id="H2MinWorkers">H2MinWorkers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre minimal de threads  utiliser pour chaque processus
	enfant.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2MinWorkers <em>n</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir le nombre minimal de threads 
		lancer pour le traitement HTTP/2 de chaque processus enfant. Si
		cette directive n'est pas dfinie, <code class="module"><a href="../mod/mod_http2.html">mod_http2</a></code>
		choisira une valeur approprie en fonction du module <code>mpm</code>
		utilis.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2MinWorkers 10</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2moderntlsonly" id="h2moderntlsonly">Directive</a> <a name="H2ModernTLSOnly" id="H2ModernTLSOnly">H2ModernTLSOnly</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Impose les connexions HTTP/2 en mode "TLS moderne"
	seulement</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2ModernTLSOnly on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2ModernTLSOnly on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.18 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet de dfinir si les vrifications de
		scurit sur les connexions HTTP/2 doivent tre exclusivement en
		mode TLS (https:). Elle peut tre place au niveau du serveur
		principal ou dans une section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>. 
            </p>
            <p>
                Les vrifications de scurit ncessitent TLSv1.2 au minimum et
		l'absence de tout algorithme de chiffrement list dans la RFC
		7540, Appendix A. Ces vrifications seront tendues lorsque de
		nouveaux prrequis en matire de scurit seront mis en place.
            </p>
            <p>
                Le nom provient des dfinitions Mozilla <a href="https://wiki.mozilla.org/Security/Server_Side_TLS">Security/Server
		Side TLS</a> o il est question de "modern compatibility".
		Mozilla Firefox et d'autres navigateurs imposent la "modern
		compatibility" pour les connexions HTTP/2. Comme toute chose en
		matire de scurit oprationnelle, c'est une cible mouvante
		susceptible d'voluer dans le futur.
            </p>
            <p>
                Un des buts de ces vrifications dans <code class="module"><a href="../mod/mod_http2.html">mod_http2</a></code> tend  imposer
		ce niveau de scurit pour toutes les connexions, et non
		seulement celles en provenance des navigateurs web. Un autre but
		est l'interdiction d'utiliser HTTP/2 en tant que protocole dans
		les ngociations si les prrequis ne sont pas respects.
            </p>
            <p>
                En fin de compte, la scurit de la connexion TLS est dtermine
		par les directives de configuration du serveur pour <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2ModernTLSOnly off</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2push" id="h2push">Directive</a> <a name="H2Push" id="H2Push">H2Push</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Activation/dsactivation du server push H2</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2Push on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2Push on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.18 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet d'activer/dsactiver
		l'utilisation de la fonctionnalit server push du
		protocole HTTP/2. 
            </p>
            <p>
                Lorsqu'un client demande une ressource particulire, le
		protocole HTTP/2 permet au serveur de lui fournir des
		ressources supplmentaires. Ceci s'avre utile lorsque
		ces ressources sont relies entre elles, ce qui peut
		laisser supposer que le client va probablement les
		demander dans un dlai plus ou moins long. Le mcanisme
		de pushing permet alors au client d'conomiser le temps
		qu'il lui aurait fallu pour demander ces ressources
		supplmentaires lui-mme. Par contre, fournir au client
		des ressources dont il n'a pas besoin ou qu'il possde
		dj constitue une perte de bande passante.
            </p>
            <p>
                Les server pushes sont dtects en inspectant les
		en-ttes <code>Link</code> des rponses (voir
		https://tools.ietf.org/html/rfc5988 pour la
		spcification). Lorsqu'un lien spcifi de cette manire
		possde l'attribut <code>rel=preload</code>, il est
		considr comme devant faire l'objet d'un push.
            </p>
            <p> 
                Les en-ttes link des rponses sont soit dfinis par
		l'application, soit configurs via
		<code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code> comme suit :
            </p>
            <div class="example"><h3>Exemple de configuration d'en-tte link via mod_headers</h3><pre class="prettyprint lang-config">&lt;Location /index.html&gt;
    Header add Link "&lt;/css/site.css&gt;;rel=preload"
    Header add Link "&lt;/images/logo.jpg&gt;;rel=preload"
&lt;/Location&gt;</pre>
</div>
            <p>
                Comme le montre l'exemple, il est possible d'ajouter
		autant d'en-ttes link que l'on souhaite  une rponse, ce qui dclenchera
		autant de pushes. Cette fonctionnalit doit donc tre
		utilise avec prudence car le module ne vrifie pas si
		une ressource n'a pas dj t "pushe" vers un client.
            </p>
            <p> 
                Les server pushes HTTP/2 sont activs par dfaut. Cette
		directive permet de dsactiver cette fonctionnalit pour
		le serveur virtuel ou non considr.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2Push off</pre>
</div>
            <p>
                Enfin, il est important de savoir que les pushes ne se
		produisent que si le client en manifeste le dsir ; la
		plupart des navigateurs le font, mais certains, comme
		Safari 9, ne le font pas. En outre, les pushes ne se produisent que
		pour les ressources de la mme <em>autorit</em> que celle de la
		rponse originale.
            </p>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2pushdiarysize" id="h2pushdiarysize">Directive</a> <a name="H2PushDiarySize" id="H2PushDiarySize">H2PushDiarySize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille du journal des Pushes H2</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2PushDiarySize n</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2PushDiarySize 256</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.19 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet de dfinir le nombre maximum de pushes
		qui seront enregistrs pour une connexion HTTP/2. Elle peut tre
		place dans une section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> afin de dfinir le nombre
		de pushes pour le serveur virtuel considr. 
            </p>
            <p>
                Le journal des pushes enregistre un condens (sous la forme d'un
		nombre de 64 bits) des ressources prcharges (leurs URLs) afin
		d'viter les duplications de pushes pour une mme connexion.
		Cependant, ces donnes ne sont pas conserves, et les clients
		qui ouvrent une nouvelle connexion se verront  nouveau affecter les
		mmes pushes. A ce titre, une tude est en cours pour permettre
		au client de supprimer le condens des ressources qu'il possde
		dj, et par l-mme de rinitialiser le journal des pushes 
		chaque nouvelle connexion.
            </p>
            <p>
                Si la taille maximale est atteinte, les nouvelles entres
		remplacent les plus anciennes. Une entre du journal ncessitant
		8 octets, un journal de 256 entres consomme 2 Ko de mmoire.
            </p>
            <p>
                Si cette directive est dfinie  0, le journal des pushes est
		dsactiv.
            </p>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2pushpriority" id="h2pushpriority">Directive</a> <a name="H2PushPriority" id="H2PushPriority">H2PushPriority</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Priorit des pushes H2</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2PushPriority mime-type [after|before|interleaved] [weight]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2PushPriority * After 16</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.18 du serveur HTTP
	Apache. Ncessite la bibliothque nghttp2 version 1.5.0 ou suprieure.</td></tr>
</table>
            <p>
                Cette directive permet de dfinir une gestion de priorit des
		pushes en fonction du type de contenu de la rponse. Elle est en
		gnral dfinie au niveau du serveur principal, mais peut aussi
		l'tre au niveau d'un serveur virtuel. 
            </p>
            <p>
                Les pushes HTTP/2 sont toujours lis  une requte client.
		Chaque paire requte/rponse de cette sorte, ou <em>flux</em>,
		possde une dpendance et un poids qui dfinissent la
		<em>priorit</em> du flux. 
            </p>
            <p>
                Lorsqu'un flux <em>dpend</em> d'un autre, disons X dpend de Y,
		alors Y reoit toute la bande passante avant que X n'en reoive
		ne serait-ce qu'une partie. Notez que cela ne signifie en rien
		que Y bloque X ; en effet, si Y n'a aucune donne  envoyer,
		toute la bande passante qui lui est alloue peut tre utilise
		par X.
            </p>
            <p>
                Lorsque plusieurs flux dpendent d'un mme autre flux, disons X1
		et X2 dpendent tous deux de Y, le <em>poids</em> dtermine la
		bande passante alloue. Ainsi, si X1 et X2 possdent le mme
		poids, ils recevront tous deux la moiti de la bande passante
		disponible. Si le poids de X1 est gal au double de celui de X2,
		X1 recevra une bande passante double de celle de X2.
		
            </p>
            <p> 
                En fin de compte, tout flux dpend du flux <em>racine</em> qui
		reoit toute la bande passante disponible mais n'envoie jamais
		de donnes. Cette bande passante est ainsi rpartie entre les flux
		enfants selon leur poids. Ces derniers l'utilisent alors pour
		envoyer leurs donnes ou pour la rpartir entre leurs propres
		flux enfants, et ainsi de suite. Si aucun des flux enfants n'a
		de donnes  envoyer, la bande passante est attribue  d'autres
		flux selon les mmes rgles.
            </p>
            <p> 
                Ce systme de priorits a t conu de faon a toujours pouvoir
		utiliser la bande passante disponible tout en dfinissant des
		priorits et en attribuant des poids aux diffrents flux. Ainsi,
		tous les flux sont en gnral initialiss par le client qui
		lui-mme dfinit les priorits.
            </p>
            <p>
                Seul le fait de savoir qu'un flux implique un PUSH permet au
		serveur de dcider quelle est la priorit <em>initiale</em> d'un
		tel flux. Dans les exemples ci-dessous, X est le flux client. Il
		dpend de Y et le serveur dcide de "PUSHer" les flux P1 et P2
		sur X.
            </p>
            <p>
                La rgle de priorit par dfaut est :
            </p>
            <div class="example"><h3>Rgle de priorit par dfaut</h3><pre class="prettyprint lang-config">H2PushPriority * After 16</pre>
</div>
            <p>
                Elle peut se traduire par "Envoyer un flux PUSH avec tout type
		de contenu et dpendant du flux client avec le poids 16". P1 et
		P2 seront alors envoys aprs X, et comme leurs poids sont
		identiques, il se verront allouer la mme quantit de bande
		passante.
            </p>
            <div class="example"><h3>Rgle de priorit entrelace</h3><pre class="prettyprint lang-config">H2PushPriority text/css Interleaved 256</pre>
</div>
            <p>
                Ce qui peut se traduire par "Envoyer toute ressource CSS dans la
		mme dpendance et avec le mme poids que le flux client". Si le
		type de contenu de P1 est "text/css", il dpendra de Y (comme X)
		et son poids effectif sera calcul selon la formule : <code>P1ew
		= Xw * (P1w / 256)</code>. Si P1w est de 256, Le poids effectif
		de P1 sera le mme que celui de X. Si X et P1 ont des donnes 
		envoyer, il se verront allouer la mme quantit de bande
		passante.
            </p>
            <p>
                Avec un Pw de 512, un flux entrelac et PUSH aura un poids
		double de celui de X. Avec un poids de 128, son poids ne sera
		que la moiti de celui de X. Notez que les poids effectifs sont
		toujours plafonns  256.
		
            </p>
            <div class="example"><h3>Rgle de priorit Before</h3><pre class="prettyprint lang-config">H2PushPriority application/json Before</pre>
</div>
            <p>
                Dans cet exemple, tout flux PUSH dont le contenu est de type
		'application/json' sera envoy <em>avant</em> X, ce qui rend P1
		dpendant de Y et X dpendant de P1. Ainsi, X sera mis en
		attente aussi longtemps que P1 aura des donnes  envoyer. Le
		poids effectif est hrit du flux client, et l'attribution d'un
		poids spcifique n'est pas autorise.
            </p>
            <p>
                Vous devez garder  l'esprit que les spcifications en matire
		de priorits sont limites par les ressources disponibles du
		serveur. Si un serveur ne dispose d'aucun processus/thread de
		travail pour les flux PUSHs, les donnes du flux considr ne
		seront envoyes que lorsque les autres flux auront termin
		l'envoi des leurs.
            </p>
            <p>
                Enfin et surtout, il convient de tenir compte de certaines
		particularits de la syntaxe de cette directive :
             </p>
            <ol>
                <li>'*' est la seule expression permettant de remplacer tout
		type de contenu. 'image/*' ne fonctionnera pas.</li>
                <li>La dpendance par dfaut est 'After'.</li>
                <li>Il existe aussi des poids par dfaut : pour 'After' le poids
		est de 16, alors que pour 'interleaved' il est de 256. 
                </li>
            </ol>
            <div class="example"><h3>Exemples de rgles</h3><pre class="prettyprint lang-config">H2PushPriority application/json 32         # une rgle de priorit 'After'
H2PushPriority image/jpeg before           # poid hrit
H2PushPriority text/css   interleaved      # poids de 256 par dfaut</pre>
</div>
         
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2pushresource" id="h2pushresource">Directive</a> <a name="H2PushResource" id="H2PushResource">H2PushResource</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dclare des ressources  proposer ("pusher") au client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2PushResource [add] path [critical]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.24 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Lorsqu'il sont activs pour un rpertoire, les PUSHes HTTP/2 seront
		tents pour tous les chemins ajouts via cette directive. Cette
		dernire peut tre utilise plusieurs fois pour le mme
		rpertoire.
            </p>
            <p>
                Cette directive propose des ressources beaucoup plus tt que les
		en-ttes <code>Link</code> de <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code>.
		<code class="module"><a href="../mod/mod_http2.html">mod_http2</a></code> prsente ces ressources au client via
		une rponse intermdiaire <code>103 Early Hints</code>. Ceci
		implique que les clients qui ne supportent pas PUSH recevront
		quand-mme rapidement des propositions de prchargement.
            </p>
            <p>
                A la diffrence de la dfinition d'en-ttes de rponse
		<code>Link</code> via <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code>, cette
		directive n'aura d'effet que pour les connexions HTTP/2. 
            </p>
            <p>
                En ajoutant l'option <code>critical</code>  une telle
		ressource, le serveur la traitera prioritairement, et une fois
		les donnes disponibles, ces dernires seront envoyes avant les
		donnes de la requte principale.
            </p>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2serializeheaders" id="h2serializeheaders">Directive</a> <a name="H2SerializeHeaders" id="H2SerializeHeaders">H2SerializeHeaders</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active/dsactive la srialisation du traitement des
	requtes/rponses</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2SerializeHeaders on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2SerializeHeaders off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir si les requtes HTTP/2 doivent
		tre srialises au format HTTP/1.1 pour tre traites par le
		noyau de <code>httpd</code>, ou si les donnes binaires reues
		doivent tre passes directement aux <code>request_rec</code>s.
            </p>
            <p>
                La srialisation dgrade les performances, mais garantit une
		meilleure compatibilit ascendante lorsque des filtres ou
		programmes accroche personnaliss en ont besoin.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2SerializeHeaders on</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2streammaxmemsize" id="h2streammaxmemsize">Directive</a> <a name="H2StreamMaxMemSize" id="H2StreamMaxMemSize">H2StreamMaxMemSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Quantit maximale de donnes en sortie mises en tampon par
	flux.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2StreamMaxMemSize <em>bytes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2StreamMaxMemSize 65536</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir la quantit maximale de
		donnes en sortie mises en tampon mmoire pour un flux actif. Ce
		tampon mmoire n'est pas allou pour chaque flux en tant que
		tel. Les quantits de mmoire sont dfinies en fonction de
		cette limite lorsqu'elles sont sur le point d'tre alloues. Le
		flux s'arrte lorsque la limite a t atteinte, et ne reprendra
		que lorsque les donnes du tampon auront t transmises au
		client.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2StreamMaxMemSize 128000</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2tlscooldownsecs" id="h2tlscooldownsecs">Directive</a> <a name="H2TLSCoolDownSecs" id="H2TLSCoolDownSecs">H2TLSCoolDownSecs</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td /></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2TLSCoolDownSecs <em>seconds</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2TLSCoolDownSecs 1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.18 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet de spcifier le nombre de secondes avant
		lequel une connexion TLS inactive va diminuer
		la taille des paquets de donnes  une valeur infrieure (~1300
		octets). Elle peut tre dfinie au niveau du serveur principal
		ou pour un <code class="directive"><a href="../mod/core.html#serveur virtuel">&lt;serveur
		virtuel&gt;</a></code> spcifique. 
            </p>
            <p>
                Voir la directive <code class="directive"><a href="#h2tlswarmupsize">H2TLSWarmUpSize</a></code> pour une description
		du "prchauffage" de TLS. La directive <code class="directive">H2TLSCoolDownSecs</code> met en
		lumire le fait que les connexions peuvent se dtriorer au bout
		d'un certain temps (et au fur et  mesure des corrections du
		flux TCP), et cela mme si elle sont inactives. Pour ne pas
		dtriorer les performances d'une manire gnrale, il est par
		consquent prfrable de revenir  la phase de prchauffage
		lorsqu'aucune donne n'a t transmise pendant un certain nombre
		de secondes. 
            </p>
            <p>
                Dans les situations o les connexions peuvent tre considres
		comme fiables, ce dlai peut tre dsactiv en dfinissant cette
		directive  0. 
            </p>
            <p>
                Dans l'exemple suivant, la directive est dfinie  0, ce qui
		dsactive tout retour  une phase de prchauffage des connexions
		TLS. Les connexions TLS dj prchauffes conservent donc toujours
		leur taille de paquet de donnes maximale.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2TLSCoolDownSecs 0</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2tlswarmupsize" id="h2tlswarmupsize">Directive</a> <a name="H2TLSWarmUpSize" id="H2TLSWarmUpSize">H2TLSWarmUpSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td /></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2TLSWarmUpSize <em>amount</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2TLSWarmUpSize 1048576</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.18 du serveur HTTP
	Apache.</td></tr>
</table>
            <p>
                Cette directive permet de dfinir le nombre d'octets  envoyer
		dans les petits enregistrements TLS (~1300 octets) avant
		d'atteindre leur taille maximale de 16 ko pour les connexions
		https: HTTP/2. Elle peut tre dfinie au niveau du serveur
		principal ou pour des <code class="directive"><a href="../mod/core.html#serveurs virtuels">&lt;Serveurs virtuels&gt;</a></code> spcifiques. 
            </p>
            <p>
                Les mesures effectues par les <a href="https://www.igvita.com">laboratoires de performances de
		Google</a> montrent que les meilleurs performances sont atteintes
		pour les connexions TLS si la taille initiale des
		enregistrements reste en dea du niveau du MTU afin de permettre
		 la totatlit d'un enregistrement d'entrer dans un paquet IP.
            </p>
            <p>
                Comme TCP ajuste son contrle de flux et sa taille de fentre,
		des enregistrements TLS trop longs peuvent rester en file
		d'attente ou mme tre perdus et devoir alors tre rmis. Ceci
		est bien entendu vrai pour tous les paquets ; cependant, TLS a
		besoin de la totalit de l'enregistrement pour pouvoir le
		dchiffrer. Tout octet manquant rendra impossible l'utilisation
		de ceux qui ont t reus.
            </p>
            <p>
                Lorqu'un nombre suffisant d'octets a t transmis avec succs,
		la connexion TCP est stable, et la taille maximale (16 ko) des
		enregistrements TLS peut tre utilise pour des performances
		optimales.
            </p>
            <p>
                Dans les architectures o les serveurs sont atteints par des
		machines locales ou pour les connexions de confiance seulement,
		la valeur de cette directive peut tre dfinie  0, ce qui a
		pour effet de dsactiver la "phase de chauffage".
            </p>
            <p>
                Dans l'exemple suivant, la phase de chauffage est effectivement
		dsactive en dfinissant la directive  0.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2TLSWarmUpSize 0</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2upgrade" id="h2upgrade">Directive</a> <a name="H2Upgrade" id="H2Upgrade">H2Upgrade</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Activation/Dsactivation du protocole de mise  jour H2</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2Upgrade on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2Upgrade on pour h2c, off pour h2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet d'activer/dsactiver l'utilisation de la
		mthode de mise  jour pour passer de HTTP/1.1  HTTP/2. Elle
		doit tre place dans une section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> afin d'activer la mise 
		jour vers HTTP/2 pour le serveur virtuel considr. 
            </p>
            <p>
                Cette mthode de changement de protocole est dfinie dans
		HTTP/1.1 et utilise l'en-tte "Upgrade" (d'o son nom) pour
		indiquer l'intention d'utiliser un autre protocole. Cet en-tte
		peut tre prsent dans toute requte sur une connexion HTTP/1.1.
            </p>
            <p>
                Elle active par dfaut pour les transmissions en clair
		(h2c), et dsactive avec TLS (h2), comme prconis par la RFC
		7540. 
            </p>
            <p>
                Sachez cependant que les mises  jour ne sont acceptes que pour
		les requtes qui ne possdent pas de corps. Le requtes de type
		POST et PUT avec un contenu ne feront jamais l'objet d'une mise
		 jour vers HTTP/2. Se rfrer  la documentation de la
		directive <code class="directive"><a href="#h2direct">H2Direct</a></code> pour
		envisager une alternative  Upgrade.
            </p>
            <p>
                Cette directive n'a d'effet que si h2 ou h2c est activ via la
		directive <code class="directive"><a href="../mod/core.html#protocols">Protocols</a></code>.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2Upgrade on</pre>
</div>
        
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="h2windowsize" id="h2windowsize">Directive</a> <a name="H2WindowSize" id="H2WindowSize">H2WindowSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille maximale des paquets de donnes pour les transmissions client
	vers serveur.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>H2WindowSize <em>bytes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>H2WindowSize 65535</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_http2</td></tr>
</table>
            <p>
                Cette directive permet de dfinir la taille maximale des paquets
		de donnes envoys par le client au serveur, et
		limite la quantit de donnes que le serveur doit mettre en
		tampon. Le client arrtera d'envoyer des donnes sur un flux
		lorsque cette limite sera atteinte jusqu' ce que le serveur
		indique qu'il dispose d'un espace suffisant (car il aura trait
		une partie des donnes).
            </p><p>
                Cette limite n'affecte que les corps de requtes, non les
		mtadonnes comme les en-ttes. Par contre, elle n'affecte pas
		les corps de rponses car la taille maximale de ces derniers est
		gre au niveau des clients.
            </p>
            <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">H2WindowSize 128000</pre>
</div>
        
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_http2.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_http2.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_http2.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>