# This file was automatically generated by bifcl from strings.bif.

##! Definitions of built-in functions related to string processing and
##! manipulation.


export {


## Calculates the Levenshtein distance between the two strings. See `Wikipedia
## <http://en.wikipedia.org/wiki/Levenshtein_distance>`__ for more information.
##
## s1: The first string.
##
## s2: The second string.
##
## Returns: The Levenshtein distance of two strings as a count.
##
global levenshtein_distance: function(s1: string , s2: string ): count ;


## Concatenates all arguments into a single string. The function takes a
## variable number of arguments of type string and stitches them together.
##
## Returns: The concatenation of all (string) arguments.
##
## .. bro:see:: cat cat_sep cat_string_array cat_string_array_n
##              fmt
##              join_string_vec join_string_array
global string_cat: function(va_args: any): string ;




## Concatenates all elements in an array of strings.
##
## a: The :bro:type:`string_array` (``table[count] of string``).
##
## Returns: The concatenation of all elements in *a*.
##
## .. bro:see:: cat cat_sep string_cat cat_string_array_n
##              fmt
##              join_string_vec join_string_array
global cat_string_array: function(a: string_array ): string &deprecated;


## Concatenates a specific range of elements in an array of strings.
##
## a: The :bro:type:`string_array` (``table[count] of string``).
##
## start: The array index of the first element of the range.
##
## end: The array index of the last element of the range.
##
## Returns: The concatenation of the range *[start, end]* in *a*.
##
## .. bro:see:: cat string_cat cat_string_array
##              fmt
##              join_string_vec join_string_array
global cat_string_array_n: function(a: string_array , start: count , end: count ): string &deprecated;


## Joins all values in the given array of strings with a separator placed
## between each element.
##
## sep: The separator to place between each element.
##
## a: The :bro:type:`string_array` (``table[count] of string``).
##
## Returns: The concatenation of all elements in *a*, with *sep* placed
##          between each element.
##
## .. bro:see:: cat cat_sep string_cat cat_string_array cat_string_array_n
##              fmt
##              join_string_vec
global join_string_array: function(sep: string , a: string_array ): string &deprecated;


## Joins all values in the given vector of strings with a separator placed
## between each element.
##
## sep: The separator to place between each element.
##
## vec: The :bro:type:`string_vec` (``vector of string``).
##
## Returns: The concatenation of all elements in *vec*, with *sep* placed
##          between each element.
##
## .. bro:see:: cat cat_sep string_cat cat_string_array cat_string_array_n
##              fmt
##              join_string_array
global join_string_vec: function(vec: string_vec , sep: string ): string ;


## Sorts an array of strings.
##
## a: The :bro:type:`string_array` (``table[count] of string``).
##
## Returns: A sorted copy of *a*.
##
## .. bro:see:: sort
global sort_string_array: function(a: string_array ): string_array &deprecated;


## Returns an edited version of a string that applies a special
## "backspace character" (usually ``\x08`` for backspace or ``\x7f`` for DEL).
## For example, ``edit("hello there", "e")`` returns ``"llo t"``.
##
## arg_s: The string to edit.
##
## arg_edit_char: A string of exactly one character that represents the
##                "backspace character". If it is longer than one character Bro
##                generates a run-time error and uses the first character in
##                the string.
##
## Returns: An edited version of *arg_s* where *arg_edit_char* triggers the
##          deletion of the last character.
##
## .. bro:see:: clean
##              to_string_literal
##              escape_string
##              strip
global edit: function(arg_s: string , arg_edit_char: string ): string ;


## Get a substring from a string, given a starting position and length.
##
## s: The string to obtain a substring from.
##
## start: The starting position of the substring in *s*, where 1 is the first
##        character. As a special case, 0 also represents the first character.
##
## n: The number of characters to extract, beginning at *start*.
##
## Returns: A substring of *s* of length *n* from position *start*.
global sub_bytes: function(s: string , start: count , n: int ): string ;




## Splits a string into an array of strings according to a pattern.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## Returns: An array of strings where each element corresponds to a substring
##          in *str* separated by *re*.
##
## .. bro:see:: split1 split_all split_n str_split split_string1 split_string_all split_string_n str_split
##
## .. note:: The returned table starts at index 1. Note that conceptually the
##           return value is meant to be a vector and this might change in the
##           future.
##
global split: function(str: string , re: pattern ): string_array &deprecated;


## Splits a string into an array of strings according to a pattern.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## Returns: An array of strings where each element corresponds to a substring
##          in *str* separated by *re*.
##
## .. bro:see:: split_string1 split_string_all split_string_n str_split
##
global split_string: function(str: string , re: pattern ): string_vec ;


## Splits a string *once* into a two-element array of strings according to a
## pattern. This function is the same as :bro:id:`split`, but *str* is only
## split once (if possible) at the earliest position and an array of two strings
## is returned.
##
## str: The string to split.
##
## re: The pattern describing the separator to split *str* in two pieces.
##
## Returns: An array of strings with two elements in which the first represents
##          the substring in *str* up to the first occurence of *re*, and the
##          second everything after *re*. An array of one string is returned
##          when *s* cannot be split.
##
## .. bro:see:: split split_all split_n str_split split_string split_string_all split_string_n str_split
global split1: function(str: string , re: pattern ): string_array &deprecated;


## Splits a string *once* into a two-element array of strings according to a
## pattern. This function is the same as :bro:id:`split_string`, but *str* is
## only split once (if possible) at the earliest position and an array of two
## strings is returned.
##
## str: The string to split.
##
## re: The pattern describing the separator to split *str* in two pieces.
##
## Returns: An array of strings with two elements in which the first represents
##          the substring in *str* up to the first occurence of *re*, and the
##          second everything after *re*. An array of one string is returned
##          when *s* cannot be split.
##
## .. bro:see:: split_string split_string_all split_string_n str_split
global split_string1: function(str: string , re: pattern ): string_vec ;


## Splits a string into an array of strings according to a pattern. This
## function is the same as :bro:id:`split`, except that the separators are
## returned as well. For example, ``split_all("a-b--cd", /(\-)+/)`` returns
## ``{"a", "-", "b", "--", "cd"}``: odd-indexed elements do not match the
## pattern and even-indexed ones do.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## Returns: An array of strings where each two successive elements correspond
##          to a substring in *str* of the part not matching *re* (odd-indexed)
##          and the part that matches *re* (even-indexed).
##
## .. bro:see:: split split1 split_n str_split split_string split_string1 split_string_n str_split
global split_all: function(str: string , re: pattern ): string_array &deprecated;


## Splits a string into an array of strings according to a pattern. This
## function is the same as :bro:id:`split_string`, except that the separators
## are returned as well. For example, ``split_string_all("a-b--cd", /(\-)+/)``
## returns ``{"a", "-", "b", "--", "cd"}``: odd-indexed elements do match the
## pattern and even-indexed ones do not.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## Returns: An array of strings where each two successive elements correspond
##          to a substring in *str* of the part not matching *re* (even-indexed)
##          and the part that matches *re* (odd-indexed).
##
## .. bro:see:: split_string split_string1 split_string_n str_split
global split_string_all: function(str: string , re: pattern ): string_vec ;


## Splits a string a given number of times into an array of strings according
## to a pattern. This function is similar to :bro:id:`split1` and
## :bro:id:`split_all`, but with customizable behavior with respect to
## including separators in the result and the number of times to split.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## incl_sep: A flag indicating whether to include the separator matches in the
##           result (as in :bro:id:`split_all`).
##
## max_num_sep: The number of times to split *str*.
##
## Returns: An array of strings where, if *incl_sep* is true, each two
##          successive elements correspond to a substring in *str* of the part
##          not matching *re* (odd-indexed) and the part that matches *re*
##          (even-indexed).
##
## .. bro:see:: split split1 split_all str_split split_string split_string1 split_string_all str_split
global split_n: function(str: string , re: pattern , incl_sep: bool , max_num_sep: count ): string_array &deprecated;


## Splits a string a given number of times into an array of strings according
## to a pattern. This function is similar to :bro:id:`split_string1` and
## :bro:id:`split_string_all`, but with customizable behavior with respect to
## including separators in the result and the number of times to split.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## incl_sep: A flag indicating whether to include the separator matches in the
##           result (as in :bro:id:`split_string_all`).
##
## max_num_sep: The number of times to split *str*.
##
## Returns: An array of strings where, if *incl_sep* is true, each two
##          successive elements correspond to a substring in *str* of the part
##          not matching *re* (even-indexed) and the part that matches *re*
##          (odd-indexed).
##
## .. bro:see:: split_string split_string1 split_string_all str_split
global split_string_n: function(str: string , re: pattern , incl_sep: bool , max_num_sep: count ): string_vec ;


## Substitutes a given replacement string for the first occurrence of a pattern
## in a given string.
##
## str: The string to perform the substitution in.
##
## re: The pattern being replaced with *repl*.
##
## repl: The string that replaces *re*.
##
## Returns: A copy of *str* with the first occurence of *re* replaced with
##          *repl*.
##
## .. bro:see:: gsub subst_string
global sub: function(str: string , re: pattern , repl: string ): string ;


## Substitutes a given replacement string for all occurrences of a pattern
## in a given string.
##
## str: The string to perform the substitution in.
##
## re: The pattern being replaced with *repl*.
##
## repl: The string that replaces *re*.
##
## Returns: A copy of *str* with all occurrences of *re* replaced with *repl*.
##
## .. bro:see:: sub subst_string
global gsub: function(str: string , re: pattern , repl: string ): string ;



## Lexicographically compares two strings.
##
## s1: The first string.
##
## s2: The second string.
##
## Returns: An integer greater than, equal to, or less than 0 according as
##          *s1* is greater than, equal to, or less than *s2*.
global strcmp: function(s1: string , s2: string ): int ;


## Locates the first occurrence of one string in another.
##
## big: The string to look in.
##
## little: The (smaller) string to find inside *big*.
##
## Returns: The location of *little* in *big*, or 0 if *little* is not found in
##          *big*.
##
## .. bro:see:: find_all find_last
global strstr: function(big: string , little: string ): count ;


## Substitutes each (non-overlapping) appearance of a string in another.
##
## s: The string in which to perform the substitution.
##
## from: The string to look for which is replaced with *to*.
##
## to: The string that replaces all occurrences of *from* in *s*.
##
## Returns: A copy of *s* where each occurrence of *from* is replaced with *to*.
##
## .. bro:see:: sub gsub
global subst_string: function(s: string , from: string , to: string ): string ;


## Replaces all uppercase letters in a string with their lowercase counterpart.
##
## str: The string to convert to lowercase letters.
##
## Returns: A copy of the given string with the uppercase letters (as indicated
##          by ``isascii`` and ``isupper``) folded to lowercase
##          (via ``tolower``).
##
## .. bro:see:: to_upper is_ascii
global to_lower: function(str: string ): string ;


## Replaces all lowercase letters in a string with their uppercase counterpart.
##
## str: The string to convert to uppercase letters.
##
## Returns: A copy of the given string with the lowercase letters (as indicated
##          by ``isascii`` and ``islower``) folded to uppercase
##          (via ``toupper``).
##
## .. bro:see:: to_lower is_ascii
global to_upper: function(str: string ): string ;


## Replaces non-printable characters in a string with escaped sequences. The
## mappings are:
##
##     - values not in *[32, 126]* to ``\xXX``
##
## If the string does not yet have a trailing NUL, one is added internally.
##
## In contrast to :bro:id:`escape_string`, this encoding is *not* fully reversible.` 
##
## str: The string to escape.
##
## Returns: The escaped string.
##
## .. bro:see:: to_string_literal escape_string
global clean: function(str: string ): string ;


## Replaces non-printable characters in a string with escaped sequences. The
## mappings are:
##
##     - values not in *[32, 126]* to ``\xXX``
##     - ``\`` to ``\\``
##     - ``'`` and ``""`` to ``\'`` and ``\"``, respectively.
##
## str: The string to escape.
##
## Returns: The escaped string.
##
## .. bro:see:: clean escape_string
global to_string_literal: function(str: string ): string ;


## Determines whether a given string contains only ASCII characters.
##
## str: The string to examine.
##
## Returns: False if any byte value of *str* is greater than 127, and true
##          otherwise.
##
## .. bro:see:: to_upper to_lower
global is_ascii: function(str: string ): bool ;


## Replaces non-printable characters in a string with escaped sequences. The
## mappings are:
##
##     - values not in *[32, 126]* to ``\xXX``
##     - ``\`` to ``\\``
##
## In contrast to :bro:id:`clean`, this encoding is fully reversible.` 
##
## str: The string to escape.
##
## Returns: The escaped string.
##
## .. bro:see:: clean to_string_literal
global escape_string: function(s: string ): string ;


## Returns an ASCII hexadecimal representation of a string.
##
## s: The string to convert to hex.
##
## Returns: A copy of *s* where each byte is replaced with the corresponding
##          hex nibble.
global string_to_ascii_hex: function(s: string ): string ;


## Uses the Smith-Waterman algorithm to find similar/overlapping substrings.
## See `Wikipedia <http://en.wikipedia.org/wiki/Smith%E2%80%93Waterman_algorithm>`__.
##
## s1: The first string.
##
## s2: The second string.
##
## params: Parameters for the Smith-Waterman algorithm.
##
## Returns: The result of the Smith-Waterman algorithm calculation.
global str_smith_waterman: function(s1: string , s2: string , params: sw_params ) : sw_substring_vec ;


## Splits a string into substrings with the help of an index vector of cutting
## points.
##
## s: The string to split.
##
## idx: The index vector (``vector of count``) with the cutting points.
##
## Returns: A vector of strings.
##
## .. bro:see:: split split1 split_all split_n
global str_split: function(s: string , idx: index_vec ): string_vec ;


## Strips whitespace at both ends of a string.
##
## str: The string to strip the whitespace from.
##
## Returns: A copy of *str* with leading and trailing whitespace removed.
##
## .. bro:see:: sub gsub
global strip: function(str: string ): string ;


## Generates a string of a given size and fills it with repetitions of a source
## string.
##
## len: The length of the output string.
##
## source: The string to concatenate repeatedly until *len* has been reached.
##
## Returns: A string of length *len* filled with *source*.
global string_fill: function(len: int , source: string ): string ;


## Takes a string and escapes characters that would allow execution of
## commands at the shell level. Must be used before including strings in
## :bro:id:`system` or similar calls.
##
## source: The string to escape.
##
## Returns: A shell-escaped version of *source*.
##
## .. bro:see:: system
global str_shell_escape: function(source: string ): string ;


## Finds all occurrences of a pattern in a string.
##
## str: The string to inspect.
##
## re: The pattern to look for in *str*.
##
## Returns: The set of strings in *str* that match *re*, or the empty set.
##
## .. bro:see: find_last strstr
global find_all: function(str: string , re: pattern ) : string_set ;


## Finds the last occurrence of a pattern in a string. This function returns
## the match that starts at the largest index in the string, which is not
## necessarily the longest match.  For example, a pattern of ``/.*/`` will
## return the final character in the string.
##
## str: The string to inspect.
##
## re: The pattern to look for in *str*.
##
## Returns: The last string in *str* that matches *re*, or the empty string.
##
## .. bro:see: find_all strstr
global find_last: function(str: string , re: pattern ) : string ;


## Returns a hex dump for given input data. The hex dump renders 16 bytes per
## line, with hex on the left and ASCII (where printable)
## on the right.
##
## data_str: The string to dump in hex format.
##
## Returns: The hex dump of the given string.
##
## .. bro:see:: string_to_ascii_hex bytestring_to_hexstr
##
## .. note:: Based on Netdude's hex editor code.
##
global hexdump: function(data_str: string ) : string ;


## Returns a reversed copy of the string
##
## str: The string to reverse.
##
## Returns: A reversed copy of *str*
##
global reverse: function(str: string ) : string ;

} # end of export section
module GLOBAL;
