/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.javax.management.Translator;
import java.lang.management.ManagementPermission;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class BeanImpl
extends StandardMBean {
    private OpenMBeanInfo openInfo;

    protected BeanImpl(Class iface) throws NotCompliantMBeanException {
        super(iface);
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        if (info == null) {
            return;
        }
        try {
            MBeanAttributeInfo[] oldA = info.getAttributes();
            OpenMBeanAttributeInfo[] attribs = new OpenMBeanAttributeInfoSupport[oldA.length];
            int a = 0;
            while (a < oldA.length) {
                OpenMBeanParameterInfo param = Translator.translate(oldA[a].getType());
                if (param.getMinValue() == null) {
                    Object[] lv = param.getLegalValues() == null ? (Object[])null : param.getLegalValues().toArray();
                    attribs[a] = new OpenMBeanAttributeInfoSupport(oldA[a].getName(), oldA[a].getDescription(), param.getOpenType(), oldA[a].isReadable(), oldA[a].isWritable(), oldA[a].isIs(), param.getDefaultValue(), lv);
                } else {
                    attribs[a] = new OpenMBeanAttributeInfoSupport(oldA[a].getName(), oldA[a].getDescription(), param.getOpenType(), oldA[a].isReadable(), oldA[a].isWritable(), oldA[a].isIs(), param.getDefaultValue(), param.getMinValue(), param.getMaxValue());
                }
                ++a;
            }
            MBeanConstructorInfo[] oldC = info.getConstructors();
            OpenMBeanConstructorInfo[] cons = new OpenMBeanConstructorInfoSupport[oldC.length];
            int a2 = 0;
            while (a2 < oldC.length) {
                cons[a2] = new OpenMBeanConstructorInfoSupport(oldC[a2].getName(), oldC[a2].getDescription(), this.translateSignature(oldC[a2].getSignature()));
                ++a2;
            }
            MBeanOperationInfo[] oldO = info.getOperations();
            OpenMBeanOperationInfo[] ops = new OpenMBeanOperationInfoSupport[oldO.length];
            int a3 = 0;
            while (a3 < oldO.length) {
                ops[a3] = new OpenMBeanOperationInfoSupport(oldO[a3].getName(), oldO[a3].getDescription(), this.translateSignature(oldO[a3].getSignature()), Translator.translate(oldO[a3].getReturnType()).getOpenType(), oldO[a3].getImpact());
                ++a3;
            }
            this.openInfo = new OpenMBeanInfoSupport(info.getClassName(), info.getDescription(), attribs, cons, ops, info.getNotifications());
        }
        catch (OpenDataException e) {
            throw (InternalError)new InternalError("A problem occurred creating the open type descriptors.").initCause(e);
        }
    }

    protected void checkMonitorPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ManagementPermission("monitor"));
        }
    }

    protected void checkControlPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ManagementPermission("control"));
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object value = super.getAttribute(attribute);
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        Class<Object> vClass = value.getClass();
        if (vClass.isArray()) {
            vClass = vClass.getComponentType();
        }
        String cName = vClass.getName();
        String[] allowedTypes = OpenType.ALLOWED_CLASSNAMES;
        int a = 0;
        while (a < allowedTypes.length) {
            if (cName.equals(allowedTypes[a])) {
                return value;
            }
            ++a;
        }
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)this.getMBeanInfo());
        MBeanAttributeInfo[] attribs = info.getAttributes();
        OpenType<?> type = null;
        int a2 = 0;
        while (a2 < attribs.length) {
            if (attribs[a2].getName().equals(attribute)) {
                type = ((OpenMBeanAttributeInfo)((Object)attribs[a2])).getOpenType();
            }
            ++a2;
        }
        if (value instanceof List) {
            try {
                Class<?> e = Class.forName(((ArrayType)type).getElementOpenType().getClassName());
                List l = (List)value;
                Object[] array = (Object[])Array.newInstance(e, l.size());
                return l.toArray(array);
            }
            catch (ClassNotFoundException e) {
                throw (InternalError)new InternalError("The class of the list element type could not be created").initCause(e);
            }
        }
        if (value instanceof Map) {
            TabularType ttype = (TabularType)type;
            TabularDataSupport data = new TabularDataSupport(ttype);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                try {
                    data.put(new CompositeDataSupport(ttype.getRowType(), new String[]{"key", "value"}, new Object[]{entry.getKey(), entry.getValue()}));
                }
                catch (OpenDataException e) {
                    throw (InternalError)new InternalError("A problem occurred converting the map to a composite data structure.").initCause(e);
                }
            }
            return data;
        }
        CompositeType cType = (CompositeType)type;
        Set<String> names = cType.keySet();
        Iterator<String> it = names.iterator();
        ArrayList<Object> values = new ArrayList<Object>(names.size());
        while (it.hasNext()) {
            String field = it.next();
            Method getter = null;
            try {
                getter = vClass.getMethod("get" + field, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                values.add(getter.invoke(value, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e, "Failed to retrieve " + field);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e, "Failed to retrieve " + field);
            }
            catch (InvocationTargetException e) {
                throw new MBeanException((Exception)e.getCause(), "The getter of " + field + " threw an exception");
            }
        }
        try {
            return new CompositeDataSupport(cType, names.toArray(new String[names.size()]), values.toArray());
        }
        catch (OpenDataException e) {
            throw (InternalError)new InternalError("A problem occurred converting the value to a composite data structure.").initCause(e);
        }
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return (MBeanInfo)((Object)this.openInfo);
    }

    protected String getDescription(MBeanConstructorInfo constructor, MBeanParameterInfo parameter, int sequenceNo) {
        String desc = parameter.getDescription();
        if (desc == null) {
            return "param" + sequenceNo;
        }
        return desc;
    }

    protected String getDescription(MBeanOperationInfo operation, MBeanParameterInfo parameter, int sequenceNo) {
        String desc = parameter.getDescription();
        if (desc == null) {
            return "param" + sequenceNo;
        }
        return desc;
    }

    protected String getParameterName(MBeanConstructorInfo constructor, MBeanParameterInfo parameter, int sequenceNo) {
        String name = parameter.getName();
        if (name == null) {
            return "param" + sequenceNo;
        }
        return name;
    }

    protected String getParameterName(MBeanOperationInfo operation, MBeanParameterInfo parameter, int sequenceNo) {
        String name = parameter.getName();
        if (name == null) {
            return "param" + sequenceNo;
        }
        return name;
    }

    public MBeanInfo getMBeanInfo() {
        super.getMBeanInfo();
        return this.getCachedMBeanInfo();
    }

    private OpenMBeanParameterInfo[] translateSignature(MBeanParameterInfo[] oldS) throws OpenDataException {
        OpenMBeanParameterInfo[] sig = new OpenMBeanParameterInfoSupport[oldS.length];
        int a = 0;
        while (a < oldS.length) {
            OpenMBeanParameterInfo param = Translator.translate(oldS[a].getType());
            if (param.getMinValue() == null) {
                Object[] lv = param.getLegalValues() == null ? (Object[])null : param.getLegalValues().toArray();
                sig[a] = new OpenMBeanParameterInfoSupport(oldS[a].getName(), oldS[a].getDescription(), param.getOpenType(), param.getDefaultValue(), lv);
            } else {
                sig[a] = new OpenMBeanParameterInfoSupport(oldS[a].getName(), oldS[a].getDescription(), param.getOpenType(), param.getDefaultValue(), param.getMinValue(), param.getMaxValue());
            }
            ++a;
        }
        return sig;
    }
}

