/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.AbstractHandshake;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateBuilder;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateRequestBuilder;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CipherSuiteList;
import gnu.javax.net.ssl.provider.ClientDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.ClientPSKParameters;
import gnu.javax.net.ssl.provider.ClientRSA_PSKParameters;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.CompressionMethodList;
import gnu.javax.net.ssl.provider.DelegatedTask;
import gnu.javax.net.ssl.provider.DiffieHellman;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.ServerDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerHelloBuilder;
import gnu.javax.net.ssl.provider.ServerKeyExchangeBuilder;
import gnu.javax.net.ssl.provider.ServerNameList;
import gnu.javax.net.ssl.provider.ServerPSKParameters;
import gnu.javax.net.ssl.provider.ServerRSA_PSKParameters;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.Util;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

class ServerHandshake
extends AbstractHandshake {
    private State state;
    private ByteBuffer outBuffer;
    private boolean clientHadExtensions = false;
    private boolean continuedSession = false;
    private ServerNameList requestedNames = null;
    private String keyAlias = null;
    private X509Certificate clientCert = null;
    private X509Certificate localCert = null;
    private boolean helloV2 = false;
    private KeyPair dhPair;
    private PrivateKey serverKey;
    private GenDH genDH;
    private AbstractHandshake.CertVerifier certVerifier;
    private CertLoader certLoader;
    private DelegatedTask keyExchangeTask;
    private static /* synthetic */ int[] $SWITCH_TABLE$gnu$javax$net$ssl$provider$Extension$Type;
    private static /* synthetic */ int[] $SWITCH_TABLE$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm;
    private static /* synthetic */ int[] $SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State;

    ServerHandshake(boolean writeHelloRequest, SSLEngineImpl engine) throws NoSuchAlgorithmException {
        super(engine);
        this.state = writeHelloRequest ? State.WRITE_HELLO_REQUEST : State.READ_CLIENT_HELLO;
        this.handshakeOffset = 0;
    }

    private static ProtocolVersion chooseProtocol(ProtocolVersion clientVersion, String[] enabledVersions) throws SSLException {
        ProtocolVersion version = null;
        int i = 0;
        while (i < enabledVersions.length) {
            ProtocolVersion v = ProtocolVersion.forName(enabledVersions[i]);
            if (v.compareTo(clientVersion) <= 0 && (version == null || v.compareTo(version) > 0)) {
                version = v;
            }
            ++i;
        }
        if (version == null) {
            throw new SSLException("no acceptable protocol version available");
        }
        return version;
    }

    private CipherSuite chooseSuite(CipherSuiteList clientSuites, String[] enabledSuites, ProtocolVersion version) throws SSLException {
        HashSet<KeyExchangeAlgorithm> kexes = new HashSet<KeyExchangeAlgorithm>(8);
        kexes.add(KeyExchangeAlgorithm.NONE);
        X509ExtendedKeyManager km = this.engine.contextImpl.keyManager;
        if (km != null) {
            if (km.getServerAliases(KeyExchangeAlgorithm.DH_DSS.name(), null).length > 0) {
                kexes.add(KeyExchangeAlgorithm.DH_DSS);
            }
            if (km.getServerAliases(KeyExchangeAlgorithm.DH_RSA.name(), null).length > 0) {
                kexes.add(KeyExchangeAlgorithm.DH_RSA);
            }
            if (km.getServerAliases(KeyExchangeAlgorithm.DHE_DSS.name(), null).length > 0) {
                kexes.add(KeyExchangeAlgorithm.DHE_DSS);
            }
            if (km.getServerAliases(KeyExchangeAlgorithm.DHE_RSA.name(), null).length > 0) {
                kexes.add(KeyExchangeAlgorithm.DHE_RSA);
            }
            if (km.getServerAliases(KeyExchangeAlgorithm.RSA.name(), null).length > 0) {
                kexes.add(KeyExchangeAlgorithm.RSA);
            }
            if (km.getServerAliases(KeyExchangeAlgorithm.RSA_PSK.name(), null).length > 0 && this.engine.contextImpl.pskManager != null) {
                kexes.add(KeyExchangeAlgorithm.RSA_PSK);
            }
        }
        if (this.engine.contextImpl.pskManager != null) {
            kexes.add(KeyExchangeAlgorithm.DHE_PSK);
            kexes.add(KeyExchangeAlgorithm.PSK);
        }
        logger.logv(Component.SSL_HANDSHAKE, "we have certs for key exchange algorithms {0}", kexes);
        HashSet<CipherSuite> suites = new HashSet<CipherSuite>();
        String[] stringArray = enabledSuites;
        int n = enabledSuites.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            CipherSuite suite = CipherSuite.forName(s);
            if (suite != null && kexes.contains((Object)suite.keyExchangeAlgorithm())) {
                suites.add(suite);
            }
            ++n2;
        }
        for (CipherSuite suite : clientSuites) {
            CipherSuite resolved = suite.resolve();
            if (!resolved.isResolved() || !suites.contains(resolved)) continue;
            return resolved;
        }
        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INSUFFICIENT_SECURITY));
    }

    private static CompressionMethod chooseCompression(CompressionMethodList comps) throws SSLException {
        GetSecurityPropertyAction gspa = new GetSecurityPropertyAction("jessie.enable.compression");
        String enable = AccessController.doPrivileged(gspa);
        if (Boolean.valueOf(enable).booleanValue()) {
            for (CompressionMethod cm : comps) {
                if (!cm.equals((Object)CompressionMethod.ZLIB)) continue;
                return CompressionMethod.ZLIB;
            }
        }
        for (CompressionMethod cm : comps) {
            if (!cm.equals((Object)CompressionMethod.NULL)) continue;
            return CompressionMethod.NULL;
        }
        throw new SSLException("no supported compression method");
    }

    protected boolean doHash() {
        boolean b = this.helloV2;
        this.helloV2 = false;
        return this.state != State.WRITE_HELLO_REQUEST && !b;
    }

    /*
     * Unable to fully structure code
     */
    public SSLEngineResult.HandshakeStatus implHandleInput() throws SSLException {
        if (this.state == State.DONE) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        buffer = this.handshakeBuffer.duplicate();
        buffer.flip();
        buffer.position(this.handshakeOffset);
        handshake = new Handshake(buffer.slice(), this.engine.session().suite, this.engine.session().version);
        ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "processing in state {0}:\n{1}", new Object[]{this.state, handshake});
        switch (ServerHandshake.$SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State()[this.state.ordinal()]) {
            case 8: {
                if (handshake.type() != Handshake.Type.CLIENT_HELLO) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                hello = (ClientHello)handshake.body();
                this.engine.session().version = ServerHandshake.chooseProtocol(hello.version(), this.engine.getEnabledProtocols());
                this.engine.session().suite = this.chooseSuite(hello.cipherSuites(), this.engine.getEnabledCipherSuites(), this.engine.session().version);
                this.compression = ServerHandshake.chooseCompression(hello.compressionMethods());
                ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "chose version:{0} suite:{1} compression:{2}", new Object[]{this.engine.session().version, this.engine.session().suite, this.compression});
                this.clientRandom = hello.random().copy();
                sessionId = hello.sessionId();
                if (hello.hasExtensions()) {
                    exts = hello.extensions();
                    this.clientHadExtensions = exts.size() > 0;
                    for (Extension e : hello.extensions()) {
                        type = e.type();
                        if (type == null) continue;
                        switch (ServerHandshake.$SWITCH_TABLE$gnu$javax$net$ssl$provider$Extension$Type()[type.ordinal()]) {
                            case 5: {
                                this.engine.session().setTruncatedMac(true);
                                break;
                            }
                            case 2: {
                                this.engine.session().maxLength = len = (MaxFragmentLength)e.value();
                                this.engine.session().setApplicationBufferSize(len.maxLength());
                                break;
                            }
                            case 1: {
                                this.requestedNames = (ServerNameList)e.value();
                                names = new ArrayList<String>(this.requestedNames.size());
                                for (ServerNameList.ServerName name : this.requestedNames) {
                                    names.add(name.name());
                                }
                                this.engine.session().putValue("gnu.javax.net.ssl.RequestedServerNames", names);
                                break;
                            }
                            default: {
                                ServerHandshake.logger.log(Level.INFO, "skipping unsupported extension {0}", e);
                            }
                        }
                    }
                }
                sessions = (AbstractSessionContext)this.engine.contextImpl.engineGetServerSessionContext();
                s = sessions.getSession(sessionId);
                ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "looked up saved session {0}", new Object[]{s});
                if (s != null && s.isValid() && s instanceof SessionImpl) {
                    this.engine.setSession((SessionImpl)s);
                    this.continuedSession = true;
                } else {
                    if (this.engine.session().id().equals(new Session.ID(sessionId))) {
                        newId = new byte[32];
                        this.engine.session().random().nextBytes(newId);
                        this.engine.session().setId(new Session.ID(newId));
                    }
                    sessions.put(this.engine.session());
                }
                this.state = State.WRITE_SERVER_HELLO;
                break;
            }
            case 9: {
                if (handshake.type() != Handshake.Type.CERTIFICATE) {
                    if (this.engine.getNeedClientAuth()) {
                        throw new SSLException("client auth required");
                    }
                    this.state = State.READ_CLIENT_KEY_EXCHANGE;
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                cert = (Certificate)handshake.body();
                try {
                    this.engine.session().setPeerVerified(false);
                    chain = cert.certificates().toArray(new X509Certificate[0]);
                    if (chain.length == 0) {
                        throw new CertificateException("no certificates in chain");
                    }
                    this.certVerifier = new AbstractHandshake.CertVerifier(this, false, (X509Certificate[])chain);
                    this.tasks.add(this.certVerifier);
                    this.engine.session().setPeerCertificates(chain);
                    this.clientCert = chain[0];
                }
                catch (CertificateException ce) {
                    if (this.engine.getNeedClientAuth()) {
                        x = new SSLPeerUnverifiedException("client certificates could not be verified");
                        x.initCause(ce);
                        throw x;
                    }
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new SSLException(nsae);
                }
                this.state = State.READ_CLIENT_KEY_EXCHANGE;
                break;
            }
            case 10: {
                if (handshake.type() != Handshake.Type.CLIENT_KEY_EXCHANGE) {
                    throw new SSLException("expecting client key exchange");
                }
                kex = (ClientKeyExchange)handshake.body();
                alg = this.engine.session().suite.keyExchangeAlgorithm();
                switch (ServerHandshake.$SWITCH_TABLE$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm()[alg.ordinal()]) {
                    case 5: 
                    case 6: 
                    case 7: {
                        pub = (ClientDiffieHellmanPublic)kex.exchangeKeys();
                        myKey = (DHPublicKey)this.dhPair.getPublic();
                        clientKey = new GnuDHPublicKey(null, myKey.getParams().getP(), myKey.getParams().getG(), pub.publicValue());
                        this.keyExchangeTask = new AbstractHandshake.DHPhase(this, clientKey);
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 2: {
                        secret = (EncryptedPreMasterSecret)kex.exchangeKeys();
                        this.keyExchangeTask = new RSAKeyExchange(secret.encryptedSecret());
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 8: {
                        params = (ClientPSKParameters)kex.exchangeKeys();
                        this.generatePSKSecret(params.identity(), null, false);
                        break;
                    }
                    case 9: {
                        params = (ClientDHE_PSKParameters)kex.exchangeKeys();
                        serverKey = (DHPublicKey)this.dhPair.getPublic();
                        clientKey = new GnuDHPublicKey(null, serverKey.getParams().getP(), serverKey.getParams().getG(), params.params().publicValue());
                        psk = null;
                        try {
                            psk = this.engine.contextImpl.pskManager.getKey(params.identity());
                        }
                        catch (KeyManagementException v0) {}
                        this.keyExchangeTask = new AbstractHandshake.DHE_PSKGen(this, clientKey, psk, false);
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 10: {
                        params = (ClientRSA_PSKParameters)kex.exchangeKeys();
                        psk = null;
                        try {
                            psk = this.engine.contextImpl.pskManager.getKey(params.identity());
                        }
                        catch (KeyManagementException v1) {}
                        if (psk == null) {
                            fakeKey = new byte[16];
                            this.engine.session().random().nextBytes(fakeKey);
                            psk = new SecretKeySpec(fakeKey, "DHE_PSK");
                        }
                        this.keyExchangeTask = new RSA_PSKExchange(params.secret().encryptedSecret(), psk);
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 1: {
                        inflater = null;
                        deflater = null;
                        if (this.compression == CompressionMethod.ZLIB) {
                            inflater = new Inflater();
                            deflater = new Deflater();
                        }
                        this.inParams = new InputSecurityParameters(null, null, inflater, this.engine.session(), this.engine.session().suite);
                        this.outParams = new OutputSecurityParameters(null, null, deflater, this.engine.session(), this.engine.session().suite);
                        this.engine.session().privateData.masterSecret = new byte[0];
                    }
                }
                if (this.clientCert != null) {
                    this.state = State.READ_CERTIFICATE_VERIFY;
                    break;
                }
                this.state = State.READ_FINISHED;
                break;
            }
            case 11: {
                if (handshake.type() != Handshake.Type.CERTIFICATE_VERIFY) {
                    throw new SSLException("expecting certificate verify message");
                }
                verify = (CertificateVerify)handshake.body();
                try {
                    this.verifyClient(verify.signature());
                    if (this.certVerifier != null && this.certVerifier.verified()) {
                        this.engine.session().setPeerVerified(true);
                    }
                }
                catch (SignatureException se) {
                    if (!this.engine.getNeedClientAuth()) ** GOTO lbl170
                    throw new SSLException("client auth failed", se);
                }
lbl170:
                // 2 sources

                if (this.continuedSession) {
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break;
                }
                this.state = State.READ_FINISHED;
                break;
            }
            case 12: {
                if (handshake.type() != Handshake.Type.FINISHED) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                clientFinished = (Finished)handshake.body();
                md5copy = null;
                shacopy = null;
                try {
                    md5copy = (MessageDigest)this.md5.clone();
                    shacopy = (MessageDigest)this.sha.clone();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new SSLException(cnse);
                }
                serverFinished = new Finished(this.generateFinished(md5copy, shacopy, true, this.engine.session()), this.engine.session().version);
                ServerHandshake.logger.log((Level)Component.SSL_HANDSHAKE, "server finished: {0}", serverFinished);
                if (this.engine.session().version == ProtocolVersion.SSL_3) {
                    if (!Arrays.equals(clientFinished.md5Hash(), serverFinished.md5Hash()) || !Arrays.equals(clientFinished.shaHash(), serverFinished.shaHash())) {
                        this.engine.session().invalidate();
                        throw new SSLException("session verify failed");
                    }
                } else if (!Arrays.equals(clientFinished.verifyData(), serverFinished.verifyData())) {
                    this.engine.session().invalidate();
                    throw new SSLException("session verify failed");
                }
                if (this.continuedSession) {
                    this.state = State.DONE;
                    break;
                }
                this.engine.changeCipherSpec();
                this.state = State.WRITE_FINISHED;
            }
        }
        this.handshakeOffset += handshake.length() + 4;
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.state.isWriteState()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    /*
     * Unable to fully structure code
     */
    public SSLEngineResult.HandshakeStatus implHandleOutput(ByteBuffer fragment) throws SSLException {
        ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "handle output state: {0}; output fragment: {1}", new Object[]{this.state, fragment});
        if (this.outBuffer != null && this.outBuffer.hasRemaining()) {
            l = Math.min(fragment.remaining(), this.outBuffer.remaining());
            fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
            this.outBuffer.position(this.outBuffer.position() + l);
        }
        if (fragment.hasRemaining()) ** GOTO lbl-1000
        if (this.state.isWriteState() || this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        {
            switch (ServerHandshake.$SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State()[this.state.ordinal()]) {
                case 1: {
                    handshake = new Handshake(fragment);
                    handshake.setType(Handshake.Type.HELLO_REQUEST);
                    handshake.setLength(0);
                    fragment.position(fragment.position() + 4);
                    ServerHandshake.logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    this.state = State.READ_CLIENT_HELLO;
                    break block13;
                }
                case 2: {
                    hello = new ServerHelloBuilder();
                    hello.setVersion(this.engine.session().version);
                    r = hello.random();
                    r.setGmtUnixTime(Util.unixTime());
                    nonce = new byte[28];
                    this.engine.session().random().nextBytes(nonce);
                    r.setRandomBytes(nonce);
                    this.serverRandom = r.copy();
                    hello.setSessionId(this.engine.session().getId());
                    hello.setCipherSuite(this.engine.session().suite);
                    hello.setCompressionMethod(this.compression);
                    if (!this.clientHadExtensions) {
                        hello.setDisableExtensions(true);
                    }
                    ServerHandshake.logger.log((Level)Component.SSL_HANDSHAKE, "{0}", hello);
                    typeLen = Handshake.Type.SERVER_HELLO.getValue() << 24 | hello.length() & 0xFFFFFF;
                    fragment.putInt(typeLen);
                    this.outBuffer = hello.buffer();
                    l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    cs = this.engine.session().suite;
                    kex = cs.keyExchangeAlgorithm();
                    if (this.continuedSession) {
                        keys = this.generateKeys(this.clientRandom, this.serverRandom, this.engine.session());
                        this.setupSecurityParameters(keys, false, this.engine, this.compression);
                        this.engine.changeCipherSpec();
                        this.state = State.WRITE_FINISHED;
                    } else {
                        if (kex == KeyExchangeAlgorithm.DHE_DSS || kex == KeyExchangeAlgorithm.DHE_RSA || kex == KeyExchangeAlgorithm.RSA || kex == KeyExchangeAlgorithm.RSA_PSK) {
                            this.certLoader = new CertLoader();
                            this.tasks.add(this.certLoader);
                            this.state = State.WRITE_CERTIFICATE;
                            if (kex != KeyExchangeAlgorithm.DHE_DSS && kex != KeyExchangeAlgorithm.DHE_RSA) break block13;
                            this.genDH = new GenDH();
                            this.tasks.add(this.genDH);
                            break block13;
                        }
                        if (kex == KeyExchangeAlgorithm.PSK) {
                            this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        } else {
                            if (kex == KeyExchangeAlgorithm.DHE_PSK || kex == KeyExchangeAlgorithm.DH_anon) {
                                this.genDH = new GenDH();
                                this.tasks.add(this.genDH);
                                this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                                break block13;
                            }
                            this.state = this.engine.getWantClientAuth() || this.engine.getNeedClientAuth() ? State.WRITE_CERTIFICATE_REQUEST : State.WRITE_SERVER_HELLO_DONE;
                        }
                    }
                    ** GOTO lbl217
                }
                case 3: {
                    if (!ServerHandshake.$assertionsDisabled && this.certLoader == null) {
                        throw new AssertionError();
                    }
                    if (!ServerHandshake.$assertionsDisabled && !this.certLoader.hasRun()) {
                        throw new AssertionError();
                    }
                    if (this.certLoader.thrown() != null) {
                        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.certLoader.thrown());
                    }
                    chain = this.engine.session().getLocalCertificates();
                    cert = new CertificateBuilder(CertificateType.X509);
                    try {
                        cert.setCertificates(Arrays.asList(chain));
                    }
                    catch (CertificateException ce) {
                        throw new SSLException(ce);
                    }
                    ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "my cert:\n{0}", new Object[]{this.localCert});
                    ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "{0}", new Object[]{cert});
                    typeLen = Handshake.Type.CERTIFICATE.getValue() << 24 | cert.length() & 0xFFFFFF;
                    fragment.putInt(typeLen);
                    this.outBuffer = cert.buffer();
                    l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    s = this.engine.session().suite;
                    kexalg = s.keyExchangeAlgorithm();
                    if (kexalg == KeyExchangeAlgorithm.DHE_DSS || kexalg == KeyExchangeAlgorithm.DHE_RSA) {
                        this.genDH = new GenDH();
                        this.tasks.add(this.genDH);
                        this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        break block13;
                    }
                    if (kexalg == KeyExchangeAlgorithm.RSA_PSK) {
                        this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        break block13;
                    }
                    if (this.engine.getWantClientAuth() || this.engine.getNeedClientAuth()) {
                        this.state = State.WRITE_CERTIFICATE_REQUEST;
                        break block13;
                    }
                    this.state = State.WRITE_SERVER_HELLO_DONE;
                    break block13;
                }
                case 4: {
                    kex = this.engine.session().suite.keyExchangeAlgorithm();
                    paramBuffer = null;
                    sigBuffer = null;
                    if (kex == KeyExchangeAlgorithm.DHE_DSS || kex == KeyExchangeAlgorithm.DHE_RSA || kex == KeyExchangeAlgorithm.DH_anon || kex == KeyExchangeAlgorithm.DHE_PSK) {
                        if (!ServerHandshake.$assertionsDisabled && this.genDH == null) {
                            throw new AssertionError();
                        }
                        if (!ServerHandshake.$assertionsDisabled && !this.genDH.hasRun()) {
                            throw new AssertionError();
                        }
                        if (this.genDH.thrown() != null) {
                            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.genDH.thrown());
                        }
                        if (!ServerHandshake.$assertionsDisabled && this.dhPair == null) {
                            throw new AssertionError();
                        }
                        this.initDiffieHellman((DHPrivateKey)this.dhPair.getPrivate(), this.engine.session().random());
                        paramBuffer = this.genDH.paramsBuffer;
                        sigBuffer = this.genDH.sigBuffer;
                        if (kex == KeyExchangeAlgorithm.DHE_PSK) {
                            identityHint = this.engine.contextImpl.pskManager.chooseIdentityHint();
                            psk = new ServerDHE_PSKParameters(identityHint, paramBuffer);
                            paramBuffer = psk.buffer();
                        }
                    }
                    if (kex == KeyExchangeAlgorithm.RSA_PSK && (idHint = this.engine.contextImpl.pskManager.chooseIdentityHint()) != null) {
                        params = new ServerRSA_PSKParameters(idHint);
                        paramBuffer = params.buffer();
                    }
                    if (kex == KeyExchangeAlgorithm.PSK && (idHint = this.engine.contextImpl.pskManager.chooseIdentityHint()) != null) {
                        params = new ServerPSKParameters(idHint);
                        paramBuffer = params.buffer();
                    }
                    if (paramBuffer != null) {
                        ske = new ServerKeyExchangeBuilder(this.engine.session().suite);
                        ske.setParams(paramBuffer);
                        if (sigBuffer != null) {
                            ske.setSignature(sigBuffer);
                        }
                        ServerHandshake.logger.log((Level)Component.SSL_HANDSHAKE, "{0}", ske);
                        this.outBuffer = ske.buffer();
                        l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                        fragment.putInt(Handshake.Type.SERVER_KEY_EXCHANGE.getValue() << 24 | ske.length() & 0xFFFFFF);
                        fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                        this.outBuffer.position(this.outBuffer.position() + l);
                    }
                    this.state = this.engine.getWantClientAuth() || this.engine.getNeedClientAuth() ? State.WRITE_CERTIFICATE_REQUEST : State.WRITE_SERVER_HELLO_DONE;
                    ** GOTO lbl217
                }
                case 5: {
                    req = new CertificateRequestBuilder();
                    types = new ArrayList<CertificateRequest.ClientCertificateType>(4);
                    types.add(CertificateRequest.ClientCertificateType.RSA_SIGN);
                    types.add(CertificateRequest.ClientCertificateType.RSA_FIXED_DH);
                    types.add(CertificateRequest.ClientCertificateType.DSS_SIGN);
                    types.add(CertificateRequest.ClientCertificateType.DSS_FIXED_DH);
                    req.setTypes(types);
                    anchors = this.engine.contextImpl.trustManager.getAcceptedIssuers();
                    issuers = new ArrayList<X500Principal>(anchors.length);
                    var9_35 = anchors;
                    var8_34 = anchors.length;
                    var7_32 = 0;
                    while (var7_32 < var8_34) {
                        cert = var9_35[var7_32];
                        issuers.add(cert.getIssuerX500Principal());
                        ++var7_32;
                    }
                    req.setAuthorities(issuers);
                    ServerHandshake.logger.log((Level)Component.SSL_HANDSHAKE, "{0}", req);
                    fragment.putInt(Handshake.Type.CERTIFICATE_REQUEST.getValue() << 24 | req.length() & 0xFFFFFF);
                    this.outBuffer = req.buffer();
                    l = Math.min(this.outBuffer.remaining(), fragment.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    this.state = State.WRITE_SERVER_HELLO_DONE;
                    ** GOTO lbl217
                }
                case 6: {
                    fragment.putInt(Handshake.Type.SERVER_HELLO_DONE.getValue() << 24);
                    ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "writing ServerHelloDone", new Object[0]);
                    this.state = State.READ_CERTIFICATE;
                    break block13;
                }
                case 7: {
                    md5copy = null;
                    shacopy = null;
                    try {
                        md5copy = (MessageDigest)this.md5.clone();
                        shacopy = (MessageDigest)this.sha.clone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        throw new SSLException(cnse);
                    }
                    this.outBuffer = this.generateFinished(md5copy, shacopy, false, this.engine.session());
                    fragment.putInt(Handshake.Type.FINISHED.getValue() << 24 | this.outBuffer.remaining() & 0xFFFFFF);
                    l = Math.min(this.outBuffer.remaining(), fragment.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    this.state = this.continuedSession != false ? State.READ_FINISHED : State.DONE;
                }
lbl217:
                // 7 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (fragment.remaining() >= 4 && this.state.isWriteState()) continue block13;
                }
            }
        }
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isWriteState() || this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    SSLEngineResult.HandshakeStatus status() {
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.state.isWriteState()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    void checkKeyExchange() throws SSLException {
        if (this.continuedSession) {
            return;
        }
        KeyExchangeAlgorithm kex = this.engine.session().suite.keyExchangeAlgorithm();
        if (kex == KeyExchangeAlgorithm.NONE || kex == KeyExchangeAlgorithm.PSK || kex == KeyExchangeAlgorithm.RSA_PSK) {
            return;
        }
        if (this.keyExchangeTask == null) {
            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR));
        }
        if (!this.keyExchangeTask.hasRun()) {
            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR));
        }
        if (this.keyExchangeTask.thrown() != null) {
            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.keyExchangeTask.thrown());
        }
    }

    void handleV2Hello(ByteBuffer hello) {
        int len = hello.getShort(0) & Short.MAX_VALUE;
        this.md5.update((ByteBuffer)hello.duplicate().position(2).limit(len + 2));
        this.sha.update((ByteBuffer)hello.duplicate().position(2).limit(len + 2));
        this.helloV2 = true;
    }

    private ByteBuffer signParams(ByteBuffer serverParams) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        SignatureAlgorithm alg = this.engine.session().suite.signatureAlgorithm();
        java.security.Signature sig = java.security.Signature.getInstance(alg.algorithm());
        PrivateKey key = this.engine.contextImpl.keyManager.getPrivateKey(this.keyAlias);
        logger.logv(Component.SSL_HANDSHAKE, "server key: {0}", key);
        sig.initSign(key);
        sig.update(this.clientRandom.buffer());
        sig.update(this.serverRandom.buffer());
        sig.update(serverParams);
        byte[] sigVal = sig.sign();
        Signature signature = new Signature(sigVal, this.engine.session().suite.signatureAlgorithm());
        return signature.buffer();
    }

    private void verifyClient(byte[] sigValue) throws SSLException, SignatureException {
        MessageDigest md5copy = null;
        MessageDigest shacopy = null;
        try {
            md5copy = (MessageDigest)this.md5.clone();
            shacopy = (MessageDigest)this.sha.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new SSLException(cnse);
        }
        byte[] toSign = null;
        toSign = this.engine.session().version == ProtocolVersion.SSL_3 ? this.genV3CertificateVerify(md5copy, shacopy, this.engine.session()) : (this.engine.session().suite.signatureAlgorithm() == SignatureAlgorithm.RSA ? Util.concat(md5copy.digest(), shacopy.digest()) : shacopy.digest());
        try {
            java.security.Signature sig = java.security.Signature.getInstance(this.engine.session().suite.signatureAlgorithm().toString());
            sig.initVerify(this.clientCert);
            sig.update(toSign);
            sig.verify(sigValue);
        }
        catch (InvalidKeyException ike) {
            throw new SSLException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLException(nsae);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$gnu$javax$net$ssl$provider$Extension$Type() {
        if ($SWITCH_TABLE$gnu$javax$net$ssl$provider$Extension$Type != null) {
            return $SWITCH_TABLE$gnu$javax$net$ssl$provider$Extension$Type;
        }
        int[] nArray = new int[Extension.Type.values().length];
        try {
            nArray[Extension.Type.CERT_TYPE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.CLIENT_CERTIFICATE_URL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.MAX_FRAGMENT_LENGTH.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.SERVER_NAME.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.SRP.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.STATUS_REQUEST.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.TRUNCATED_HMAC.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Extension.Type.TRUSTED_CA_KEYS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$gnu$javax$net$ssl$provider$Extension$Type = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm() {
        if ($SWITCH_TABLE$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm != null) {
            return $SWITCH_TABLE$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm;
        }
        int[] nArray = new int[KeyExchangeAlgorithm.values().length];
        try {
            nArray[KeyExchangeAlgorithm.DHE_DSS.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.DHE_PSK.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.DHE_RSA.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.DH_DSS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.DH_RSA.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.DH_anon.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.PSK.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.RSA.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KeyExchangeAlgorithm.RSA_PSK.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State() {
        if ($SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State != null) {
            return $SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State;
        }
        int[] nArray = new int[State.values().length];
        try {
            nArray[State.DONE.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.READ_CERTIFICATE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.READ_CERTIFICATE_VERIFY.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.READ_CLIENT_HELLO.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.READ_CLIENT_KEY_EXCHANGE.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.READ_FINISHED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_CERTIFICATE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_CERTIFICATE_REQUEST.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_FINISHED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_HELLO_REQUEST.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_SERVER_HELLO.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_SERVER_HELLO_DONE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.WRITE_SERVER_KEY_EXCHANGE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$gnu$javax$net$ssl$provider$ServerHandshake$State = nArray;
        return nArray;
    }

    class CertLoader
    extends DelegatedTask {
        CertLoader() {
        }

        public void implRun() throws SSLException {
            KeyExchangeAlgorithm kexalg = ServerHandshake.this.engine.session().suite.keyExchangeAlgorithm();
            X509ExtendedKeyManager km = ServerHandshake.this.engine.contextImpl.keyManager;
            Principal[] issuers = null;
            ServerHandshake.this.keyAlias = km.chooseEngineServerAlias(kexalg.name(), issuers, ServerHandshake.this.engine);
            if (ServerHandshake.this.keyAlias == null) {
                throw new SSLException("no certificates available");
            }
            java.security.cert.Certificate[] chain = km.getCertificateChain(ServerHandshake.this.keyAlias);
            ServerHandshake.this.engine.session().setLocalCertificates(chain);
            ServerHandshake.this.localCert = (X509Certificate)chain[0];
            ServerHandshake.this.serverKey = km.getPrivateKey(ServerHandshake.this.keyAlias);
            if (kexalg == KeyExchangeAlgorithm.DH_DSS || kexalg == KeyExchangeAlgorithm.DH_RSA) {
                ServerHandshake.this.dhPair = new KeyPair(ServerHandshake.this.localCert.getPublicKey(), km.getPrivateKey(ServerHandshake.this.keyAlias));
            }
        }
    }

    private class GenDH
    extends DelegatedTask {
        ByteBuffer paramsBuffer;
        ByteBuffer sigBuffer;

        private GenDH() {
        }

        protected void implRun() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException {
            KeyPairGenerator dhGen = KeyPairGenerator.getInstance("DH");
            DHParameterSpec dhparams = DiffieHellman.getParams().getParams();
            dhGen.initialize(dhparams, ServerHandshake.this.engine.session().random());
            ServerHandshake.this.dhPair = dhGen.generateKeyPair();
            DHPublicKey pub = (DHPublicKey)ServerHandshake.this.dhPair.getPublic();
            ServerDHParams params = new ServerDHParams(pub.getParams().getP(), pub.getParams().getG(), pub.getY());
            this.paramsBuffer = params.buffer();
            if (ServerHandshake.this.engine.session().suite.signatureAlgorithm() != SignatureAlgorithm.ANONYMOUS) {
                this.sigBuffer = ServerHandshake.this.signParams(this.paramsBuffer);
                this.paramsBuffer.rewind();
            }
            logger.logv(Component.SSL_KEY_EXCHANGE, "Diffie-Hellman public:{0} private:{1}", ServerHandshake.this.dhPair.getPublic(), ServerHandshake.this.dhPair.getPrivate());
        }
    }

    class RSAKeyExchange
    extends DelegatedTask {
        private final byte[] encryptedPreMasterSecret;

        RSAKeyExchange(byte[] encryptedPreMasterSecret) {
            this.encryptedPreMasterSecret = encryptedPreMasterSecret;
        }

        public void implRun() throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, SSLException {
            Cipher rsa = Cipher.getInstance("RSA");
            rsa.init(2, ServerHandshake.this.serverKey);
            rsa.init(2, ServerHandshake.this.localCert);
            ServerHandshake.this.preMasterSecret = rsa.doFinal(this.encryptedPreMasterSecret);
            ServerHandshake.this.generateMasterSecret(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            byte[][] keys = ServerHandshake.this.generateKeys(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            ServerHandshake.this.setupSecurityParameters(keys, false, ServerHandshake.this.engine, ServerHandshake.this.compression);
        }
    }

    class RSA_PSKExchange
    extends DelegatedTask {
        private final byte[] encryptedPreMasterSecret;
        private final SecretKey psKey;

        RSA_PSKExchange(byte[] encryptedPreMasterSecret, SecretKey psKey) {
            this.encryptedPreMasterSecret = encryptedPreMasterSecret;
            this.psKey = psKey;
        }

        public void implRun() throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, SSLException {
            Cipher rsa = Cipher.getInstance("RSA");
            rsa.init(2, ServerHandshake.this.serverKey);
            rsa.init(2, ServerHandshake.this.localCert);
            byte[] rsaSecret = rsa.doFinal(this.encryptedPreMasterSecret);
            byte[] psSecret = this.psKey.getEncoded();
            ServerHandshake.this.preMasterSecret = new byte[rsaSecret.length + psSecret.length + 4];
            ServerHandshake.this.preMasterSecret[0] = (byte)(rsaSecret.length >>> 8);
            ServerHandshake.this.preMasterSecret[1] = (byte)rsaSecret.length;
            System.arraycopy(rsaSecret, 0, ServerHandshake.this.preMasterSecret, 2, rsaSecret.length);
            ServerHandshake.this.preMasterSecret[rsaSecret.length + 2] = (byte)(psSecret.length >>> 8);
            ServerHandshake.this.preMasterSecret[rsaSecret.length + 3] = (byte)psSecret.length;
            System.arraycopy(psSecret, 0, ServerHandshake.this.preMasterSecret, rsaSecret.length + 4, psSecret.length);
            ServerHandshake.this.generateMasterSecret(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            byte[][] keys = ServerHandshake.this.generateKeys(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            ServerHandshake.this.setupSecurityParameters(keys, false, ServerHandshake.this.engine, ServerHandshake.this.compression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WRITE_HELLO_REQUEST(true, false),
        WRITE_SERVER_HELLO(true, false),
        WRITE_CERTIFICATE(true, false),
        WRITE_SERVER_KEY_EXCHANGE(true, false),
        WRITE_CERTIFICATE_REQUEST(true, false),
        WRITE_SERVER_HELLO_DONE(true, false),
        WRITE_FINISHED(true, false),
        READ_CLIENT_HELLO(false, true),
        READ_CERTIFICATE(false, true),
        READ_CLIENT_KEY_EXCHANGE(false, true),
        READ_CERTIFICATE_VERIFY(false, true),
        READ_FINISHED(false, true),
        DONE(false, false);

        private final boolean isWriteState;
        private final boolean isReadState;

        private State(boolean isWriteState, boolean isReadState) {
            this.isWriteState = isWriteState;
            this.isReadState = isReadState;
        }

        boolean isReadState() {
            return this.isReadState;
        }

        boolean isWriteState() {
            return this.isWriteState;
        }
    }
}

