/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;

class DataSourceDataContentHandler
implements DataContentHandler {
    private DataSource ds;
    private DataFlavor[] flavors;
    private DataContentHandler dch;

    public DataSourceDataContentHandler(DataContentHandler dch, DataSource ds) {
        this.ds = ds;
        this.dch = dch;
    }

    public Object getContent(DataSource ds) throws IOException {
        if (this.dch != null) {
            return this.dch.getContent(ds);
        }
        return ds.getInputStream();
    }

    public Object getTransferData(DataFlavor flavor, DataSource ds) throws UnsupportedFlavorException, IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(flavor, ds);
        }
        DataFlavor[] tdf = this.getTransferDataFlavors();
        if (tdf.length > 0 && flavor.equals(tdf[0])) {
            return ds.getInputStream();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.flavors == null) {
            if (this.dch != null) {
                this.flavors = this.dch.getTransferDataFlavors();
            } else {
                String mimeType = this.ds.getContentType();
                this.flavors = new DataFlavor[1];
                this.flavors[0] = new ActivationDataFlavor(mimeType, mimeType);
            }
        }
        return this.flavors;
    }

    public void writeTo(Object obj, String mimeType, OutputStream out) throws IOException {
        if (this.dch == null) {
            throw new UnsupportedDataTypeException("no DCH for content type " + this.ds.getContentType());
        }
        this.dch.writeTo(obj, mimeType, out);
    }
}

