/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.AbstractExpression;
import org.jfree.report.expressions.Function;
import org.jfree.report.expressions.ReportFormulaContext;
import org.jfree.report.flow.ReportContext;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaFunction
extends AbstractExpression
implements Function {
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;
    private String initialNamespace;
    private String initialExpression;
    private String initial;
    private transient Formula compiledFormula;
    private boolean initialized;

    private synchronized FormulaContext getFormulaContext() {
        ReportContext reportContext = this.getRuntime().getReportContext();
        return reportContext.getFormulaContext();
    }

    public String getInitial() {
        return this.initial;
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }

    public String getInitialNamespace() {
        return this.initialNamespace;
    }

    public void setInitial(String string) {
        this.initial = string;
        if (string == null) {
            this.initialNamespace = null;
            this.initialExpression = null;
        } else {
            int n = string.indexOf(58);
            if (n <= 0 || n + 1 == string.length()) {
                if (this.formula.startsWith("=")) {
                    this.initialNamespace = "report";
                    this.initialExpression = string.substring(1);
                } else {
                    this.initialNamespace = null;
                    this.initialExpression = null;
                }
            } else {
                this.initialNamespace = string.substring(0, n);
                this.initialExpression = string.substring(n + 1);
            }
        }
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String string) {
        this.formula = string;
        if (string == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            int n = string.indexOf(58);
            if (n <= 0 || n + 1 == string.length()) {
                if (string.startsWith("=")) {
                    this.formulaNamespace = "report";
                    this.formulaExpression = string.substring(1);
                } else {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                }
            } else {
                this.formulaNamespace = string.substring(0, n);
                this.formulaExpression = string.substring(n + 1);
            }
        }
        this.compiledFormula = null;
    }

    public Function advance() throws DataSourceException {
        try {
            return (Function)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new DataSourceException("Unable to derive a new instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object computeInitialValue() {
        if (this.initial == null) return this.computeRegularValue();
        Formula formula = new Formula(this.initialExpression);
        ReportFormulaContext reportFormulaContext = new ReportFormulaContext(this.getFormulaContext(), this.getDataRow());
        reportFormulaContext.setDeclaringElement(this.getRuntime().getDeclaringParent());
        try {
            formula.initialize((FormulaContext)reportFormulaContext);
            Object object = formula.evaluate();
            reportFormulaContext.setDeclaringElement(null);
            reportFormulaContext.setDataRow(null);
            return object;
        }
        catch (Throwable throwable) {
            try {
                reportFormulaContext.setDeclaringElement(null);
                reportFormulaContext.setDataRow(null);
                throw throwable;
            }
            catch (Exception exception) {
                DebugLog.log((Object)"Failed to compute the initial value.");
                return null;
            }
        }
    }

    private Object computeRegularValue() {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ReportFormulaContext reportFormulaContext = new ReportFormulaContext(this.getFormulaContext(), this.getDataRow());
        reportFormulaContext.setDeclaringElement(this.getRuntime().getDeclaringParent());
        try {
            this.compiledFormula.initialize((FormulaContext)reportFormulaContext);
            Object object = this.compiledFormula.evaluate();
            reportFormulaContext.setDeclaringElement(null);
            reportFormulaContext.setDataRow(null);
            return object;
        }
        catch (Throwable throwable) {
            try {
                reportFormulaContext.setDeclaringElement(null);
                reportFormulaContext.setDataRow(null);
                throw throwable;
            }
            catch (Exception exception) {
                DebugLog.log((Object)"Failed to compute the regular value.", (Throwable)exception);
                return null;
            }
        }
    }

    public Object computeValue() throws DataSourceException {
        try {
            if (!this.initialized) {
                this.initialized = true;
                return this.computeInitialValue();
            }
            return this.computeRegularValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaFunction formulaFunction = (FormulaFunction)super.clone();
        if (this.compiledFormula != null) {
            formulaFunction.compiledFormula = (Formula)this.compiledFormula.clone();
        }
        return formulaFunction;
    }

    public Formula getCompiledFormula() throws ParseException {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        return this.compiledFormula;
    }
}

