(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/digest#digest::t
    (make-struct-type
     'std/crypto#digest::t
     '#f
     '2
     'digest
     '()
     ':init!
     '(type ctx)))
  (define std/crypto/digest#digest?
    (make-struct-predicate std/crypto/digest#digest::t))
  (define std/crypto/digest#make-digest
    (lambda _$args117367_
      (apply make-struct-instance std/crypto/digest#digest::t _$args117367_)))
  (define std/crypto/digest#digest-type
    (make-struct-field-accessor std/crypto/digest#digest::t '0))
  (define std/crypto/digest#digest-ctx
    (make-struct-field-accessor std/crypto/digest#digest::t '1))
  (define std/crypto/digest#digest-type-set!
    (make-struct-field-mutator std/crypto/digest#digest::t '0))
  (define std/crypto/digest#digest-ctx-set!
    (make-struct-field-mutator std/crypto/digest#digest::t '1))
  (define std/crypto/digest#digest:::init!
    (lambda (_self117359_ _type117360_)
      (if (std/crypto/libcrypto#EVP_MD? _type117360_)
          '#!void
          (error '"Invalid digest type" _type117360_))
      (let ((_ctx117362_ (std/crypto/libcrypto#EVP_MD_CTX_create)))
        (if _ctx117362_ '#!void (error '"Failed to allocate digest context"))
        (let ((_res117364_
               (std/crypto/libcrypto#EVP_DigestInit _ctx117362_ _type117360_)))
          (if (##fxzero? _res117364_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        (if (##fx< '2 (##vector-length _self117359_))
            (begin
              (##vector-set! _self117359_ '1 _type117360_)
              (##vector-set! _self117359_ '2 _ctx117362_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self117359_)))))
  (bind-method!
   std/crypto/digest#digest::t
   ':init!
   std/crypto/digest#digest:::init!
   '#f)
  (define std/crypto/digest#digest-size
    (lambda (_digest117235_)
      (if (std/crypto/libcrypto#EVP_MD? _digest117235_)
          (std/crypto/libcrypto#EVP_MD_size _digest117235_)
          (std/crypto/libcrypto#EVP_MD_size
           (##structure-ref
            _digest117235_
            '1
            std/crypto/digest#digest::t
            '#f)))))
  (define std/crypto/digest#digest-name
    (lambda (_digest117233_)
      (if (std/crypto/libcrypto#EVP_MD? _digest117233_)
          (std/crypto/libcrypto#EVP_MD_name _digest117233_)
          (std/crypto/libcrypto#EVP_MD_name
           (##structure-ref
            _digest117233_
            '1
            std/crypto/digest#digest::t
            '#f)))))
  (define std/crypto/digest#digest-copy
    (lambda (_digest117223_)
      (let* ((_ctx117225_ (std/crypto/digest#digest-context _digest117223_))
             (_copy117227_
              (let ((__obj117369 (make-object std/crypto/digest#digest::t '2)))
                (std/crypto/digest#digest:::init!
                 __obj117369
                 (##structure-ref
                  _digest117223_
                  '1
                  std/crypto/digest#digest::t
                  '#f))
                __obj117369)))
        (let ((_res117230_
               (std/crypto/libcrypto#EVP_MD_CTX_copy
                (##structure-ref
                 _copy117227_
                 '2
                 std/crypto/digest#digest::t
                 '#f)
                _ctx117225_)))
          (if (##fxzero? _res117230_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        _copy117227_)))
  (define std/crypto/digest#digest-context
    (lambda (_digest117218_)
      (let ((_$e117220_
             (##structure-ref
              _digest117218_
              '2
              std/crypto/digest#digest::t
              '#f)))
        (if _$e117220_
            _$e117220_
            (error '"Digest has been finalized" _digest117218_)))))
  (define std/crypto/digest#digest-update!__%
    (lambda (_digest117178_ _bytes117179_ _start117180_ _end117181_)
      (let* ((_start117186_
              (let ((_$e117183_ _start117180_)) (if _$e117183_ _$e117183_ '0)))
             (_end117191_
              (let ((_$e117188_ _end117181_))
                (if _$e117188_ _$e117188_ (u8vector-length _bytes117179_)))))
        (let ((_res117194_
               (std/crypto/libcrypto#EVP_DigestUpdate
                (std/crypto/digest#digest-context _digest117178_)
                _bytes117179_
                _start117186_
                _end117191_)))
          (if (##fxzero? _res117194_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void)))))
  (define std/crypto/digest#digest-update!__0
    (lambda (_digest117200_ _bytes117201_)
      (let* ((_start117203_ '#f) (_end117205_ '#f))
        (std/crypto/digest#digest-update!__%
         _digest117200_
         _bytes117201_
         _start117203_
         _end117205_))))
  (define std/crypto/digest#digest-update!__1
    (lambda (_digest117207_ _bytes117208_ _start117209_)
      (let ((_end117211_ '#f))
        (std/crypto/digest#digest-update!__%
         _digest117207_
         _bytes117208_
         _start117209_
         _end117211_))))
  (define std/crypto/digest#digest-update!
    (lambda _g117379_
      (let ((_g117378_ (length _g117379_)))
        (cond ((##fx= _g117378_ 2)
               (apply std/crypto/digest#digest-update!__0 _g117379_))
              ((##fx= _g117378_ 3)
               (apply std/crypto/digest#digest-update!__1 _g117379_))
              ((##fx= _g117378_ 4)
               (apply std/crypto/digest#digest-update!__% _g117379_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/digest#digest-update!
                _g117379_))))))
  (define std/crypto/digest#digest-update*
    (lambda (_digest117166_ _in117167_ . _args117168_)
      (apply std/crypto/etc#call-with-binary-input
             (lambda (_bytes117170_ _start117171_ _end117172_)
               (let ((_res117174_
                      (std/crypto/libcrypto#EVP_DigestUpdate
                       (std/crypto/digest#digest-context _digest117166_)
                       _bytes117170_
                       _start117171_
                       _end117172_)))
                 (if (##fxzero? _res117174_)
                     (apply std/crypto/etc#raise-libcrypto-error '())
                     '#!void)))
             _in117167_
             _args117168_)))
  (define std/crypto/digest#digest-final!__%
    (lambda (_digest117140_ _bytes117141_)
      (let* ((_ctx117143_ (std/crypto/digest#digest-context _digest117140_))
             (_size117145_ (std/crypto/libcrypto#EVP_MD_CTX_size _ctx117143_))
             (_bytes117150_
              (let ((_$e117147_ _bytes117141_))
                (if _$e117147_ _$e117147_ (make-u8vector _size117145_)))))
        (let ((_res117153_
               (std/crypto/libcrypto#EVP_DigestFinal
                _ctx117143_
                _bytes117150_)))
          (if (##fxzero? _res117153_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        (##structure-set!
         _digest117140_
         '#f
         '2
         std/crypto/digest#digest::t
         '#f)
        _bytes117150_)))
  (define std/crypto/digest#digest-final!__0
    (lambda (_digest117159_)
      (let ((_bytes117161_ '#f))
        (std/crypto/digest#digest-final!__% _digest117159_ _bytes117161_))))
  (define std/crypto/digest#digest-final!
    (lambda _g117381_
      (let ((_g117380_ (length _g117381_)))
        (cond ((##fx= _g117380_ 1)
               (apply std/crypto/digest#digest-final!__0 _g117381_))
              ((##fx= _g117380_ 2)
               (apply std/crypto/digest#digest-final!__% _g117381_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/digest#digest-final!
                _g117381_))))))
  (define std/crypto/digest#digest::md5 (std/crypto/libcrypto#EVP_md5))
  (define std/crypto/digest#make-md5-digest
    (lambda ()
      (let ((__obj117370 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117370
         std/crypto/digest#digest::md5)
        __obj117370)))
  (define std/crypto/digest#md5-digest?
    (lambda (_obj117135_)
      (if (##structure-instance-of? _obj117135_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117135_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::md5)))
          '#f)))
  (define std/crypto/digest#md5
    (lambda _args117129_
      (let ((_digest117132_ (std/crypto/digest#make-md5-digest)))
        (apply std/crypto/digest#digest-update* _digest117132_ _args117129_)
        (std/crypto/digest#digest-final!__0 _digest117132_))))
  (define std/crypto/digest#digest::sha1 (std/crypto/libcrypto#EVP_sha1))
  (define std/crypto/digest#make-sha1-digest
    (lambda ()
      (let ((__obj117371 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117371
         std/crypto/digest#digest::sha1)
        __obj117371)))
  (define std/crypto/digest#sha1-digest?
    (lambda (_obj117125_)
      (if (##structure-instance-of? _obj117125_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117125_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha1)))
          '#f)))
  (define std/crypto/digest#sha1
    (lambda _args117119_
      (let ((_digest117122_ (std/crypto/digest#make-sha1-digest)))
        (apply std/crypto/digest#digest-update* _digest117122_ _args117119_)
        (std/crypto/digest#digest-final!__0 _digest117122_))))
  (define std/crypto/digest#digest::sha224 (std/crypto/libcrypto#EVP_sha224))
  (define std/crypto/digest#make-sha224-digest
    (lambda ()
      (let ((__obj117372 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117372
         std/crypto/digest#digest::sha224)
        __obj117372)))
  (define std/crypto/digest#sha224-digest?
    (lambda (_obj117115_)
      (if (##structure-instance-of? _obj117115_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117115_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha224)))
          '#f)))
  (define std/crypto/digest#sha224
    (lambda _args117109_
      (let ((_digest117112_ (std/crypto/digest#make-sha224-digest)))
        (apply std/crypto/digest#digest-update* _digest117112_ _args117109_)
        (std/crypto/digest#digest-final!__0 _digest117112_))))
  (define std/crypto/digest#digest::sha256 (std/crypto/libcrypto#EVP_sha256))
  (define std/crypto/digest#make-sha256-digest
    (lambda ()
      (let ((__obj117373 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117373
         std/crypto/digest#digest::sha256)
        __obj117373)))
  (define std/crypto/digest#sha256-digest?
    (lambda (_obj117105_)
      (if (##structure-instance-of? _obj117105_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117105_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha256)))
          '#f)))
  (define std/crypto/digest#sha256
    (lambda _args117099_
      (let ((_digest117102_ (std/crypto/digest#make-sha256-digest)))
        (apply std/crypto/digest#digest-update* _digest117102_ _args117099_)
        (std/crypto/digest#digest-final!__0 _digest117102_))))
  (define std/crypto/digest#digest::sha384 (std/crypto/libcrypto#EVP_sha384))
  (define std/crypto/digest#make-sha384-digest
    (lambda ()
      (let ((__obj117374 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117374
         std/crypto/digest#digest::sha384)
        __obj117374)))
  (define std/crypto/digest#sha384-digest?
    (lambda (_obj117095_)
      (if (##structure-instance-of? _obj117095_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117095_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha384)))
          '#f)))
  (define std/crypto/digest#sha384
    (lambda _args117089_
      (let ((_digest117092_ (std/crypto/digest#make-sha384-digest)))
        (apply std/crypto/digest#digest-update* _digest117092_ _args117089_)
        (std/crypto/digest#digest-final!__0 _digest117092_))))
  (define std/crypto/digest#digest::sha512 (std/crypto/libcrypto#EVP_sha512))
  (define std/crypto/digest#make-sha512-digest
    (lambda ()
      (let ((__obj117375 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117375
         std/crypto/digest#digest::sha512)
        __obj117375)))
  (define std/crypto/digest#sha512-digest?
    (lambda (_obj117085_)
      (if (##structure-instance-of? _obj117085_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117085_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::sha512)))
          '#f)))
  (define std/crypto/digest#sha512
    (lambda _args117079_
      (let ((_digest117082_ (std/crypto/digest#make-sha512-digest)))
        (apply std/crypto/digest#digest-update* _digest117082_ _args117079_)
        (std/crypto/digest#digest-final!__0 _digest117082_))))
  (define std/crypto/digest#digest::ripemd160
    (std/crypto/libcrypto#EVP_ripemd160))
  (define std/crypto/digest#make-ripemd160-digest
    (lambda ()
      (let ((__obj117376 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117376
         std/crypto/digest#digest::ripemd160)
        __obj117376)))
  (define std/crypto/digest#ripemd160-digest?
    (lambda (_obj117075_)
      (if (##structure-instance-of? _obj117075_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117075_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::ripemd160)))
          '#f)))
  (define std/crypto/digest#ripemd160
    (lambda _args117069_
      (let ((_digest117072_ (std/crypto/digest#make-ripemd160-digest)))
        (apply std/crypto/digest#digest-update* _digest117072_ _args117069_)
        (std/crypto/digest#digest-final!__0 _digest117072_))))
  (define std/crypto/digest#digest::whirlpool
    (std/crypto/libcrypto#EVP_whirlpool))
  (define std/crypto/digest#make-whirlpool-digest
    (lambda ()
      (let ((__obj117377 (make-object std/crypto/digest#digest::t '2)))
        (std/crypto/digest#digest:::init!
         __obj117377
         std/crypto/digest#digest::whirlpool)
        __obj117377)))
  (define std/crypto/digest#whirlpool-digest?
    (lambda (_obj117065_)
      (if (##structure-instance-of? _obj117065_ 'std/crypto#digest::t)
          (eq? (std/crypto/libcrypto#EVP_MD_type
                (##structure-ref
                 _obj117065_
                 '1
                 std/crypto/digest#digest::t
                 '#f))
               (std/crypto/libcrypto#EVP_MD_type
                (std/crypto/digest#digest::whirlpool)))
          '#f)))
  (define std/crypto/digest#whirlpool
    (lambda _args117059_
      (let ((_digest117062_ (std/crypto/digest#make-whirlpool-digest)))
        (apply std/crypto/digest#digest-update* _digest117062_ _args117059_)
        (std/crypto/digest#digest-final!__0 _digest117062_)))))
