/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import jadx.api.JadxArgs;
import jadx.cli.JadxCLIArgs;
import jadx.gui.settings.ISettingsUpdater;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.settings.WindowLocation;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Utils;
import java.awt.Font;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettings
extends JadxCLIArgs {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettings.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final int RECENT_FILES_COUNT = 15;
    private static final int CURRENT_SETTINGS_VERSION = 6;
    private static final Font DEFAULT_FONT = Utils.FONT_HACK != null ? Utils.FONT_HACK : new RSyntaxTextArea().getFont();
    static final Set<String> SKIP_FIELDS = new HashSet<String>(Arrays.asList("files", "input", "outputDir", "verbose", "printHelp"));
    private String lastOpenFilePath = USER_HOME;
    private String lastSaveFilePath = USER_HOME;
    private boolean flattenPackage = false;
    private boolean checkForUpdates = false;
    private List<String> recentFiles = new ArrayList<String>();
    private String fontStr = "";
    private String editorThemePath = "";
    private LangLocale langLocale = NLS.defaultLocale();
    private boolean autoStartJobs = false;
    protected String excludedPackages = "";
    private boolean showHeapUsageBar = true;
    private int settingsVersion = 0;
    private Map<String, WindowLocation> windowPos = new HashMap<String, WindowLocation>();

    public static JadxSettings makeDefault() {
        JadxSettings jadxSettings = new JadxSettings();
        jadxSettings.fixOnLoad();
        return jadxSettings;
    }

    public void sync() {
        JadxSettingsAdapter.store(this);
    }

    public void partialSync(ISettingsUpdater updater) {
        JadxSettings settings = JadxSettingsAdapter.load();
        updater.update(settings);
        JadxSettingsAdapter.store(settings);
    }

    public void fixOnLoad() {
        if (this.threadsCount <= 0) {
            this.threadsCount = JadxArgs.DEFAULT_THREADS_COUNT;
        }
        if (this.deobfuscationMinLength < 0) {
            this.deobfuscationMinLength = 0;
        }
        if (this.deobfuscationMaxLength < 0) {
            this.deobfuscationMaxLength = 0;
        }
        if (this.settingsVersion != 6) {
            this.upgradeSettings(this.settingsVersion);
        }
    }

    public String getLastOpenFilePath() {
        return this.lastOpenFilePath;
    }

    public void setLastOpenFilePath(String lastOpenFilePath) {
        this.lastOpenFilePath = lastOpenFilePath;
        this.partialSync(settings -> {
            settings.lastOpenFilePath = this.lastOpenFilePath;
        });
    }

    public String getLastSaveFilePath() {
        return this.lastSaveFilePath;
    }

    public void setLastSaveFilePath(String lastSaveFilePath) {
        this.lastSaveFilePath = lastSaveFilePath;
        this.partialSync(settings -> {
            settings.lastSaveFilePath = this.lastSaveFilePath;
        });
    }

    public boolean isFlattenPackage() {
        return this.flattenPackage;
    }

    public void setFlattenPackage(boolean flattenPackage) {
        this.flattenPackage = flattenPackage;
        this.partialSync(settings -> {
            settings.flattenPackage = this.flattenPackage;
        });
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
        this.sync();
    }

    public Iterable<String> getRecentFiles() {
        return this.recentFiles;
    }

    public void addRecentFile(String filePath) {
        this.recentFiles.remove(filePath);
        this.recentFiles.add(0, filePath);
        int count = this.recentFiles.size();
        if (count > 15) {
            this.recentFiles.subList(15, count).clear();
        }
        this.partialSync(settings -> {
            settings.recentFiles = this.recentFiles;
        });
    }

    public void saveWindowPos(Window window) {
        WindowLocation pos = new WindowLocation(window.getClass().getSimpleName(), window.getX(), window.getY(), window.getWidth(), window.getHeight());
        this.windowPos.put(pos.getWindowId(), pos);
        this.partialSync(settings -> {
            settings.windowPos = this.windowPos;
        });
    }

    public boolean loadWindowPos(Window window) {
        WindowLocation pos = this.windowPos.get(window.getClass().getSimpleName());
        if (pos == null) {
            return false;
        }
        window.setLocation(pos.getX(), pos.getY());
        window.setSize(pos.getWidth(), pos.getHeight());
        return true;
    }

    public boolean isShowHeapUsageBar() {
        return this.showHeapUsageBar;
    }

    public void setShowHeapUsageBar(boolean showHeapUsageBar) {
        this.showHeapUsageBar = showHeapUsageBar;
        this.partialSync(settings -> {
            settings.showHeapUsageBar = showHeapUsageBar;
        });
    }

    public String getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(String excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    public void setFallbackMode(boolean fallbackMode) {
        this.fallbackMode = fallbackMode;
    }

    public void setSkipResources(boolean skipResources) {
        this.skipResources = skipResources;
    }

    public void setSkipSources(boolean skipSources) {
        this.skipSources = skipSources;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public LangLocale getLangLocale() {
        return this.langLocale;
    }

    public void setLangLocale(LangLocale langLocale) {
        this.langLocale = langLocale;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public void setRawCfgOutput(boolean rawCfgOutput) {
        this.rawCfgOutput = rawCfgOutput;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.deobfuscationOn = deobfuscationOn;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public void setDeobfuscationForceSave(boolean deobfuscationForceSave) {
        this.deobfuscationForceSave = deobfuscationForceSave;
    }

    public void setDeobfuscationUseSourceNameAsAlias(boolean deobfuscationUseSourceNameAsAlias) {
        this.deobfuscationUseSourceNameAsAlias = deobfuscationUseSourceNameAsAlias;
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public void setRespectBytecodeAccessModifiers(boolean respectBytecodeAccessModifiers) {
        this.respectBytecodeAccessModifiers = respectBytecodeAccessModifiers;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public boolean isAutoStartJobs() {
        return this.autoStartJobs;
    }

    public void setAutoStartJobs(boolean autoStartJobs) {
        this.autoStartJobs = autoStartJobs;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public Font getFont() {
        if (this.fontStr.isEmpty()) {
            return DEFAULT_FONT;
        }
        return Font.decode(this.fontStr);
    }

    public void setFont(Font font) {
        this.fontStr = font.getFontName() + JadxSettings.addStyleName(font.getStyle()) + "-" + font.getSize();
    }

    public String getEditorThemePath() {
        return this.editorThemePath;
    }

    public void setEditorThemePath(String editorThemePath) {
        this.editorThemePath = editorThemePath;
    }

    private static String addStyleName(int style) {
        switch (style) {
            case 1: {
                return "-BOLD";
            }
            case 0: {
                return "-PLAIN";
            }
            case 2: {
                return "-ITALIC";
            }
        }
        return "";
    }

    private void upgradeSettings(int fromVersion) {
        LOG.debug("upgrade settings from version: {} to {}", (Object)fromVersion, (Object)6);
        if (fromVersion == 0) {
            this.setDeobfuscationMinLength(3);
            this.setDeobfuscationUseSourceNameAsAlias(true);
            this.setDeobfuscationForceSave(true);
            this.setThreadsCount(1);
            this.setReplaceConsts(true);
            this.setSkipResources(false);
            this.setAutoStartJobs(false);
            ++fromVersion;
        }
        if (fromVersion == 1) {
            this.setEditorThemePath(EditorTheme.getDefaultTheme().getPath());
            ++fromVersion;
        }
        if (fromVersion == 2) {
            if (this.getDeobfuscationMinLength() == 4) {
                this.setDeobfuscationMinLength(3);
            }
            ++fromVersion;
        }
        if (fromVersion == 3) {
            this.setLangLocale(NLS.defaultLocale());
            ++fromVersion;
        }
        if (fromVersion == 4) {
            this.setUseImports(true);
            ++fromVersion;
        }
        if (fromVersion == 5) {
            this.setRespectBytecodeAccessModifiers(false);
        }
        this.settingsVersion = 6;
        this.sync();
    }
}

