/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class NameGen {
    private static final Map<String, String> OBJ_ALIAS = Utils.newConstStringMap("java.lang.String", "str", "java.lang.Class", "cls", "java.lang.Throwable", "th", "java.lang.Object", "obj", "java.util.Iterator", "it", "java.lang.Boolean", "bool", "java.lang.Short", "sh", "java.lang.Integer", "num", "java.lang.Character", "ch", "java.lang.Byte", "b", "java.lang.Float", "f", "java.lang.Long", "l", "java.lang.Double", "d");
    private final Set<String> varNames = new LinkedHashSet<String>();
    private final MethodNode mth;
    private final boolean fallback;

    public NameGen(MethodNode mth, boolean fallback) {
        this.mth = mth;
        this.fallback = fallback;
    }

    public String assignArg(RegisterArg arg) {
        String name = this.makeArgName(arg);
        if (this.fallback) {
            return name;
        }
        name = this.getUniqueVarName(name);
        arg.setName(name);
        return name;
    }

    public String assignNamedArg(NamedArg arg) {
        String name = arg.getName();
        if (this.fallback) {
            return name;
        }
        name = this.getUniqueVarName(name);
        arg.setName(name);
        return name;
    }

    public String useArg(RegisterArg arg) {
        String name = arg.getName();
        if (name == null || this.fallback) {
            return this.getFallbackName(arg);
        }
        return name;
    }

    public String getLoopLabel(LoopLabelAttr attr) {
        String name = "loop" + attr.getLoop().getId();
        this.varNames.add(name);
        return name;
    }

    private String getUniqueVarName(String name) {
        String r = name;
        int i = 2;
        while (this.varNames.contains(r)) {
            r = name + i;
            ++i;
        }
        this.varNames.add(r);
        return r;
    }

    private String makeArgName(RegisterArg arg) {
        String varName;
        if (this.fallback) {
            return this.getFallbackName(arg);
        }
        if (arg.isThis()) {
            return "this";
        }
        String name = arg.getName();
        String string = varName = name != null ? name : this.guessName(arg);
        if (NameMapper.isReserved(varName)) {
            return varName + "R";
        }
        return varName;
    }

    private String getFallbackName(RegisterArg arg) {
        return "r" + arg.getRegNum();
    }

    private String guessName(RegisterArg arg) {
        String name;
        RegisterArg assignArg;
        InsnNode assignInsn;
        SSAVar sVar = arg.getSVar();
        if (sVar != null && sVar.getName() == null && (assignInsn = (assignArg = sVar.getAssign()).getParentInsn()) != null && (name = this.makeNameFromInsn(assignInsn)) != null && !NameMapper.isReserved(name)) {
            assignArg.setName(name);
            return name;
        }
        return this.makeNameForType(arg.getType());
    }

    private String makeNameForType(ArgType type) {
        if (type.isPrimitive()) {
            return NameGen.makeNameForPrimitive(type);
        }
        if (type.isArray()) {
            return this.makeNameForType(type.getArrayRootElement()) + "Arr";
        }
        return this.makeNameForObject(type);
    }

    private static String makeNameForPrimitive(ArgType type) {
        return type.getPrimitiveType().getShortName().toLowerCase();
    }

    private String makeNameForObject(ArgType type) {
        if (type.isObject()) {
            String alias = NameGen.getAliasForObject(type.getObject());
            if (alias != null) {
                return alias;
            }
            ClassInfo extClsInfo = ClassInfo.extCls(this.mth.root(), type);
            String shortName = extClsInfo.getShortName();
            String vName = NameGen.fromName(shortName);
            if (vName != null) {
                return vName;
            }
            if (shortName != null) {
                return StringUtils.escape(shortName.toLowerCase());
            }
        }
        return StringUtils.escape(type.toString());
    }

    private static String fromName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.toUpperCase().equals(name)) {
            return name.toLowerCase();
        }
        String v1 = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        if (!v1.equals(name)) {
            return v1;
        }
        if (name.length() < 3) {
            return name + "Var";
        }
        return null;
    }

    private static String getAliasForObject(String name) {
        return OBJ_ALIAS.get(name);
    }

    private String makeNameFromInsn(InsnNode insn) {
        switch (insn.getType()) {
            case INVOKE: {
                InvokeNode inv = (InvokeNode)insn;
                return this.makeNameFromInvoke(inv.getCallMth());
            }
            case CONSTRUCTOR: {
                ConstructorInsn co = (ConstructorInsn)insn;
                return this.makeNameForObject(co.getClassType().getType());
            }
            case ARRAY_LENGTH: {
                return "length";
            }
            case ARITH: 
            case TERNARY: 
            case CAST: {
                for (InsnArg arg : insn.getArguments()) {
                    InsnNode wrapInsn;
                    String wName;
                    if (!arg.isInsnWrap() || (wName = this.makeNameFromInsn(wrapInsn = ((InsnWrapArg)arg).getWrapInsn())) == null) continue;
                    return wName;
                }
                break;
            }
        }
        return null;
    }

    private String makeNameFromInvoke(MethodInfo callMth) {
        String name = callMth.getName();
        if (name.startsWith("get") || name.startsWith("set")) {
            return NameGen.fromName(name.substring(3));
        }
        ArgType declType = callMth.getDeclClass().getAlias().getType();
        if ("iterator".equals(name)) {
            return "it";
        }
        if ("toString".equals(name)) {
            return this.makeNameForType(declType);
        }
        if ("forName".equals(name) && declType.equals(ArgType.CLASS)) {
            return OBJ_ALIAS.get("java.lang.Class");
        }
        return name;
    }
}

