/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.JadxArgs;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.core.clsp.ClspGraph;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.InfoStorage;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.StringUtils;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.DexFile;
import jadx.core.utils.files.InputFile;
import jadx.core.xmlgen.ResTableParser;
import jadx.core.xmlgen.ResourceStorage;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootNode {
    private static final Logger LOG = LoggerFactory.getLogger(RootNode.class);
    private final ErrorsCounter errorsCounter = new ErrorsCounter();
    private final JadxArgs args;
    private final StringUtils stringUtils;
    private final ConstStorage constValues;
    private final InfoStorage infoStorage = new InfoStorage();
    private ClspGraph clsp;
    private List<DexNode> dexNodes;
    @Nullable
    private String appPackage;
    @Nullable
    private ClassNode appResClass;

    public RootNode(JadxArgs args) {
        this.args = args;
        this.stringUtils = new StringUtils(args);
        this.constValues = new ConstStorage(args);
    }

    public void load(List<InputFile> inputFiles) {
        this.dexNodes = new ArrayList<DexNode>();
        for (InputFile input : inputFiles) {
            for (DexFile dexFile : input.getDexFiles()) {
                try {
                    LOG.debug("Load: {}", (Object)dexFile);
                    DexNode dexNode = new DexNode(this, dexFile, this.dexNodes.size());
                    this.dexNodes.add(dexNode);
                }
                catch (Exception e) {
                    throw new JadxRuntimeException("Error decode file: " + dexFile, e);
                }
            }
        }
        for (DexNode dexNode : this.dexNodes) {
            dexNode.loadClasses();
        }
        this.initInnerClasses();
    }

    public void loadResources(List<ResourceFile> resources) {
        ResourceFile arsc = null;
        for (ResourceFile rf : resources) {
            if (rf.getType() != ResourceType.ARSC) continue;
            arsc = rf;
            break;
        }
        if (arsc == null) {
            LOG.debug("'.arsc' file not found");
            return;
        }
        try {
            ResourceStorage resStorage = ResourcesLoader.decodeStream(arsc, (size, is) -> {
                ResTableParser parser = new ResTableParser();
                parser.decode(is);
                return parser.getResStorage();
            });
            this.processResources(resStorage);
        }
        catch (Exception e) {
            LOG.error("Failed to parse '.arsc' file", (Throwable)e);
        }
    }

    public void processResources(ResourceStorage resStorage) {
        this.constValues.setResourcesNames(resStorage.getResourcesNames());
        this.appPackage = resStorage.getAppPackage();
        this.appResClass = AndroidResourcesUtils.searchAppResClass(this, resStorage);
    }

    public void initClassPath() {
        try {
            if (this.clsp == null) {
                ClspGraph newClsp = new ClspGraph();
                newClsp.load();
                ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
                for (DexNode dexNode : this.dexNodes) {
                    classes.addAll(dexNode.getClasses());
                }
                newClsp.addApp(classes);
                this.clsp = newClsp;
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Error loading classpath", e);
        }
    }

    private void initInnerClasses() {
        for (DexNode dexNode : this.dexNodes) {
            dexNode.initInnerClasses();
        }
    }

    public List<ClassNode> getClasses(boolean includeInner) {
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
        for (DexNode dex : this.dexNodes) {
            if (includeInner) {
                classes.addAll(dex.getClasses());
                continue;
            }
            for (ClassNode cls : dex.getClasses()) {
                if (cls.getClassInfo().isInner()) continue;
                classes.add(cls);
            }
        }
        return classes;
    }

    @Nullable
    public ClassNode resolveClass(ClassInfo clsInfo) {
        for (DexNode dexNode : this.dexNodes) {
            ClassNode cls = dexNode.resolveClassLocal(clsInfo);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    @Nullable
    public ClassNode searchClassByName(String fullName) {
        ClassInfo clsInfo = ClassInfo.fromName(this, fullName);
        return this.resolveClass(clsInfo);
    }

    public List<ClassNode> searchClassByShortName(String shortName) {
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        for (DexNode dexNode : this.dexNodes) {
            for (ClassNode cls : dexNode.getClasses()) {
                if (!cls.getClassInfo().getShortName().equals(shortName)) continue;
                list.add(cls);
            }
        }
        return list;
    }

    @Nullable
    public MethodNode deepResolveMethod(@NotNull MethodInfo mth) {
        ClassNode cls = this.resolveClass(mth.getDeclClass());
        if (cls == null) {
            return null;
        }
        return cls.dex().deepResolveMethod(cls, mth.makeSignature(false));
    }

    @Nullable
    public FieldNode deepResolveField(@NotNull FieldInfo field) {
        ClassNode cls = this.resolveClass(field.getDeclClass());
        if (cls == null) {
            return null;
        }
        return cls.dex().deepResolveField(cls, field);
    }

    public List<DexNode> getDexNodes() {
        return this.dexNodes;
    }

    public ClspGraph getClsp() {
        return this.clsp;
    }

    public ErrorsCounter getErrorsCounter() {
        return this.errorsCounter;
    }

    @Nullable
    public String getAppPackage() {
        return this.appPackage;
    }

    public ClassNode getAppResClass() {
        return this.appResClass;
    }

    public StringUtils getStringUtils() {
        return this.stringUtils;
    }

    public ConstStorage getConstValues() {
        return this.constValues;
    }

    public InfoStorage getInfoStorage() {
        return this.infoStorage;
    }

    public JadxArgs getArgs() {
        return this.args;
    }
}

