/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.typeinference.PostTypeInference;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.List;

public class ConstInlineVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        ArrayList<InsnNode> toRemove = new ArrayList<InsnNode>();
        for (BlockNode block : mth.getBasicBlocks()) {
            toRemove.clear();
            for (InsnNode insn : block.getInstructions()) {
                if (!ConstInlineVisitor.checkInsn(mth, insn)) continue;
                toRemove.add(insn);
            }
            InstructionRemover.removeAll(mth, block, toRemove);
        }
    }

    private static boolean checkInsn(MethodNode mth, InsnNode insn) {
        if (insn.getType() != InsnType.CONST || insn.contains(AFlag.DONT_INLINE)) {
            return false;
        }
        InsnArg arg = insn.getArg(0);
        if (!arg.isLiteral()) {
            return false;
        }
        long lit = ((LiteralArg)arg).getLiteral();
        SSAVar sVar = insn.getResult().getSVar();
        if (lit == 0L && ConstInlineVisitor.checkObjectInline(sVar)) {
            InsnNode assignInsn;
            if (sVar.getUseCount() == 1 && (assignInsn = insn.getResult().getAssignInsn()) != null) {
                assignInsn.add(AFlag.DONT_INLINE);
            }
            return false;
        }
        ArgType resType = insn.getResult().getType();
        if (!arg.getType().isTypeKnown()) {
            arg.merge(mth.dex(), resType);
        }
        return ConstInlineVisitor.replaceConst(mth, insn, lit);
    }

    private static boolean checkObjectInline(SSAVar sVar) {
        for (RegisterArg useArg : sVar.getUseList()) {
            InvokeNode inv;
            InsnType insnType;
            InsnNode insn = useArg.getParentInsn();
            if (insn == null || !((insnType = insn.getType()) == InsnType.INVOKE ? (inv = (InvokeNode)insn).getInvokeType() != InvokeType.STATIC && inv.getArg(0) == useArg : insnType == InsnType.ARRAY_LENGTH && insn.getArg(0) == useArg)) continue;
            return true;
        }
        return false;
    }

    private static boolean replaceConst(MethodNode mth, InsnNode constInsn, long literal) {
        SSAVar sVar = constInsn.getResult().getSVar();
        ArrayList<RegisterArg> use = new ArrayList<RegisterArg>(sVar.getUseList());
        int replaceCount = 0;
        for (RegisterArg arg : use) {
            LiteralArg litArg;
            InsnNode useInsn = arg.getParentInsn();
            if (useInsn == null || useInsn.getType() == InsnType.PHI || useInsn.getType() == InsnType.MERGE) continue;
            ArgType argType = arg.getType();
            if (argType.isObject() && literal != 0L) {
                argType = ArgType.NARROW_NUMBERS;
            }
            if (!useInsn.replaceArg(arg, litArg = use.size() == 1 || arg.isTypeImmutable() ? InsnArg.lit(literal, argType) : (useInsn.getType() == InsnType.MOVE && !useInsn.getResult().getType().isTypeKnown() ? InsnArg.lit(literal, argType) : InsnArg.lit(literal, ArgType.UNKNOWN)))) continue;
            ConstInlineVisitor.fixTypes(mth, useInsn, litArg);
            ++replaceCount;
            if (useInsn.getType() == InsnType.RETURN) {
                useInsn.setSourceLine(constInsn.getSourceLine());
            }
            FieldNode f = null;
            ArgType litArgType = litArg.getType();
            if (litArgType.isTypeKnown()) {
                f = mth.getParentClass().getConstFieldByLiteralArg(litArg);
            } else if (litArgType.contains(PrimitiveType.INT)) {
                f = mth.getParentClass().getConstField((int)literal, false);
            }
            if (f == null) continue;
            litArg.wrapInstruction(new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0));
        }
        return replaceCount == use.size();
    }

    private static void fixTypes(MethodNode mth, InsnNode insn, LiteralArg litArg) {
        DexNode dex = mth.dex();
        PostTypeInference.process(mth, insn);
        switch (insn.getType()) {
            case CONST: {
                insn.getArg(0).merge(dex, insn.getResult());
                break;
            }
            case MOVE: {
                insn.getResult().merge(dex, insn.getArg(0));
                insn.getArg(0).merge(dex, insn.getResult());
                break;
            }
            case IPUT: 
            case SPUT: {
                IndexInsnNode node = (IndexInsnNode)insn;
                insn.getArg(0).merge(dex, ((FieldInfo)node.getIndex()).getType());
                break;
            }
            case IF: {
                InsnArg firstArg = insn.getArg(0);
                InsnArg secondArg = insn.getArg(1);
                if (firstArg == litArg) {
                    firstArg.merge(dex, secondArg);
                    break;
                }
                secondArg.merge(dex, firstArg);
                break;
            }
            case CMP_G: 
            case CMP_L: {
                InsnArg arg0 = insn.getArg(0);
                InsnArg arg1 = insn.getArg(1);
                if (arg0 == litArg) {
                    arg0.merge(dex, arg1);
                    break;
                }
                arg1.merge(dex, arg0);
                break;
            }
            case RETURN: {
                if (insn.getArgsCount() == 0) break;
                insn.getArg(0).merge(dex, mth.getReturnType());
                break;
            }
            case INVOKE: {
                InvokeNode inv = (InvokeNode)insn;
                List<ArgType> types = inv.getCallMth().getArgumentsTypes();
                int count = insn.getArgsCount();
                int k = types.size() == count ? 0 : -1;
                for (int i = 0; i < count; ++i) {
                    InsnArg arg = insn.getArg(i);
                    if (!arg.getType().isTypeKnown()) {
                        ArgType type = k >= 0 ? types.get(k) : mth.getParentClass().getClassInfo().getType();
                        arg.merge(dex, type);
                    }
                    ++k;
                }
                break;
            }
            case ARITH: {
                litArg.merge(dex, insn.getResult());
                break;
            }
            case APUT: 
            case AGET: {
                if (litArg != insn.getArg(1)) break;
                litArg.merge(dex, ArgType.INT);
                break;
            }
            case NEW_ARRAY: {
                if (litArg != insn.getArg(0)) break;
                litArg.merge(dex, ArgType.INT);
                break;
            }
        }
    }
}

