/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.args.VarName;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;

public class TypeInference
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        TypeInference.fixPhiVarNames(mth);
        DexNode dex = mth.dex();
        for (SSAVar var : mth.getSVars()) {
            ArgType type = TypeInference.processType(dex, var);
            if (type == null) {
                type = ArgType.UNKNOWN;
            }
            var.setType(type);
            String name = TypeInference.processVarName(var);
            var.setName(name);
        }
        for (SSAVar sVar : mth.getSVars()) {
            PhiInsn phi = sVar.getUsedInPhi();
            if (phi == null) continue;
            TypeInference.processPhiNode(phi);
        }
    }

    private static ArgType processType(DexNode dex, SSAVar var) {
        RegisterArg assign = var.getAssign();
        List<RegisterArg> useList = var.getUseList();
        if (useList.isEmpty() || var.isTypeImmutable()) {
            return assign.getType();
        }
        ArgType type = assign.getType();
        for (RegisterArg arg : useList) {
            ArgType newType;
            ArgType useType = arg.getType();
            if (type.isTypeKnown() && useType.isTypeKnown() || (newType = ArgType.merge(dex, type, useType)) == null) continue;
            type = newType;
        }
        return type;
    }

    private static void processPhiNode(PhiInsn phi) {
        ArgType type = phi.getResult().getType();
        if (!type.isTypeKnown()) {
            for (InsnArg arg : phi.getArguments()) {
                if (!arg.getType().isTypeKnown()) continue;
                type = arg.getType();
                break;
            }
        }
        phi.getResult().setType(type);
        for (int i = 0; i < phi.getArgsCount(); ++i) {
            InsnArg arg;
            arg = phi.getArg(i);
            ((RegisterArg)arg).setType(type);
            SSAVar sVar = ((RegisterArg)arg).getSVar();
            if (sVar == null) continue;
            sVar.setName(phi.getResult().getName());
        }
    }

    private static void fixPhiVarNames(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null) continue;
            for (PhiInsn phiInsn : phiList.getList()) {
                RegisterArg resArg = phiInsn.getResult();
                int argsCount = phiInsn.getArgsCount();
                for (int i = 0; i < argsCount; ++i) {
                    RegisterArg arg = phiInsn.getArg(i);
                    arg.mergeName(resArg);
                }
                VarName varName = resArg.getSVar().getVarName();
                if (varName == null) {
                    varName = new VarName();
                    resArg.getSVar().setVarName(varName);
                }
                for (int i = 0; i < argsCount; ++i) {
                    RegisterArg arg = phiInsn.getArg(i);
                    arg.getSVar().setVarName(varName);
                }
            }
        }
    }

    private static String processVarName(SSAVar var) {
        String name = var.getAssign().getName();
        if (name != null) {
            return name;
        }
        for (RegisterArg arg : var.getUseList()) {
            String vName = arg.getName();
            if (vName == null) continue;
            return vName;
        }
        return null;
    }
}

