/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.JadxDecompiler;
import jadx.core.codegen.CodeWriter;
import jadx.core.utils.ImmutableList;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Utils {
    public static final String JADX_API_PACKAGE = JadxDecompiler.class.getPackage().getName();

    private Utils() {
    }

    public static String cleanObjectName(String obj) {
        int last = obj.length() - 1;
        if (obj.charAt(0) == 'L' && obj.charAt(last) == ';') {
            return obj.substring(1, last).replace('/', '.');
        }
        return obj;
    }

    public static String makeQualifiedObjectName(String obj) {
        return 'L' + obj.replace('.', '/') + ';';
    }

    public static String listToString(Iterable<?> objects) {
        return Utils.listToString(objects, ", ");
    }

    public static String listToString(Iterable<?> objects, String joiner) {
        if (objects == null) {
            return "";
        }
        return Utils.listToString(objects, joiner, Object::toString);
    }

    public static <T> String listToString(Iterable<T> objects, Function<T, String> toStr) {
        return Utils.listToString(objects, ", ", toStr);
    }

    public static <T> String listToString(Iterable<T> objects, String joiner, Function<T, String> toStr) {
        StringBuilder sb = new StringBuilder();
        Utils.listToString(sb, objects, joiner, toStr);
        return sb.toString();
    }

    public static <T> void listToString(StringBuilder sb, Iterable<T> objects, String joiner, Function<T, String> toStr) {
        if (objects == null) {
            return;
        }
        Iterator<T> it = objects.iterator();
        if (it.hasNext()) {
            sb.append(toStr.apply(it.next()));
        }
        while (it.hasNext()) {
            sb.append(joiner).append(toStr.apply(it.next()));
        }
    }

    public static String arrayToString(Object[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Utils.filterRecursive(throwable);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static void appendStackTrace(final CodeWriter code, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        code.startLine();
        OutputStream w = new OutputStream(){

            @Override
            public void write(int b) {
                char c = (char)b;
                switch (c) {
                    case '\n': {
                        code.startLine();
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    default: {
                        code.add(c);
                    }
                }
            }
        };
        try (PrintWriter pw = new PrintWriter(w, true);){
            Utils.filterRecursive(throwable);
            throwable.printStackTrace(pw);
            pw.flush();
        }
    }

    private static void filterRecursive(Throwable th) {
        try {
            Utils.filter(th);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable cause = th.getCause();
        if (cause != null) {
            Utils.filterRecursive(cause);
        }
    }

    private static void filter(Throwable th) {
        StackTraceElement[] stackTrace = th.getStackTrace();
        int cutIndex = -1;
        int length = stackTrace.length;
        for (int i = 0; i < length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (stackTraceElement.getClassName().startsWith(JADX_API_PACKAGE)) {
                cutIndex = i;
                continue;
            }
            if (cutIndex <= 0) continue;
            cutIndex = i;
            break;
        }
        if (cutIndex > 0 && cutIndex < length) {
            th.setStackTrace(Arrays.copyOfRange(stackTrace, 0, cutIndex));
        }
    }

    public static <T> List<T> lockList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new ImmutableList<T>(list);
    }

    public static Map<String, String> newConstStringMap(String ... parameters) {
        int len = parameters.length;
        if (len == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(len / 2);
        for (int i = 0; i < len; i += 2) {
            result.put(parameters[i], parameters[i + 1]);
        }
        return Collections.unmodifiableMap(result);
    }
}

