/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.codegen.CodeWriter;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.entry.EntryConfig;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResTableParser
extends CommonBinaryParser {
    private static final Logger LOG = LoggerFactory.getLogger(ResTableParser.class);
    private String[] strings;
    private final ResourceStorage resStorage = new ResourceStorage();

    public void decode(InputStream inputStream) throws IOException {
        this.is = new ParserStream(inputStream);
        this.decodeTableChunk();
        this.resStorage.finish();
    }

    public ResContainer decodeFiles(InputStream inputStream) throws IOException {
        this.decode(inputStream);
        ValuesParser vp = new ValuesParser(this.strings, this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp);
        CodeWriter content = this.makeXmlDump();
        List<ResContainer> xmlFiles = resGen.makeResourcesXml();
        return ResContainer.resourceTable("res", xmlFiles, content);
    }

    public CodeWriter makeXmlDump() {
        CodeWriter writer = new CodeWriter();
        writer.startLine("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.startLine("<resources>");
        writer.incIndent();
        HashSet<String> addedValues = new HashSet<String>();
        for (ResourceEntry ri : this.resStorage.getResources()) {
            if (!addedValues.add(ri.getTypeName() + "." + ri.getKeyName())) continue;
            String format = String.format("<public type=\"%s\" name=\"%s\" id=\"%s\" />", ri.getTypeName(), ri.getKeyName(), ri.getId());
            writer.startLine(format);
        }
        writer.decIndent();
        writer.startLine("</resources>");
        writer.finish();
        return writer;
    }

    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    public String[] getStrings() {
        return this.strings;
    }

    void decodeTableChunk() throws IOException {
        this.is.checkInt16(2, "Not a table chunk");
        this.is.checkInt16(12, "Unexpected table header size");
        this.is.readInt32();
        int pkgCount = this.is.readInt32();
        this.strings = this.parseStringPool();
        for (int i = 0; i < pkgCount; ++i) {
            this.parsePackage();
        }
    }

    private PackageChunk parsePackage() throws IOException {
        long start = this.is.getPos();
        this.is.checkInt16(512, "Not a table chunk");
        int headerSize = this.is.readInt16();
        if (headerSize != 284 && headerSize != 288) {
            this.die("Unexpected package header size");
        }
        long size = this.is.readUInt32();
        long endPos = start + size;
        int id = this.is.readInt32();
        String name = this.is.readString16Fixed(128);
        long typeStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        long keyStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        if (headerSize == 288) {
            this.is.readInt32();
        }
        String[] typeStrings = null;
        if (typeStringsOffset != 0L) {
            this.is.skipToPos(typeStringsOffset, "Expected typeStrings string pool");
            typeStrings = this.parseStringPool();
        }
        String[] keyStrings = null;
        if (keyStringsOffset != 0L) {
            this.is.skipToPos(keyStringsOffset, "Expected keyStrings string pool");
            keyStrings = this.parseStringPool();
        }
        PackageChunk pkg = new PackageChunk(id, name, typeStrings, keyStrings);
        this.resStorage.setAppPackage(name);
        while (this.is.getPos() < endPos) {
            long chunkStart = this.is.getPos();
            int type = this.is.readInt16();
            if (type == 0) continue;
            if (type == 514) {
                this.parseTypeSpecChunk();
                continue;
            }
            if (type != 513) continue;
            this.parseTypeChunk(chunkStart, pkg);
        }
        return pkg;
    }

    private void parseTypeSpecChunk() throws IOException {
        this.is.checkInt16(16, "Unexpected type spec header size");
        this.is.readInt32();
        int id = this.is.readInt8();
        this.is.skip(3L);
        int entryCount = this.is.readInt32();
        for (int i = 0; i < entryCount; ++i) {
            int n = this.is.readInt32();
        }
    }

    private void parseTypeChunk(long start, PackageChunk pkg) throws IOException {
        int i;
        this.is.readInt16();
        this.is.readInt32();
        int id = this.is.readInt8();
        this.is.checkInt8(0, "type chunk, res0");
        this.is.checkInt16(0, "type chunk, res1");
        int entryCount = this.is.readInt32();
        long entriesStart = start + (long)this.is.readInt32();
        EntryConfig config = this.parseConfig();
        int[] entryIndexes = new int[entryCount];
        for (i = 0; i < entryCount; ++i) {
            entryIndexes[i] = this.is.readInt32();
        }
        this.is.checkPos(entriesStart, "Expected entry start");
        for (i = 0; i < entryCount; ++i) {
            if (entryIndexes[i] == -1) continue;
            this.parseEntry(pkg, id, i, config);
        }
    }

    private void parseEntry(PackageChunk pkg, int typeId, int entryId, EntryConfig config) throws IOException {
        this.is.readInt16();
        int flags = this.is.readInt16();
        int key = this.is.readInt32();
        int resRef = pkg.getId() << 24 | typeId << 16 | entryId;
        String typeName = pkg.getTypeStrings()[typeId - 1];
        String keyName = pkg.getKeyStrings()[key];
        ResourceEntry ri = new ResourceEntry(resRef, pkg.getName(), typeName, keyName);
        ri.setConfig(config);
        if ((flags & 1) == 0) {
            ri.setSimpleValue(this.parseValue());
        } else {
            int parentRef = this.is.readInt32();
            ri.setParentRef(parentRef);
            int count = this.is.readInt32();
            ArrayList<RawNamedValue> values = new ArrayList<RawNamedValue>(count);
            for (int i = 0; i < count; ++i) {
                values.add(this.parseValueMap());
            }
            ri.setNamedValues(values);
        }
        this.resStorage.add(ri);
    }

    private RawNamedValue parseValueMap() throws IOException {
        int nameRef = this.is.readInt32();
        return new RawNamedValue(nameRef, this.parseValue());
    }

    private RawValue parseValue() throws IOException {
        this.is.checkInt16(8, "value size");
        this.is.checkInt8(0, "value res0 not 0");
        int dataType = this.is.readInt8();
        int data = this.is.readInt32();
        return new RawValue(dataType, data);
    }

    private EntryConfig parseConfig() throws IOException {
        int sdkVersion;
        long start = this.is.getPos();
        int size = this.is.readInt32();
        EntryConfig config = new EntryConfig();
        this.is.readInt16();
        this.is.readInt16();
        config.setLanguage(this.parseLocale());
        config.setCountry(this.parseLocale());
        int orientation = this.is.readInt8();
        int touchscreen = this.is.readInt8();
        int density = this.is.readInt16();
        if (density != 0) {
            config.setDensity(this.parseDensity(density));
        }
        this.is.readInt8();
        this.is.readInt8();
        this.is.readInt8();
        this.is.readInt8();
        int screenWidth = this.is.readInt16();
        int screenHeight = this.is.readInt16();
        if (screenWidth != 0 && screenHeight != 0) {
            config.setScreenSize(screenWidth + "x" + screenHeight);
        }
        if ((sdkVersion = this.is.readInt16()) != 0) {
            config.setSdkVersion("v" + sdkVersion);
        }
        int minorVersion = this.is.readInt16();
        int screenLayout = this.is.readInt8();
        int uiMode = this.is.readInt8();
        int smallestScreenWidthDp = this.is.readInt16();
        int screenWidthDp = this.is.readInt16();
        int screenHeightDp = this.is.readInt16();
        if (screenLayout != 0) {
            config.setScreenLayout(this.parseScreenLayout(screenLayout));
        }
        if (smallestScreenWidthDp != 0) {
            config.setSmallestScreenWidthDp("sw" + smallestScreenWidthDp + "dp");
        }
        if (orientation != 0) {
            config.setOrientation(this.parseOrientation(orientation));
        }
        if (screenWidthDp != 0) {
            config.setScreenWidthDp("w" + screenWidthDp + "dp");
        }
        if (screenHeightDp != 0) {
            config.setScreenHeightDp("h" + screenHeightDp + "dp");
        }
        this.is.skipToPos(start + (long)size, "Skip config parsing");
        return config;
    }

    private String parseOrientation(int orientation) {
        if (orientation == 1) {
            return "port";
        }
        if (orientation == 2) {
            return "land";
        }
        return "o" + orientation;
    }

    private String parseScreenLayout(int screenLayout) {
        switch (screenLayout) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
            case 64: {
                return "ldltr";
            }
            case 128: {
                return "ldrtl";
            }
        }
        return "sl" + screenLayout;
    }

    private String parseDensity(int density) {
        if (density == 120) {
            return "ldpi";
        }
        if (density == 160) {
            return "mdpi";
        }
        if (density == 240) {
            return "hdpi";
        }
        if (density == 320) {
            return "xhdpi";
        }
        if (density == 480) {
            return "xxhdpi";
        }
        if (density == 640) {
            return "xxxhdpi";
        }
        return density + "dpi";
    }

    private String parseLocale() throws IOException {
        int b1 = this.is.readInt8();
        int b2 = this.is.readInt8();
        String str = null;
        if (b1 != 0 && b2 != 0) {
            if ((b1 & 0x80) == 0) {
                str = new String(new char[]{(char)b1, (char)b2});
            } else {
                LOG.warn("TODO: parse locale: 0x{}{}", (Object)Integer.toHexString(b1), (Object)Integer.toHexString(b2));
            }
        }
        return str;
    }

    private static final class PackageChunk {
        private final int id;
        private final String name;
        private final String[] typeStrings;
        private final String[] keyStrings;

        private PackageChunk(int id, String name, String[] typeStrings, String[] keyStrings) {
            this.id = id;
            this.name = name;
            this.typeStrings = typeStrings;
            this.keyStrings = keyStrings;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getTypeStrings() {
            return this.typeStrings;
        }

        public String[] getKeyStrings() {
            return this.keyStrings;
        }
    }
}

