/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipFile;
import lucee.commons.io.res.Resource;
import lucee.commons.io.res.filter.ResourceFilter;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.runtime.exp.PageException;
import org.osgi.framework.Version;

public class Util {
    private static File tempFile;
    private static final int QUALIFIER_APPENDIX_SNAPSHOT = 1;
    private static final int QUALIFIER_APPENDIX_BETA = 2;
    private static final int QUALIFIER_APPENDIX_RC = 3;
    private static final int QUALIFIER_APPENDIX_OTHER = 4;
    private static final int QUALIFIER_APPENDIX_STABLE = 5;
    private static final SimpleDateFormat HTTP_TIME_STRING_FORMAT;

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        Util.closeEL(in);
        Util.closeEL(out);
    }

    public static final void copy(InputStream in, OutputStream out, boolean closeIS, boolean closeOS) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        if (closeIS) {
            Util.closeEL(in);
        }
        if (closeOS) {
            Util.closeEL(out);
        }
    }

    public static String toString(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer content = new StringBuffer();
        String line = br.readLine();
        if (line != null) {
            content.append(line);
            while ((line = br.readLine()) != null) {
                content.append("\n" + line);
            }
        }
        br.close();
        return content.toString();
    }

    public static boolean toBooleanValue(String str) throws IOException {
        if ("true".equals(str = str.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        if ("yes".equals(str)) {
            return true;
        }
        if ("no".equals(str)) {
            return false;
        }
        throw new IOException("can't cast string to a boolean value");
    }

    public static void closeEL(InputStream is, OutputStream os) {
        Util.closeEL(is);
        Util.closeEL(os);
    }

    public static void closeEL(ZipFile zf) {
        try {
            if (zf != null) {
                zf.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getContentAsString(InputStream is, String charset) throws IOException, PageException {
        BufferedReader br = charset == null ? new BufferedReader(new InputStreamReader(is)) : new BufferedReader(new InputStreamReader(is, charset));
        StringBuffer content = new StringBuffer();
        String line = br.readLine();
        if (line != null) {
            content.append(line);
            while ((line = br.readLine()) != null) {
                content.append("\n" + line);
            }
        }
        br.close();
        return content.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(String str, boolean trim) {
        if (!trim) {
            return Util.isEmpty(str);
        }
        return str == null || str.trim().length() == 0;
    }

    public static int length(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static String replace(String str, String sub1, String sub2, boolean onlyFirst) {
        int pos;
        if (sub1.equals(sub2)) {
            return str;
        }
        if (!onlyFirst && sub1.length() == 1 && sub2.length() == 1) {
            return str.replace(sub1.charAt(0), sub2.charAt(0));
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int sub1Length = sub1.length();
        while ((pos = str.indexOf(sub1, start)) != -1) {
            sb.append(str.substring(start, pos));
            sb.append(sub2);
            start = pos + sub1Length;
            if (!onlyFirst) continue;
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String parsePlaceHolder(String path) {
        return CFMLEngineFactory.getInstance().getResourceUtil().parsePlaceHolder(path);
    }

    public static File getTempDirectory() {
        if (tempFile != null) {
            return tempFile;
        }
        String tmpStr = System.getProperty("java.io.tmpdir");
        if (tmpStr != null && (tempFile = new File(tmpStr)).exists()) {
            tempFile = Util.getCanonicalFileEL(tempFile);
            return tempFile;
        }
        try {
            File tmp = File.createTempFile("a", "a");
            tempFile = tmp.getParentFile();
            tempFile = Util.getCanonicalFileEL(tempFile);
            tmp.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempFile;
    }

    public static File getHomeDirectory() {
        return (File)((Object)CFMLEngineFactory.getInstance().getResourceUtil().getHomeDirectory());
    }

    public static File getSystemDirectory() {
        return (File)((Object)CFMLEngineFactory.getInstance().getResourceUtil().getSystemDirectory());
    }

    public static File getCanonicalFileEL(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static String toHTTPTimeString(Date date) {
        return Util.replace(HTTP_TIME_STRING_FORMAT.format(date), "+00:00", "", true);
    }

    public static String toHTTPTimeString() {
        return Util.replace(HTTP_TIME_STRING_FORMAT.format(new Date()), "+00:00", "", true);
    }

    public static boolean hasUpperCase(String str) {
        if (Util.isEmpty(str)) {
            return false;
        }
        return !str.equals(str.toLowerCase());
    }

    public static BufferedInputStream toBufferedInputStream(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return (BufferedInputStream)is;
        }
        return new BufferedInputStream(is);
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return (BufferedOutputStream)os;
        }
        return new BufferedOutputStream(os);
    }

    public static void copy(Resource in, Resource out) throws IOException {
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = Util.toBufferedInputStream(in.getInputStream());
            os = Util.toBufferedOutputStream(out.getOutputStream());
        }
        catch (IOException ioe) {
            Util.closeEL(os);
            Util.closeEL(is);
            throw ioe;
        }
        Util.copy(is, os);
    }

    public static String toVariableName(String str, boolean addIdentityNumber) {
        return CFMLEngineFactory.getInstance().getStringUtil().toVariableName(str, addIdentityNumber, false);
    }

    public static String first(String str, String delimiter) {
        return CFMLEngineFactory.getInstance().getStringUtil().first(str, delimiter, true);
    }

    public static String last(String str, String delimiter) {
        return CFMLEngineFactory.getInstance().getStringUtil().last(str, delimiter, true);
    }

    public static String removeQuotes(String str, boolean trim) {
        return CFMLEngineFactory.getInstance().getStringUtil().removeQuotes(str, trim);
    }

    public static void delete(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Util.delete(c);
            }
        }
        f.delete();
    }

    public static boolean isNewerThan(Version left, Version right) {
        int qran;
        int qr;
        if (left.getMajor() > right.getMajor()) {
            return true;
        }
        if (left.getMajor() < right.getMajor()) {
            return false;
        }
        if (left.getMinor() > right.getMinor()) {
            return true;
        }
        if (left.getMinor() < right.getMinor()) {
            return false;
        }
        if (left.getMicro() > right.getMicro()) {
            return true;
        }
        if (left.getMicro() < right.getMicro()) {
            return false;
        }
        String q = left.getQualifier();
        int index = q.indexOf(45);
        String qla = index == -1 ? "" : q.substring(index + 1).trim();
        String qln = index == -1 ? q : q.substring(0, index);
        int ql = Util.isEmpty(qln) ? Integer.MIN_VALUE : Integer.parseInt(qln);
        q = right.getQualifier();
        index = q.indexOf(45);
        String qra = index == -1 ? "" : q.substring(index + 1).trim();
        String qrn = index == -1 ? q : q.substring(0, index);
        int n = qr = Util.isEmpty(qln) ? Integer.MIN_VALUE : Integer.parseInt(qrn);
        if (ql > qr) {
            return true;
        }
        if (ql < qr) {
            return false;
        }
        int qlan = Util.qualifierAppendix2Number(qla);
        if (qlan > (qran = Util.qualifierAppendix2Number(qra))) {
            return true;
        }
        if (qlan < qran) {
            return false;
        }
        if (qlan == 4 && qran == 4) {
            return left.compareTo(right) > 0;
        }
        return false;
    }

    private static int qualifierAppendix2Number(String str) {
        if (Util.isEmpty(str, true)) {
            return 5;
        }
        if ("SNAPSHOT".equalsIgnoreCase(str)) {
            return 1;
        }
        if ("BETA".equalsIgnoreCase(str)) {
            return 2;
        }
        if ("RC".equalsIgnoreCase(str)) {
            return 3;
        }
        return 4;
    }

    public static void deleteContent(Resource src, ResourceFilter filter) {
        Util._deleteContent(src, filter, false);
    }

    public static void _deleteContent(Resource src, ResourceFilter filter, boolean deleteDirectories) {
        if (src.isDirectory()) {
            Resource[] files = filter == null ? src.listResources() : src.listResources(filter);
            for (int i = 0; i < files.length; ++i) {
                Util._deleteContent(files[i], filter, true);
                if (!deleteDirectories) continue;
                try {
                    src.remove(false);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else if (src.isFile()) {
            src.delete();
        }
    }

    public static void deleteContent(File src, FileFilter filter) {
        Util._deleteContent(src, filter, false);
    }

    public static void _deleteContent(File src, FileFilter filter, boolean deleteDirectories) {
        if (src.isDirectory()) {
            File[] files = filter == null ? src.listFiles() : src.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                Util._deleteContent(files[i], filter, true);
                if (!deleteDirectories) continue;
                src.delete();
            }
        } else if (src.isFile()) {
            src.delete();
        }
    }

    static {
        HTTP_TIME_STRING_FORMAT = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss zz", Locale.ENGLISH);
        HTTP_TIME_STRING_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

