/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.util.SpringBeansUIs;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class BeansRefHyperlinkProcessor
extends HyperlinkProcessor {
    private boolean globalSearch;

    public BeansRefHyperlinkProcessor(boolean globalSearch) {
        this.globalSearch = globalSearch;
    }

    @Override
    public void process(HyperlinkEnv env) {
        final FileObject fileObject = env.getFileObject();
        if (fileObject == null) {
            return;
        }
        SpringConfigModel model = SpringConfigModel.forFileObject(fileObject);
        if (model == null) {
            return;
        }
        final String beanName = this.getBeanName(env);
        final SpringBeansUIs.GoToBeanAction[] action = new SpringBeansUIs.GoToBeanAction[]{null};
        try {
            model.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans beans) {
                    SpringBean bean = BeansRefHyperlinkProcessor.this.globalSearch ? beans.findBean(beanName) : beans.getFileBeans(fileObject).findBeanByID(beanName);
                    if (bean == null) {
                        return;
                    }
                    action[0] = SpringBeansUIs.createGoToBeanAction(bean);
                }
            });
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (action[0] != null) {
            action[0].invoke();
        }
    }

    private String getBeanName(HyperlinkEnv env) {
        int[] beanOffsets = this.getBeanOffsets(env);
        return env.getValueString().substring(beanOffsets[0], beanOffsets[1]);
    }

    private int[] getBeanOffsets(HyperlinkEnv env) {
        String valueString = env.getValueString();
        int tokStartIdx = env.getTokenStartOffset() + 1;
        int relOffset = env.getOffset() - tokStartIdx;
        int startPos = Math.max(0, StringUtils.lastIndexOfAnyDelimiter(valueString, 0, relOffset, ",; ") + 1);
        int endPos = StringUtils.indexOfAnyDelimiter(valueString, relOffset, ",; ");
        if (endPos == -1) {
            endPos = valueString.length();
        }
        return new int[]{startPos, endPos};
    }

    @Override
    public int[] getSpan(HyperlinkEnv env) {
        int[] beanOffsets = this.getBeanOffsets(env);
        if (!StringUtils.hasText(env.getValueString())) {
            return new int[]{-1, -1};
        }
        int tokStartIdx = env.getTokenStartOffset() + 1;
        return new int[]{tokStartIdx + beanOffsets[0], tokStartIdx + beanOffsets[1]};
    }
}

