/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.options;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.commands.PHPStan;
import org.netbeans.modules.php.analysis.options.Bundle;
import org.netbeans.modules.php.analysis.options.ValidatorPHPStanParameter;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;

public final class AnalysisOptionsValidator {
    private static final Pattern PHPSTAN_MEMORY_LIMIT_PATTERN = Pattern.compile("^\\-?\\d+[kmg]?$", 2);
    private final ValidationResult result = new ValidationResult();

    public AnalysisOptionsValidator validateCodeSniffer(String codeSnifferPath, String codeSnifferStandard) {
        this.validateCodeSnifferPath(codeSnifferPath);
        this.validateCodeSnifferStandard(codeSnifferStandard);
        return this;
    }

    public AnalysisOptionsValidator validateMessDetector(String messDetectorPath, List<String> messDetectorRuleSets) {
        this.validateMessDetectorPath(messDetectorPath);
        this.validateMessDetectorRuleSets(messDetectorRuleSets);
        return this;
    }

    public AnalysisOptionsValidator validateCodingStandardsFixer(String codingStandardsFixerPath) {
        this.validateCodingStandardsFixerPath(codingStandardsFixerPath);
        return this;
    }

    public AnalysisOptionsValidator validatePHPStan(ValidatorPHPStanParameter param) {
        this.validatePHPStanPath(param.getPHPStanPath());
        this.validatePHPStanConfiguration(param.getConfiguration());
        this.validatePHPStanMemoryLimit(param.getMemoryLimit());
        return this;
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public AnalysisOptionsValidator validateCodeSnifferPath(String codeSnifferPath) {
        String warning = CodeSniffer.validate(codeSnifferPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"codeSniffer.path", warning));
        }
        return this;
    }

    public AnalysisOptionsValidator validateCodeSnifferStandard(String codeSnifferStandard) {
        if (!StringUtils.hasText((String)codeSnifferStandard)) {
            this.result.addWarning(new ValidationResult.Message((Object)"codeSniffer.standard", Bundle.AnalysisOptionsValidator_codeSniffer_standard_empty()));
        }
        return this;
    }

    private AnalysisOptionsValidator validateMessDetectorPath(String messDetectorPath) {
        String warning = MessDetector.validate(messDetectorPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"messDetector.path", warning));
        }
        return this;
    }

    public AnalysisOptionsValidator validateMessDetectorRuleSets(List<String> messDetectorRuleSets) {
        if (messDetectorRuleSets.isEmpty()) {
            this.result.addWarning(new ValidationResult.Message((Object)"messDetector.ruleSets", Bundle.AnalysisOptionsValidator_messDetector_ruleSets_empty()));
        }
        return this;
    }

    private AnalysisOptionsValidator validateCodingStandardsFixerPath(String codingStandardsFixerPath) {
        String warning = CodingStandardsFixer.validate(codingStandardsFixerPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"codingStandardsFixer.path", warning));
        }
        return this;
    }

    private AnalysisOptionsValidator validatePHPStanPath(String phpStanPath) {
        String warning;
        if (phpStanPath != null && (warning = PHPStan.validate(phpStanPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"phpStan.path", warning));
        }
        return this;
    }

    private AnalysisOptionsValidator validatePHPStanConfiguration(String configuration) {
        String warning;
        if (!StringUtils.isEmpty((String)configuration) && (warning = FileUtils.validateFile((String)"Configuration file", (String)configuration, (boolean)false)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"phpStan.configuration", warning));
        }
        return this;
    }

    private AnalysisOptionsValidator validatePHPStanMemoryLimit(String memoryLimit) {
        Matcher matcher;
        if (!StringUtils.isEmpty((String)memoryLimit) && !(matcher = PHPSTAN_MEMORY_LIMIT_PATTERN.matcher(memoryLimit)).matches()) {
            this.result.addWarning(new ValidationResult.Message((Object)"phpStan.memory.limit", Bundle.AnalysisOptionsValidator_phpStan_memory_limit_invalid()));
        }
        return this;
    }
}

