/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications;

import java.awt.event.ActionListener;
import java.io.CharConversionException;
import java.util.Calendar;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;

public final class NotificationDisplayerImpl
extends NotificationDisplayer {
    private final NotificationCenterManager notificationCenter = NotificationCenterManager.getInstance();

    public static NotificationDisplayerImpl getInstance() {
        return (NotificationDisplayerImpl)((Object)Lookup.getDefault().lookup(NotificationDisplayerImpl.class));
    }

    public Notification notify(String title, Icon icon, String detailsText, ActionListener detailsAction, NotificationDisplayer.Priority priority) {
        return this.notify(title, icon, detailsText, detailsAction, priority, NotificationDisplayer.Category.INFO);
    }

    public Notification notify(String title, Icon icon, String detailsText, ActionListener detailsAction, NotificationDisplayer.Priority priority, NotificationDisplayer.Category category) {
        Parameters.notNull((CharSequence)"detailsText", (Object)detailsText);
        NotificationImpl n = this.createNotification(title, icon, priority, category);
        n.setDetails(detailsText, detailsAction);
        this.add(n);
        return n;
    }

    public Notification notify(String title, Icon icon, JComponent balloonDetails, JComponent popupDetails, NotificationDisplayer.Priority priority) {
        return this.notify(title, icon, balloonDetails, popupDetails, priority, NotificationDisplayer.Category.INFO);
    }

    public Notification notify(String title, Icon icon, JComponent balloonDetails, JComponent popupDetails, NotificationDisplayer.Priority priority, NotificationDisplayer.Category category) {
        Parameters.notNull((CharSequence)"balloonDetails", (Object)balloonDetails);
        Parameters.notNull((CharSequence)"popupDetails", (Object)popupDetails);
        NotificationImpl n = this.createNotification(title, icon, priority, category);
        n.setDetails(balloonDetails, popupDetails);
        this.add(n);
        return n;
    }

    private void add(NotificationImpl n) {
        this.notificationCenter.add(n);
    }

    private NotificationImpl createNotification(String title, Icon icon, NotificationDisplayer.Priority priority, NotificationDisplayer.Category category) {
        Parameters.notNull((CharSequence)"title", (Object)title);
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        Parameters.notNull((CharSequence)"priority", (Object)priority);
        Parameters.notNull((CharSequence)"category", (Object)category);
        try {
            title = XMLUtil.toElementContent((String)title);
        }
        catch (CharConversionException ex) {
            throw new IllegalArgumentException(ex);
        }
        return new NotificationImpl(title, icon, priority, category, Calendar.getInstance());
    }
}

