/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.phpdoc.PhpDocumentorProvider;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferences;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class PhpDocPanel
extends JPanel {
    private static final long serialVersionUID = -4686321547613435L;
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton targetButton;
    private JLabel targetLabel;
    private JTextField targetTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;

    PhpDocPanel(PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.targetTextField.setText(PhpDocPreferences.getPhpDocTarget(this.phpModule, false));
        this.titleTextField.setText(PhpDocPreferences.getPhpDocTitle(this.phpModule));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.targetTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.titleTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private String getPhpDocTarget() {
        return this.targetTextField.getText().trim();
    }

    private String getPhpDocTitle() {
        return this.titleTextField.getText().trim();
    }

    boolean isValidData() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        String error;
        String phpDocTarget = this.getPhpDocTarget();
        if (StringUtils.hasText((String)phpDocTarget) && (error = FileUtils.validateDirectory((String)phpDocTarget, (boolean)true)) != null) {
            return error;
        }
        if (!StringUtils.hasText((String)this.getPhpDocTitle())) {
            return NbBundle.getMessage(PhpDocPanel.class, (String)"MSG_InvalidTitle");
        }
        return null;
    }

    public String getWarningMessage() {
        if (!StringUtils.hasText((String)this.getPhpDocTarget())) {
            return NbBundle.getMessage(PhpDocPanel.class, (String)"MSG_NbWillAskForDir");
        }
        return null;
    }

    public void storeData() {
        PhpDocPreferences.setPhpDocTarget(this.phpModule, this.getPhpDocTarget());
        PhpDocPreferences.setPhpDocTitle(this.phpModule, this.getPhpDocTitle());
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetTextField = new JTextField();
        this.targetButton = new JButton();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.targetLabel.setLabelFor(this.targetTextField);
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.targetButton, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.targetButton.text"));
        this.targetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpDocPanel.this.targetButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setLabelFor(this.titleTextField);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.titleLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetLabel).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.targetTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetButton)).addComponent(this.titleTextField, -1, 112, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetLabel).addComponent(this.targetTextField, -2, -1, -2).addComponent(this.targetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void targetButtonActionPerformed(ActionEvent evt) {
        File phpDocTarget = new FileChooserBuilder(PhpDocumentorProvider.class.getName() + ".phpdoc.dir" + this.phpModule.getName()).setTitle(NbBundle.getMessage(PhpDocPanel.class, (String)"LBL_SelectDocFolder")).setDirectoriesOnly(true).setFileHiding(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (phpDocTarget != null) {
            phpDocTarget = FileUtil.normalizeFile((File)phpDocTarget);
            this.targetTextField.setText(phpDocTarget.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            PhpDocPanel.this.fireChange();
        }
    }
}

