/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class MavenSharabilityQueryImpl
implements SharabilityQueryImplementation2 {
    private final Project project;

    public MavenSharabilityQueryImpl(Project proj) {
        this.project = proj;
    }

    public SharabilityQuery.Sharability getSharability(URI uri) {
        File target;
        MavenProject proj;
        Build build;
        File file = FileUtil.normalizeFile((File)Utilities.toFile((URI)uri));
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null && fo.equals(this.project.getProjectDirectory())) {
            return SharabilityQuery.Sharability.MIXED;
        }
        File basedir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (!file.getAbsolutePath().startsWith(basedir.getAbsolutePath())) {
            return SharabilityQuery.Sharability.UNKNOWN;
        }
        if (basedir.equals(file.getParentFile())) {
            M2ConfigProvider configs;
            if (file.getName().equals("pom.xml")) {
                return SharabilityQuery.Sharability.SHARABLE;
            }
            if ("nbproject".equals(file.getName())) {
                return SharabilityQuery.Sharability.NOT_SHARABLE;
            }
            if (file.getName().startsWith("nbactions") && (configs = (M2ConfigProvider)this.project.getLookup().lookup(M2ConfigProvider.class)) != null) {
                Collection<M2Configuration> col = configs.getNonSharedConfigurations();
                for (M2Configuration conf : col) {
                    if (!file.getName().equals(M2Configuration.getFileNameExt(conf.getId()))) continue;
                    return SharabilityQuery.Sharability.NOT_SHARABLE;
                }
            }
            if (file.getName().equals("src")) {
                return SharabilityQuery.Sharability.SHARABLE;
            }
        }
        if ((build = (proj = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject()).getBuild()) != null && build.getDirectory() != null && ((target = new File(build.getDirectory())).equals(file) || file.getAbsolutePath().startsWith(target.getAbsolutePath()))) {
            return SharabilityQuery.Sharability.NOT_SHARABLE;
        }
        if (file.isDirectory()) {
            return SharabilityQuery.Sharability.MIXED;
        }
        return SharabilityQuery.Sharability.UNKNOWN;
    }
}

