/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.netbeans.modules.db.dataview.table.ResultSetTableCellEditor;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.netbeans.modules.db.dataview.util.TimestampType;

public class DateTimePickerCellEditor
extends ResultSetTableCellEditor {
    private Timestamp initialValue;
    private DateFormat dateFormat;

    public DateTimePickerCellEditor() {
        this(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public DateTimePickerCellEditor(DateFormat dateFormat) {
        super(new JTextField());
        this.dateFormat = dateFormat != null ? dateFormat : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    @Override
    public Timestamp getCellEditorValue() {
        Date parsedTimestamp = TimestampType.doParse((String)super.getCellEditorValue());
        if (parsedTimestamp != null) {
            return new Timestamp(parsedTimestamp.getTime());
        }
        return this.initialValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, "", isSelected, row, column);
        JTextField jtf = (JTextField)c;
        this.initialValue = this.getValueAsTimestamp(value);
        jtf.setText(this.dateFormat.format(this.initialValue));
        if (suppressEditorBorder) {
            jtf.setBorder(BorderFactory.createEmptyBorder());
        }
        return c;
    }

    protected Timestamp getValueAsTimestamp(Object value) {
        if (this.isEmpty(value) || DataViewUtils.isSQLConstantString(value, null)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTime().getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof String) {
            try {
                return new Timestamp(this.dateFormat.parse((String)value).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Timestamp(System.currentTimeMillis());
    }

    protected boolean isEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).length() == 0;
    }

    public void addKeyListener(KeyListener kl) {
        ((JTextField)this.getComponent()).addKeyListener(kl);
    }
}

