/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.models;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleScope;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariableImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableHTMLModel;
import org.netbeans.spi.viewmodel.TableHTMLModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class TruffleVariablesTableModel
implements TableModelFilter,
TableHTMLModelFilter {
    private final JPDADebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public TruffleVariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof TruffleScope) {
            return "";
        }
        TruffleVariable tv = null;
        if (node instanceof JPDAWatch) {
            Object orig = original.getValueAt(node, columnID);
            if (node instanceof Variable) {
                tv = TruffleVariableImpl.get((Variable)node);
            }
            if (tv == null) {
                return orig;
            }
        } else if (node instanceof TruffleVariable) {
            tv = (TruffleVariable)node;
        }
        if (tv != null) {
            switch (columnID) {
                case "LocalsType": 
                case "WatchType": {
                    return tv.getType();
                }
                case "LocalsValue": 
                case "WatchValue": {
                    return tv.getValue();
                }
                case "LocalsToString": 
                case "WatchToString": {
                    Object var = tv.getValue();
                    return String.valueOf(var);
                }
            }
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof TruffleScope) {
            return true;
        }
        if (node instanceof TruffleVariable) {
            if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
                return !((TruffleVariable)node).isWritable();
            }
            return true;
        }
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        if (node instanceof TruffleVariable) {
            boolean success;
            boolean bl = success = ((TruffleVariable)node).setValue(this.debugger, value.toString()) != null;
            if (success) {
                ModelEvent.NodeChanged evt = new ModelEvent.NodeChanged((Object)this, node);
                for (ModelListener l : this.listeners) {
                    l.modelChanged((ModelEvent)evt);
                }
            }
        } else {
            original.setValueAt(node, columnID, value);
        }
    }

    public boolean hasHTMLValueAt(TableHTMLModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof TruffleVariable) {
            return false;
        }
        return original.hasHTMLValueAt(node, columnID);
    }

    public String getHTMLValueAt(TableHTMLModel original, Object node, String columnID) throws UnknownTypeException {
        return original.getHTMLValueAt(node, columnID);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }
}

