/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.modules.java.openjdk.project.ModuleDescription;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;

public class SubProjectProviderImpl
implements SubprojectProvider {
    private final JDKProject project;

    public SubProjectProviderImpl(JDKProject project) {
        this.project = project;
    }

    public Set<? extends Project> getSubprojects() {
        if (this.project.currentModule == null) {
            return Collections.emptySet();
        }
        HashSet<Project> subprojects = new HashSet<Project>();
        for (ModuleDescription.Dependency depend : this.project.currentModule.depend) {
            FileObject dependRoot = this.project.moduleRepository.findModuleRoot(depend.moduleName);
            if (dependRoot == null) continue;
            try {
                subprojects.add(ProjectManager.getDefault().findProject(dependRoot));
            }
            catch (IOException | IllegalArgumentException ex) {
                Logger.getLogger(SubProjectProviderImpl.class.getName()).log(Level.FINE, null, ex);
            }
        }
        return subprojects;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

