/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class Utilities {
    private Utilities() {
    }

    public static final boolean featureNotFoundDialog(FeatureInfo featureInfo, String featureName) {
        String notFound = NbBundle.getMessage(Utilities.class, (String)"LBL_FeatureNotFound");
        return Utilities.featureDialog(featureInfo, notFound, featureName);
    }

    public static final boolean featureDialog(final FeatureInfo featureInfo, final String notFoundMessage, final String featureName) {
        final CountDownLatch called = new CountDownLatch(1);
        final boolean[] result = new boolean[]{false};
        final DialogDescriptor[] descriptor = new DialogDescriptor[1];
        final Callable<JComponent> call = new Callable<JComponent>(){

            @Override
            public JComponent call() throws Exception {
                result[0] = true;
                called.countDown();
                descriptor[0].setValue(DialogDescriptor.CLOSED_OPTION);
                return new JPanel();
            }
        };
        final ConfigurationPanel[] arr = new ConfigurationPanel[1];
        descriptor[0] = (DialogDescriptor)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DialogDescriptor>(){

            public DialogDescriptor run() {
                arr[0] = new ConfigurationPanel(featureName, call, featureInfo);
                return new DialogDescriptor((Object)arr[0], notFoundMessage);
            }
        });
        descriptor[0].setOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        if (!GraphicsEnvironment.isHeadless()) {
            final Dialog d = DialogDisplayer.getDefault().createDialog(descriptor[0]);
            descriptor[0].addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    d.setVisible(false);
                    d.dispose();
                }
            });
            d.setVisible(true);
        } else {
            try {
                called.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result[0];
    }
}

