/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ide.ergonomics.Utilities;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.netbeans.modules.ide.ergonomics.fod.OpenAdvancedAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class FodDataObjectFactory
implements DataObject.Factory {
    private static MultiFileLoader delegate;
    private static final Set<FileObject> ignore;
    private final FileObject definition;
    private final FeatureInfo info;

    private FodDataObjectFactory(FileObject fo) {
        this.definition = fo;
        this.info = FoDLayersProvider.getInstance().whichProvides(this.definition);
    }

    public static DataObject.Factory create(FileObject fo) {
        return new FodDataObjectFactory(fo);
    }

    public DataObject findDataObject(FileObject fo, Set<? super FileObject> recognized) throws IOException {
        if (fo.isFolder()) {
            return null;
        }
        if (this.info != null && this.info.isEnabled()) {
            return null;
        }
        if (fo.getMIMEType().endsWith("+xml")) {
            OpenAdvancedAction.registerCandidate(fo);
            return null;
        }
        if (ignore.contains(fo)) {
            return null;
        }
        if (delegate == null) {
            Enumeration en = DataLoaderPool.getDefault().allLoaders();
            while (en.hasMoreElements()) {
                DataLoader d = (DataLoader)en.nextElement();
                if (!(d instanceof MultiFileLoader)) continue;
                delegate = (MultiFileLoader)d;
            }
            assert (delegate instanceof MultiFileLoader);
        }
        return new Cookies(fo, delegate);
    }

    static {
        ignore = new WeakSet();
    }

    private final class Cookies
    extends MultiDataObject
    implements OpenCookie,
    EditCookie,
    ChangeListener {
        private final FileObject fo;
        private final ChangeListener weakL;
        private boolean open;

        private Cookies(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
            super(fo, loader);
            this.fo = fo;
            this.weakL = WeakListeners.change((ChangeListener)this, (Object)FeatureManager.getInstance());
            FeatureManager.getInstance().addChangeListener(this.weakL);
        }

        protected Node createNodeDelegate() {
            DataNode dn = new DataNode((DataObject)this, Children.LEAF);
            dn.setIconBaseWithExtension("org/netbeans/modules/ide/ergonomics/fod/file.png");
            return dn;
        }

        public Lookup getLookup() {
            return this.getCookieSet().getLookup();
        }

        public void open() {
            this.delegate(true);
        }

        public void edit() {
            this.delegate(false);
        }

        private void delegate(boolean open) {
            FeatureInfo info = FoDLayersProvider.getInstance().whichProvides(FodDataObjectFactory.this.definition);
            String msg = NbBundle.getMessage(FodDataObjectFactory.class, (String)"MSG_Opening_File", (Object)this.fo.getNameExt());
            FoDLayersProvider.LOG.log(Level.FINER, "Opening file {0}", this);
            this.open = open;
            boolean success = Utilities.featureDialog(info, msg, msg);
            if (success) {
                this.finishOpen();
            }
        }

        private void finishOpen() {
            ignore.add(this.getPrimaryFile());
            try {
                DataObject obj = DataObject.find((FileObject)this.fo);
                FoDLayersProvider.LOG.log(Level.FINER, "finishOpen {0}", obj);
                Class what = this.open ? OpenCookie.class : EditCookie.class;
                Object oc = obj.getLookup().lookup(what);
                if (oc == this) {
                    obj.setValid(false);
                    obj = DataObject.find((FileObject)this.fo);
                    oc = obj.getLookup().lookup(what);
                }
                if (oc instanceof OpenCookie) {
                    ((OpenCookie)oc).open();
                }
                if (oc instanceof EditCookie) {
                    ((EditCookie)oc).edit();
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FeatureInfo info = FoDLayersProvider.getInstance().whichProvides(FodDataObjectFactory.this.definition);
            FoDLayersProvider.LOG.log(Level.FINER, "Refresh state of {0}", this);
            ignore.add(this.getPrimaryFile());
            if (info == null || info.isEnabled()) {
                this.dispose();
            }
        }
    }
}

