/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.Lookup;

public abstract class PatternConvertor {
    @CheckForNull
    protected abstract Iterable<? extends HintDescription> parseString(@NonNull String var1);

    @CheckForNull
    public static Iterable<? extends HintDescription> create(@NonNull String code) {
        ArrayList<String> patterns = new ArrayList<String>();
        if (code.contains(";;")) {
            PatternConvertor c = (PatternConvertor)Lookup.getDefault().lookup(PatternConvertor.class);
            if (c != null) {
                return c.parseString(code);
            }
            for (String string : code.split(";;")) {
                String string2 = string.trim();
                if (string2.isEmpty()) continue;
                patterns.add(string2);
            }
        } else {
            patterns.add(code);
        }
        ArrayList<HintDescription> result = new ArrayList<HintDescription>(patterns.size());
        for (String string : patterns) {
            Trigger.PatternDescription pd = Trigger.PatternDescription.create(string, Collections.emptyMap(), new String[0]);
            HintDescription hintDescription = HintDescriptionFactory.create().setTrigger(pd).setWorker(new WorkerImpl()).produce();
            result.add(hintDescription);
        }
        return result;
    }

    private static final class WorkerImpl
    implements HintDescription.Worker {
        private WorkerImpl() {
        }

        @Override
        public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
            ErrorDescription ed = ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), "Found pattern occurrence", new Fix[0]);
            return Collections.singleton(ed);
        }
    }
}

