/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.xml.tools.java.generator.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

public final class GenerationUtils {
    static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";
    private final WorkingCopy copy;

    private GenerationUtils(WorkingCopy copy) {
        this.copy = copy;
    }

    public static GenerationUtils newInstance(WorkingCopy copy) {
        Parameters.notNull((CharSequence)"copy", (Object)copy);
        return new GenerationUtils(copy);
    }

    public static FileObject createClass(FileObject targetFolder, String className, String javadoc) throws IOException {
        return GenerationUtils.createClass(CLASS_TEMPLATE, targetFolder, className, javadoc, Collections.emptyMap());
    }

    public static FileObject createClass(String template, FileObject targetFolder, String className, String javadoc, Map parameters) throws IOException {
        Parameters.notNull((CharSequence)"template", (Object)template);
        Parameters.notNull((CharSequence)"targetFolder", (Object)targetFolder);
        Parameters.javaIdentifier((CharSequence)"className", (CharSequence)className);
        FileObject classFO = GenerationUtils.createDataObjectFromTemplate(template, targetFolder, className, parameters).getPrimaryFile();
        return classFO;
    }

    public static FileObject createInterface(FileObject targetFolder, String interfaceName, String javadoc) throws IOException {
        return GenerationUtils.createClass(INTERFACE_TEMPLATE, targetFolder, interfaceName, javadoc, Collections.emptyMap());
    }

    private static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String targetName, Map parameters) throws IOException {
        assert (template != null);
        assert (targetFolder != null);
        assert (targetName != null && targetName.trim().length() > 0);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        return templateDO.createFromTemplate(dataFolder, targetName, parameters);
    }

    public Tree createType(String typeName, TypeElement scope) {
        TreeMaker make = this.getTreeMaker();
        TypeKind primitiveTypeKind = null;
        if ("boolean".equals(typeName)) {
            primitiveTypeKind = TypeKind.BOOLEAN;
        } else if ("byte".equals(typeName)) {
            primitiveTypeKind = TypeKind.BYTE;
        } else if ("short".equals(typeName)) {
            primitiveTypeKind = TypeKind.SHORT;
        } else if ("int".equals(typeName)) {
            primitiveTypeKind = TypeKind.INT;
        } else if ("long".equals(typeName)) {
            primitiveTypeKind = TypeKind.LONG;
        } else if ("char".equals(typeName)) {
            primitiveTypeKind = TypeKind.CHAR;
        } else if ("float".equals(typeName)) {
            primitiveTypeKind = TypeKind.FLOAT;
        } else if ("double".equals(typeName)) {
            primitiveTypeKind = TypeKind.DOUBLE;
        } else if ("void".equals(typeName)) {
            primitiveTypeKind = TypeKind.VOID;
        }
        if (primitiveTypeKind != null) {
            return this.getTreeMaker().PrimitiveType(primitiveTypeKind);
        }
        Tree typeTree = this.makeQualIdent(typeName);
        if (typeTree == null) {
            TypeMirror typeMirror = this.copy.getTreeUtilities().parseType(typeName, scope);
            typeTree = make.Type(typeMirror);
        }
        return typeTree;
    }

    public ModifiersTree createModifiers(Modifier modifier) {
        return this.getTreeMaker().Modifiers(EnumSet.of(modifier), Collections.emptyList());
    }

    public ClassTree ensureNoArgConstructor(ClassTree classTree) {
        TypeElement typeElement = SourceUtils.classTree2TypeElement((CompilationController)this.copy, classTree);
        if (typeElement == null) {
            throw new IllegalArgumentException("No TypeElement for ClassTree " + classTree.getSimpleName());
        }
        ExecutableElement constructor = SourceUtils.getNoArgConstructor((CompilationController)this.copy, typeElement);
        MethodTree constructorTree = constructor != null ? this.copy.getTrees().getTree(constructor) : null;
        MethodTree newConstructorTree = null;
        TreeMaker make = this.getTreeMaker();
        if (constructor != null) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                ModifiersTree oldModifiersTree = constructorTree.getModifiers();
                EnumSet<Modifier> newModifiers = EnumSet.of(Modifier.PUBLIC);
                newConstructorTree = make.Constructor(make.Modifiers(newModifiers), constructorTree.getTypeParameters(), constructorTree.getParameters(), constructorTree.getThrows(), constructorTree.getBody());
            }
        } else {
            newConstructorTree = make.Constructor(this.createModifiers(Modifier.PUBLIC), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ }");
        }
        ClassTree newClassTree = classTree;
        if (newConstructorTree != null) {
            if (constructorTree != null) {
                newClassTree = make.removeClassMember(newClassTree, (Tree)constructorTree);
            }
            newClassTree = make.addClassMember(newClassTree, (Tree)newConstructorTree);
        }
        return newClassTree;
    }

    public MethodTree createAssignmentConstructor(ModifiersTree modifiersTree, String constructorName, List parameters) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"constructorName", (CharSequence)constructorName);
        Parameters.notNull((CharSequence)"parameters", (Object)parameters);
        StringBuilder body = new StringBuilder(parameters.size() * 30);
        body.append("{");
        for (int i = 0; i < parameters.size(); ++i) {
            VariableTree parameter = (VariableTree)parameters.get(i);
            String parameterName = parameter.getName().toString();
            body.append("this." + parameterName + " = " + parameterName + ";");
        }
        body.append("}");
        TreeMaker make = this.getTreeMaker();
        return make.Constructor(modifiersTree, Collections.emptyList(), parameters, Collections.emptyList(), body.toString());
    }

    public MethodTree createConstructor(ModifiersTree modifiersTree, String constructorName, List parameters, String body) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"constructorName", (CharSequence)constructorName);
        Parameters.notNull((CharSequence)"parameters", (Object)parameters);
        TreeMaker make = this.getTreeMaker();
        return make.Constructor(modifiersTree, Collections.emptyList(), parameters, Collections.emptyList(), body);
    }

    public VariableTree createField(TypeElement scope, ModifiersTree modifiersTree, String fieldName, String fieldType, ExpressionTree expressionTree) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"fieldName", (CharSequence)fieldName);
        Parameters.notNull((CharSequence)"fieldType", (Object)fieldType);
        return this.getTreeMaker().Variable(modifiersTree, (CharSequence)fieldName, this.createType(fieldType, scope), expressionTree);
    }

    public VariableTree createVariable(TypeElement scope, String variableName, String variableType) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)variableName);
        Parameters.notNull((CharSequence)"variableType", (Object)variableType);
        return this.createField(scope, this.createEmptyModifiers(), variableName, variableType, null);
    }

    public VariableTree createVariable(String variableName, Tree variableType) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)variableName);
        Parameters.notNull((CharSequence)"variableType", (Object)variableType);
        return this.getTreeMaker().Variable(this.createEmptyModifiers(), (CharSequence)variableName, variableType, null);
    }

    public ClassTree addClassFields(ClassTree classTree, List fieldTrees) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"fieldTrees", (Object)fieldTrees);
        int firstNonFieldIndex = 0;
        Iterator<? extends Tree> memberTrees = classTree.getMembers().iterator();
        while (memberTrees.hasNext() && memberTrees.next().getKind() == Tree.Kind.VARIABLE) {
            ++firstNonFieldIndex;
        }
        TreeMaker make = this.getTreeMaker();
        ClassTree newClassTree = classTree;
        for (int i = 0; i < fieldTrees.size(); ++i) {
            VariableTree fieldTree = (VariableTree)fieldTrees.get(i);
            newClassTree = make.insertClassMember(newClassTree, firstNonFieldIndex, (Tree)fieldTree);
            ++firstNonFieldIndex;
        }
        return newClassTree;
    }

    public ClassTree addImplementsClause(ClassTree classTree, String interfaceType) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"interfaceType", (Object)interfaceType);
        ExpressionTree interfaceTree = this.createQualIdent(interfaceType);
        return this.getTreeMaker().addClassImplementsClause(classTree, (Tree)interfaceTree);
    }

    private TreeMaker getTreeMaker() {
        return this.copy.getTreeMaker();
    }

    private ModifiersTree createEmptyModifiers() {
        return this.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList());
    }

    public ExpressionTree createQualIdent(String typeName) {
        ExpressionTree qualIdent = this.makeQualIdent(typeName);
        if (qualIdent == null) {
            throw new IllegalArgumentException("Cannot create a QualIdent for " + typeName);
        }
        return qualIdent;
    }

    public ExpressionTree makeQualIdent(String typeClass) {
        TypeElement type = this.copy.getElements().getTypeElement(typeClass);
        if (type != null) {
            return this.getTreeMaker().QualIdent((Element)type);
        }
        return null;
    }

    public static String findJavaPackage(FileObject fo) {
        assert (fo.isFolder()) : fo;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        return cp.getResourceName(fo, '.', false);
    }
}

