/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;

public final class ExistsExpression
extends AbstractSingleEncapsulatedExpression {
    private String notIdentifier;

    public ExistsExpression(AbstractExpression parent) {
        super(parent, "EXISTS");
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String getEncapsulatedExpressionQueryBNFId() {
        return "subquery";
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("exists_expression");
    }

    public boolean hasNot() {
        return this.notIdentifier != null;
    }

    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIgnoreCase('N')) {
            int position = wordParser.position();
            this.notIdentifier = wordParser.substring(position, position + 3);
            this.setText("NOT EXISTS");
        }
        super.parse(wordParser, tolerant);
    }

    protected AbstractExpression parse(WordParser wordParser, String queryBNFId, boolean tolerant) {
        if (tolerant) {
            return super.parse(wordParser, queryBNFId, tolerant);
        }
        SimpleSelectStatement expression = new SimpleSelectStatement(this);
        expression.parse(wordParser, tolerant);
        return expression;
    }
}

