/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifact;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifacts;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class Saas
implements Comparable<Saas> {
    public static final String PROP_PARENT_GROUP = "parentGroup";
    public static final String PROP_STATE = "saasState";
    public static final String NS_SAAS = "http://xml.netbeans.org/websvc/saas/services/1.0";
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_WADL = "http://research.sun.com/wadl/2006/10";
    public static final String NS_WADL_09 = "http://wadl.dev.java.net/2009/02";
    public static final String ARTIFACT_TYPE_LIBRARY = "library";
    private static final String JAVA_TARGETS = "java,servlet,resource,jsp";
    private static final String PHP_TARGETS = "php";
    public static final String[] SUPPORTED_TARGETS = new String[]{"java,servlet,resource,jsp", "php"};
    public static final String WSDL_EXT = "wsdl";
    public static final String WADL_EXT = "wadl";
    public static final String ASMX_EXT = "asmx";
    public static final String XML_EXT = "xml";
    public static final String[] SUPPORTED_EXTENSIONS = new String[]{"wsdl", "wadl", "asmx", "xml"};
    protected final SaasServices delegate;
    private SaasGroup parentGroup;
    private SaasGroup topGroup;
    private List<SaasMethod> saasMethods;
    private State state = State.UNINITIALIZED;
    protected FileObject saasFolder;
    private boolean userDefined = true;
    private List<FileObject> libraryJars;
    protected FileObject saasFile;
    private Properties props;
    public static final String SAAS_PROPERTIES = "saas.properties";
    public static final String PROP_LOCAL_SERVICE_FILE = "local.service.file";
    private FileObject propFile;

    public Saas(SaasGroup parentGroup, SaasServices services) {
        this.delegate = services;
        this.parentGroup = parentGroup;
    }

    public Saas(SaasGroup parent, String url, String displayName, String packageName) {
        this.delegate = new SaasServices();
        this.delegate.setUrl(url);
        this.delegate.setDisplayName(displayName);
        SaasMetadata m = new SaasMetadata();
        this.delegate.setSaasMetadata(m);
        SaasMetadata.CodeGen cg = new SaasMetadata.CodeGen();
        this.updateArtifacts(cg);
        cg.setPackageName(packageName);
        m.setCodeGen(cg);
        this.setParentGroup(parent);
        this.computePathFromRoot();
    }

    public SaasServices getDelegate() {
        return this.delegate;
    }

    public SaasGroup getParentGroup() {
        return this.parentGroup;
    }

    protected void setParentGroup(SaasGroup parentGroup) {
        this.parentGroup = parentGroup;
    }

    public SaasGroup getTopLevelGroup() {
        if (this.topGroup == null && this.parentGroup != null) {
            this.topGroup = this.parentGroup;
            while (this.topGroup != null && this.topGroup.getParent() != SaasServicesModel.getInstance().getRootGroup()) {
                this.topGroup = this.topGroup.getParent();
            }
            if (this.topGroup == null) {
                this.topGroup = SaasServicesModel.getInstance().getRootGroup();
            }
        }
        return this.topGroup;
    }

    protected void computePathFromRoot() {
        this.delegate.getSaasMetadata().setGroup(this.parentGroup.getPathFromRoot());
    }

    public FileObject getSaasFile() throws IOException {
        if (this.saasFile == null) {
            FileObject folder = this.getSaasFolder();
            String filename = folder.getName() + "-saas.xml";
            this.saasFile = folder.getFileObject(filename);
            if (this.saasFile == null) {
                this.saasFile = this.getSaasFolder().createData(filename);
            }
        }
        return this.saasFile;
    }

    public void save() {
        block6: {
            try {
                SaasUtil.saveSaas(this, this.getSaasFile());
                if (this.getProperties().size() <= 0) break block6;
                OutputStream out = null;
                try {
                    out = this.getPropFile(true).getOutputStream();
                    this.getProperties().store(out, this.getDisplayName() + " : " + this.getUrl());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    protected void setUserDefined(boolean v) {
        if (this.userDefined) {
            this.userDefined = v;
        }
    }

    public String getUrl() {
        return this.delegate.getUrl();
    }

    public State getState() {
        return this.state;
    }

    protected synchronized void setState(State v) {
        State old = this.state;
        this.state = v;
        SaasServicesModel.getInstance().fireChange(PROP_STATE, this, (Object)old, (Object)this.state);
    }

    public void toStateReady(boolean synchronous) {
        if (synchronous) {
            this.setState(this.state);
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Saas.this.setState(State.READY);
                }
            });
        }
    }

    public SaasMetadata getSaasMetadata() {
        return this.delegate.getSaasMetadata();
    }

    public List<SaasMethod> getMethods() {
        if (this.saasMethods == null) {
            this.saasMethods = new ArrayList<SaasMethod>();
            if (this.delegate.getMethods() != null && this.delegate.getMethods().getMethod() != null) {
                for (Method m : this.delegate.getMethods().getMethod()) {
                    this.saasMethods.add(this.createSaasMethod(m));
                }
            }
        }
        return new ArrayList<SaasMethod>(this.saasMethods);
    }

    protected SaasMethod createSaasMethod(Method method) {
        return new SaasMethod(this, method);
    }

    public SaasServices.Header getHeader() {
        return this.delegate.getHeader();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getApiDoc() {
        return this.delegate.getApiDoc();
    }

    public synchronized FileObject getSaasFolder() {
        if (this.saasFolder == null) {
            String folderName = SaasUtil.toValidJavaName(this.getDisplayName());
            this.saasFolder = SaasServicesModel.getWebServiceHome().getFileObject(folderName);
            if (this.saasFolder == null) {
                try {
                    this.saasFolder = SaasServicesModel.getWebServiceHome().createFolder(folderName);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return this.saasFolder;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected void refresh() {
        this.setState(State.INITIALIZING);
        this.saasMethods = null;
    }

    private Properties getProperties() throws IOException {
        if (this.props == null) {
            this.props = new Properties();
            FileObject fo = this.getPropFile(false);
            if (fo != null) {
                InputStream in = this.getPropFile(false).getInputStream();
                try {
                    this.props.load(in);
                }
                finally {
                    in.close();
                }
            }
        }
        return this.props;
    }

    private FileObject getPropFile(boolean create) throws IOException {
        if (this.propFile == null) {
            this.propFile = this.getSaasFolder().getFileObject(SAAS_PROPERTIES);
            if (this.propFile == null && create) {
                this.propFile = this.getSaasFolder().createData(SAAS_PROPERTIES);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.propFile;
    }

    protected String getProperty(String name) {
        try {
            return this.getProperties().getProperty(name);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    protected void setProperty(String name, String value) {
        try {
            this.getProperties().setProperty(name, value);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public List<FileObject> getLibraryJars() {
        if (this.getState() != State.READY) {
            throw new IllegalStateException("Should only access libraries when in ready state");
        }
        if (this.libraryJars == null) {
            this.libraryJars = new ArrayList<FileObject>();
            if (this.getSaasMetadata() != null && this.getSaasMetadata().getCodeGen() != null) {
                for (Artifacts arts : this.getSaasMetadata().getCodeGen().getArtifacts()) {
                    for (Artifact art : arts.getArtifact()) {
                        if (!ARTIFACT_TYPE_LIBRARY.equals(art.getType())) continue;
                        try {
                            URL url = new URL(art.getUrl());
                            this.libraryJars.add(FileUtil.toFileObject((File)new File(url.toURI())));
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.libraryJars);
    }

    public String getPackageName() {
        return SaasUtil.deriveDefaultPackageName(this);
    }

    public void upgrade() {
        SaasMetadata.CodeGen cg;
        if (!this.userDefined) {
            return;
        }
        boolean needsSave = false;
        SaasMetadata m = this.delegate.getSaasMetadata();
        if (m == null) {
            m = new SaasMetadata();
            this.delegate.setSaasMetadata(m);
            needsSave = true;
        }
        if ((cg = m.getCodeGen()) == null) {
            cg = new SaasMetadata.CodeGen();
            m.setCodeGen(cg);
            needsSave = true;
        }
        if (this.updateArtifacts(cg)) {
            needsSave = true;
        }
        if (needsSave) {
            this.save();
        }
    }

    private boolean updateArtifacts(SaasMetadata.CodeGen cg) {
        List<Artifacts> list = cg.getArtifacts();
        int size = list.size();
        boolean needsSave = false;
        for (int i = 0; i < SUPPORTED_TARGETS.length; ++i) {
            Artifacts artifacts = null;
            String targets = SUPPORTED_TARGETS[i];
            if (i < size) {
                artifacts = list.get(i);
                if (targets.equals(artifacts.getTargets())) continue;
                artifacts.setTargets(targets);
                needsSave = true;
                continue;
            }
            artifacts = new Artifacts();
            artifacts.setTargets(targets);
            list.add(artifacts);
            needsSave = true;
        }
        return needsSave;
    }

    @Override
    public int compareTo(Saas saas) {
        return this.getDisplayName().compareTo(saas.getDisplayName());
    }

    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        RETRIEVED,
        READY,
        REMOVED;

    }
}

