/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class LaunchingDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-LaunchingDICookie";
    private LaunchingConnector launchingConnector;
    private Map<String, ? extends Connector.Argument> args;
    private String mainClassName;
    private boolean suspend;

    private LaunchingDICookie(LaunchingConnector launchingConnector, Map<String, ? extends Connector.Argument> args, String mainClassName, boolean suspend) {
        this.launchingConnector = launchingConnector;
        this.args = args;
        this.mainClassName = mainClassName;
        this.suspend = suspend;
    }

    public static LaunchingDICookie create(String mainClassName, String commandLine, String address, boolean suspend) {
        return new LaunchingDICookie(LaunchingDICookie.findLaunchingConnector(), LaunchingDICookie.getArgs(commandLine, address), mainClassName, suspend);
    }

    public static LaunchingDICookie create(String mainClassName, String[] args, String classPath, boolean suspend) {
        StringBuilder argss = new StringBuilder();
        int k = args.length;
        for (int i = 0; i < k; ++i) {
            argss.append(" \"").append(args[i]).append("\"");
        }
        String commandLine = System.getProperty("java.home") + "\\bin\\java -agentlib:jdwp=transport=" + LaunchingDICookie.getTransportName() + ",address=name,suspend=" + (suspend ? "y" : "n") + " -classpath \"" + classPath + "\" " + mainClassName + argss;
        String address = "name";
        return new LaunchingDICookie(LaunchingDICookie.findLaunchingConnector(), LaunchingDICookie.getArgs(commandLine, address), mainClassName, suspend);
    }

    public static String getTransportName() {
        return LaunchingDICookie.findLaunchingConnector().transport().name();
    }

    public String getClassName() {
        return this.mainClassName;
    }

    public boolean getSuspend() {
        return this.suspend;
    }

    public String getCommandLine() {
        Connector.Argument a = this.args.get("command");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    @Override
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException, VMStartException {
        return this.launchingConnector.launch(this.args);
    }

    private static Map<String, ? extends Connector.Argument> getArgs(String commandLine, String address) {
        Map<String, Connector.Argument> args = LaunchingDICookie.findLaunchingConnector().defaultArguments();
        args.get("command").setValue(commandLine);
        args.get("address").setValue(address);
        return args;
    }

    private static LaunchingConnector findLaunchingConnector() {
        for (LaunchingConnector lc : Bootstrap.virtualMachineManager().launchingConnectors()) {
            if (lc.name().indexOf("RawCommandLineLaunch") <= -1) continue;
            return lc;
        }
        return null;
    }
}

