/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.parser.PHPDocCommentParser;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class DeclarationFinderImpl
implements DeclarationFinder {
    private static final RequestProcessor RP = new RequestProcessor(DeclarationFinderImpl.class);
    private static final Logger LOGGER = Logger.getLogger(DeclarationFinderImpl.class.getName());
    private static final int RESOLVING_TIMEOUT = 300;

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        return DeclarationFinderImpl.findDeclarationImpl(info, caretOffset);
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        OffsetRange offsetRange = OffsetRange.NONE;
        Future crateFuture = RP.submit((Callable)new ReferenceSpanCrateFetcher(Source.create((Document)doc)));
        try {
            ReferenceSpanCrate crate = (ReferenceSpanCrate)crateFuture.get(300L, TimeUnit.MILLISECONDS);
            if (crate != null) {
                Model model = crate.getModel();
                TokenHierarchy<?> tokenHierarchy = crate.getTokenHierarchy();
                if (model != null && tokenHierarchy != null) {
                    TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(tokenHierarchy, caretOffset);
                    offsetRange = DeclarationFinderImpl.getReferenceSpan(ts, caretOffset, model);
                }
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Resolving of reference span offset range has been interrupted.");
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.SEVERE, "Exception has been thrown during resolving of reference span offset range.", ex);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.FINE, "Timeout for resolving reference span offset range has been exceed: {0}", 300);
        }
        return offsetRange;
    }

    public static OffsetRange getReferenceSpan(TokenSequence<PHPTokenId> ts, int caretOffset, Model model) {
        Parameters.notNull((CharSequence)"ts", (Object)model);
        Parameters.notNull((CharSequence)"model", (Object)model);
        return new ReferenceSpanFinder(model).getReferenceSpan(ts, caretOffset);
    }

    public static DeclarationFinder.DeclarationLocation findDeclarationImpl(ParserResult info, int caretOffset) {
        if (!(info instanceof PHPParseResult)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        PHPParseResult result = (PHPParseResult)info;
        Model model = result.getModel(Model.Type.COMMON);
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(caretOffset);
        Occurence underCaret = occurencesSupport.getOccurence();
        return DeclarationFinderImpl.findDeclarationImpl(underCaret, info);
    }

    private static DeclarationFinder.DeclarationLocation findDeclarationImpl(Occurence underCaret, ParserResult info) {
        DeclarationFinder.DeclarationLocation location = DeclarationFinder.DeclarationLocation.NONE;
        if (underCaret != null) {
            Collection<? extends PhpElement> gotoDeclarations = underCaret.gotoDeclarations();
            if (gotoDeclarations == null || gotoDeclarations.isEmpty()) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            PhpElement declaration = gotoDeclarations.iterator().next();
            FileObject declarationFo = declaration.getFileObject();
            if (declarationFo == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            location = new DeclarationFinder.DeclarationLocation(declarationFo, declaration.getOffset(), (ElementHandle)declaration);
            Collection<? extends PhpElement> alternativeDeclarations = gotoDeclarations;
            if (alternativeDeclarations.size() > 1) {
                FileObject currentFile = info.getSnapshot().getSource().getFileObject();
                int numberOfCurrentDeclaration = 0;
                DeclarationFinder.DeclarationLocation alternatives = DeclarationFinder.DeclarationLocation.NONE;
                for (PhpElement phpElement : alternativeDeclarations) {
                    FileObject elemFo = phpElement.getFileObject();
                    if (elemFo == null) continue;
                    DeclarationFinder.DeclarationLocation declLocation = new DeclarationFinder.DeclarationLocation(elemFo, phpElement.getOffset(), (ElementHandle)phpElement);
                    if (currentFile == elemFo) {
                        location = declLocation;
                        ++numberOfCurrentDeclaration;
                    }
                    AlternativeLocationImpl al = new AlternativeLocationImpl(phpElement, declLocation);
                    if (alternatives == DeclarationFinder.DeclarationLocation.NONE) {
                        alternatives = al.getLocation();
                    }
                    alternatives.addAlternative((DeclarationFinder.AlternativeLocation)al);
                }
                return numberOfCurrentDeclaration == 1 && !EnumSet.of(Occurence.Accuracy.MORE_TYPES, Occurence.Accuracy.MORE).contains((Object)underCaret.degreeOfAccuracy()) ? location : alternatives;
            }
        }
        return location;
    }

    public static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private PhpElement modelElement;
        private DeclarationFinder.DeclarationLocation declaration;

        public AlternativeLocationImpl(PhpElement modelElement, DeclarationFinder.DeclarationLocation declaration) {
            this.modelElement = modelElement;
            this.declaration = declaration;
        }

        public ElementHandle getElement() {
            return this.modelElement;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.reset();
            ElementKind ek = this.modelElement.getKind();
            formatter.name(ek, true);
            if (this.modelElement instanceof FullyQualifiedElement && !((FullyQualifiedElement)this.modelElement).getNamespaceName().isDefaultNamespace()) {
                QualifiedName namespaceName = ((FullyQualifiedElement)this.modelElement).getNamespaceName();
                formatter.appendText(namespaceName.append(this.modelElement.getName()).toString());
            } else {
                formatter.appendText(this.modelElement.getName());
            }
            formatter.name(ek, false);
            if (this.declaration.getFileObject() != null) {
                formatter.appendText(" in ");
                formatter.appendText(FileUtil.getFileDisplayName((FileObject)this.declaration.getFileObject()));
            }
            return formatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.declaration;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            AlternativeLocationImpl i = (AlternativeLocationImpl)o;
            return this.modelElement.getName().compareTo(i.modelElement.getName());
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (this.modelElement != null ? this.modelElement.hashCode() : 0);
            hash = 89 * hash + (this.declaration != null ? this.declaration.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AlternativeLocationImpl other = (AlternativeLocationImpl)obj;
            if (!(this.modelElement == other.modelElement || this.modelElement != null && this.modelElement.equals(other.modelElement))) {
                return false;
            }
            return this.declaration == other.declaration || this.declaration != null && this.declaration.equals(other.declaration);
        }
    }

    private static class ReferenceSpanFinder {
        private static final int RECURSION_LIMIT = 100;
        private static final Pattern INLINE_PHP_VAR_COMMENT_PATTERN = Pattern.compile("^[ \t]*@var[ \t]+.+[ \t]+\\$.+$");
        private static final Logger LOGGER = Logger.getLogger(DeclarationFinderImpl.class.getName());
        private int recursionCounter = 0;
        private final Model model;

        public ReferenceSpanFinder(Model model) {
            this.model = model;
        }

        public OffsetRange getReferenceSpan(TokenSequence<PHPTokenId> ts, int caretOffset) {
            if (ts == null) {
                return OffsetRange.NONE;
            }
            ts.move(caretOffset);
            int startTSOffset = 0;
            if (ts.moveNext()) {
                OffsetRange offsetRange;
                startTSOffset = ts.offset();
                Token token = ts.token();
                PHPTokenId id = (PHPTokenId)token.id();
                if (id.equals((Object)PHPTokenId.PHP_STRING) || id.equals((Object)PHPTokenId.PHP_VARIABLE)) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                if (id.equals((Object)PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING)) {
                    OffsetRange retval = new OffsetRange(ts.offset(), ts.offset() + token.length());
                    int maxForgingTokens = 4;
                    for (int i = 0; i < maxForgingTokens && ts.movePrevious(); ++i) {
                        token = ts.token();
                        id = (PHPTokenId)token.id();
                        if (id.equals((Object)PHPTokenId.PHP_INCLUDE) || id.equals((Object)PHPTokenId.PHP_INCLUDE_ONCE) || id.equals((Object)PHPTokenId.PHP_REQUIRE) || id.equals((Object)PHPTokenId.PHP_REQUIRE_ONCE)) {
                            return retval;
                        }
                        if (!id.equals((Object)PHPTokenId.PHP_STRING) || !token.text().toString().equalsIgnoreCase("define")) continue;
                        return retval;
                    }
                } else if (id.equals((Object)PHPTokenId.PHPDOC_COMMENT)) {
                    OffsetRange offsetRange2;
                    String tokenText = token.text().toString();
                    if (INLINE_PHP_VAR_COMMENT_PATTERN.matcher(tokenText).matches() && (offsetRange2 = this.getVarCommentOffsetRange(ts, tokenText, caretOffset)) != null) {
                        return offsetRange2;
                    }
                    PHPDocCommentParser docParser = new PHPDocCommentParser();
                    PHPDocBlock docBlock = docParser.parse(ts.offset() - 3, ts.offset() + token.length(), token.text().toString());
                    ASTNode[] hierarchy = Utils.getNodeHierarchyAtOffset(docBlock, caretOffset);
                    PhpDocTypeTagInfo node = null;
                    if (hierarchy != null && hierarchy.length > 0) {
                        if (hierarchy[0] instanceof PHPDocTypeTag) {
                            PHPDocTypeTag typeTag = (PHPDocTypeTag)hierarchy[0];
                            if (typeTag.getStartOffset() <= caretOffset && caretOffset <= typeTag.getEndOffset()) {
                                VariableScope scope = this.model.getVariableScope(caretOffset);
                                List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create(typeTag, ASTNodeInfo.Kind.CLASS, scope);
                                for (PhpDocTypeTagInfo phpDocTypeTagInfo : tagInfos) {
                                    if (phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.CLASS) && phpDocTypeTagInfo.getRange().containsInclusive(caretOffset)) {
                                        node = phpDocTypeTagInfo;
                                        break;
                                    }
                                    if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.USE_ALIAS) || !phpDocTypeTagInfo.getRange().containsInclusive(caretOffset)) continue;
                                    node = phpDocTypeTagInfo;
                                    break;
                                }
                                if (node == null || !node.getRange().containsInclusive(caretOffset)) {
                                    tagInfos = PhpDocTypeTagInfo.create(typeTag, ASTNodeInfo.Kind.VARIABLE, scope);
                                    for (PhpDocTypeTagInfo phpDocTypeTagInfo : tagInfos) {
                                        if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                                        node = phpDocTypeTagInfo;
                                        break;
                                    }
                                }
                                if (node != null) {
                                    return node.getRange().containsInclusive(caretOffset) ? node.getRange() : OffsetRange.NONE;
                                }
                            }
                        } else {
                            List<PHPDocTag> tags = docBlock.getTags();
                            for (PHPDocTag phpDocTag : tags) {
                                PHPDocMethodTag methodTag;
                                MagicMethodDeclarationInfo magicMethodDeclarationInfo;
                                if (!(phpDocTag instanceof PHPDocMethodTag) || (magicMethodDeclarationInfo = MagicMethodDeclarationInfo.create(methodTag = (PHPDocMethodTag)phpDocTag)) == null) continue;
                                if (magicMethodDeclarationInfo.getRange().containsInclusive(caretOffset)) {
                                    return magicMethodDeclarationInfo.getRange();
                                }
                                if (!magicMethodDeclarationInfo.getTypeRange().containsInclusive(caretOffset)) continue;
                                return magicMethodDeclarationInfo.getTypeRange();
                            }
                        }
                    }
                } else if (id.equals((Object)PHPTokenId.PHP_COMMENT) && token.text() != null && (offsetRange = this.getVarCommentOffsetRange(ts, token.text().toString(), caretOffset)) != null) {
                    return offsetRange;
                }
            }
            if (caretOffset == startTSOffset) {
                if (this.recursionCounter < 100) {
                    ++this.recursionCounter;
                    return this.getReferenceSpan(ts, caretOffset - 1);
                }
                this.logRecursion(ts);
            }
            return OffsetRange.NONE;
        }

        @CheckForNull
        private OffsetRange getVarCommentOffsetRange(TokenSequence<PHPTokenId> ts, String text, int caretOffset) {
            String dollaredVar = "@var";
            if (text.contains("@var")) {
                String[] segments = text.split("[ \t]+");
                for (int i = 0; i < segments.length; ++i) {
                    String seg = segments[i];
                    if (!seg.equals("@var") || segments.length <= i + 2) continue;
                    for (int j = 1; j <= 2; ++j) {
                        OffsetRange range;
                        seg = segments[i + j];
                        if (seg == null || seg.trim().length() <= 0) continue;
                        int indexOf = text.indexOf(seg);
                        assert (indexOf != -1);
                        if (!(range = new OffsetRange(indexOf += ts.offset(), indexOf + seg.length())).containsInclusive(caretOffset)) continue;
                        return range;
                    }
                    return OffsetRange.NONE;
                }
            }
            return null;
        }

        private void logRecursion(TokenSequence<PHPTokenId> ts) {
            CharSequence tokenText = null;
            if (ts != null) {
                Token token = ts.token();
                tokenText = token != null ? token.text() : "Possibly between tokens";
            }
            LOGGER.log(Level.WARNING, "Stack overflow detection - limit: {0}, token: {1}", new Object[]{100, tokenText});
        }
    }

    private static class ReferenceSpanCrateFetcher
    implements Callable<ReferenceSpanCrate> {
        private final Source source;

        public ReferenceSpanCrateFetcher(Source source) {
            this.source = source;
        }

        @Override
        public ReferenceSpanCrate call() throws Exception {
            final ReferenceSpanCrate crate = new ReferenceSpanCrate();
            ParserManager.parse(Collections.singletonList(this.source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parserResult = resultIterator.getParserResult();
                    if (parserResult instanceof PHPParseResult) {
                        PHPParseResult phpParserResult = (PHPParseResult)parserResult;
                        crate.setModel(phpParserResult.getModel(Model.Type.COMMON));
                        crate.setTokenHierarchy(resultIterator.getSnapshot().getTokenHierarchy());
                    }
                }
            });
            return crate;
        }
    }

    private static class ReferenceSpanCrate {
        private Model model;
        private TokenHierarchy<?> tokenHierarchy;

        private ReferenceSpanCrate() {
        }

        @CheckForNull
        public Model getModel() {
            return this.model;
        }

        @CheckForNull
        public TokenHierarchy<?> getTokenHierarchy() {
            return this.tokenHierarchy;
        }

        public void setModel(Model model) {
            this.model = model;
        }

        public void setTokenHierarchy(TokenHierarchy<?> tokenHierarchy) {
            this.tokenHierarchy = tokenHierarchy;
        }
    }
}

